"""
Snowflake Services API.

The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class ServiceRoleGrantTo(BaseModel):
    """A model object representing the ServiceRoleGrantTo resource.

    Constructs an object of type ServiceRoleGrantTo with the provided properties.

    Parameters
    __________
    created_on : datetime, optional
        Date and time when the grant was created
    privilege : str, optional
        The name of the privilege
    granted_on : str, optional
        The type of of the securable
    name : str, optional
        The name of the securable
    granted_to : str, optional
        The type of the grantee
    grantee_name : str, optional
        The name of the grantee
    """

    created_on: Optional[datetime] = None

    privilege: Optional[StrictStr] = None

    granted_on: Optional[StrictStr] = None

    name: Optional[StrictStr] = None

    granted_to: Optional[StrictStr] = None

    grantee_name: Optional[StrictStr] = None

    __properties = ["created_on", "privilege", "granted_on", "name", "granted_to", "grantee_name"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceRoleGrantTo:
        """Create an instance of ServiceRoleGrantTo from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "privilege",
                    "granted_on",
                    "name",
                    "granted_to",
                    "grantee_name",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceRoleGrantTo:
        """Create an instance of ServiceRoleGrantTo from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceRoleGrantTo.parse_obj(obj)

        _obj = ServiceRoleGrantTo.parse_obj(
            {
                "created_on": obj.get("created_on"),
                "privilege": obj.get("privilege"),
                "granted_on": obj.get("granted_on"),
                "name": obj.get("name"),
                "granted_to": obj.get("granted_to"),
                "grantee_name": obj.get("grantee_name"),
            }
        )

        return _obj


class ServiceRoleGrantToModel:
    def __init__(
        self,  # optional properties
        created_on: Optional[datetime] = None,
        privilege: Optional[str] = None,
        granted_on: Optional[str] = None,
        name: Optional[str] = None,
        granted_to: Optional[str] = None,
        grantee_name: Optional[str] = None,
    ):
        """A model object representing the ServiceRoleGrantTo resource.

        Constructs an object of type ServiceRoleGrantTo with the provided properties.

        Parameters
        __________
        created_on : datetime, optional
            Date and time when the grant was created
        privilege : str, optional
            The name of the privilege
        granted_on : str, optional
            The type of of the securable
        name : str, optional
            The name of the securable
        granted_to : str, optional
            The type of the grantee
        grantee_name : str, optional
            The name of the grantee
        """
        self.created_on = created_on
        self.privilege = privilege
        self.granted_on = granted_on
        self.name = name
        self.granted_to = granted_to
        self.grantee_name = grantee_name

    __properties = ["created_on", "privilege", "granted_on", "name", "granted_to", "grantee_name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceRoleGrantTo(
            created_on=self.created_on,
            privilege=self.privilege,
            granted_on=self.granted_on,
            name=self.name,
            granted_to=self.granted_to,
            grantee_name=self.grantee_name,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceRoleGrantToModel:
        return ServiceRoleGrantToModel(
            created_on=model.created_on,
            privilege=model.privilege,
            granted_on=model.granted_on,
            name=model.name,
            granted_to=model.granted_to,
            grantee_name=model.grantee_name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ServiceRoleGrantTo.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceRoleGrantTo object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceRoleGrantToModel:
        """Create an instance of ServiceRoleGrantTo from a dict.

        This method constructs a ServiceRoleGrantTo object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceRoleGrantTo
            A ServiceRoleGrantTo object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceRoleGrantTo.from_dict(obj))


ServiceRoleGrantTo._model_class = ServiceRoleGrantToModel
