"""
Snowflake Session API.

The Snowflake Session API is a REST API that you can use to query your current session properties.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictStr


class CurrentSecondaryRoles(BaseModel):
    """A model object representing the CurrentSecondaryRoles resource.

    Constructs an object of type CurrentSecondaryRoles with the provided properties.

    Parameters
    __________
    roles : str, optional

    value : str, optional
    """

    roles: Optional[StrictStr] = None

    value: Optional[StrictStr] = None

    __properties = ["roles", "value"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CurrentSecondaryRoles:
        """Create an instance of CurrentSecondaryRoles from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CurrentSecondaryRoles:
        """Create an instance of CurrentSecondaryRoles from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CurrentSecondaryRoles.parse_obj(obj)

        _obj = CurrentSecondaryRoles.parse_obj(
            {
                "roles": obj.get("roles"),
                "value": obj.get("value"),
            }
        )

        return _obj


class CurrentSecondaryRolesModel:
    def __init__(
        self,  # optional properties
        roles: Optional[str] = None,
        value: Optional[str] = None,
    ):
        """A model object representing the CurrentSecondaryRoles resource.

        Constructs an object of type CurrentSecondaryRoles with the provided properties.

        Parameters
        __________
        roles : str, optional

        value : str, optional
        """
        self.roles = roles
        self.value = value

    __properties = ["roles", "value"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CurrentSecondaryRoles(
            roles=self.roles,
            value=self.value,
        )

    @classmethod
    def _from_model(cls, model) -> CurrentSecondaryRolesModel:
        return CurrentSecondaryRolesModel(
            roles=model.roles,
            value=model.value,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CurrentSecondaryRoles.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CurrentSecondaryRoles object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CurrentSecondaryRolesModel:
        """Create an instance of CurrentSecondaryRoles from a dict.

        This method constructs a CurrentSecondaryRoles object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CurrentSecondaryRoles
            A CurrentSecondaryRoles object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CurrentSecondaryRoles.from_dict(obj))


CurrentSecondaryRoles._model_class = CurrentSecondaryRolesModel
