"""
Snowflake Session API.

The Snowflake Session API is a REST API that you can use to query your current session properties.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, StrictStr


class NamedDefault(BaseModel):
    """A model object representing the NamedDefault resource.

    Constructs an object of type NamedDefault with the provided properties.

    Parameters
    __________
    name : str
    """

    name: StrictStr

    __properties = ["name"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NamedDefault:
        """Create an instance of NamedDefault from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NamedDefault:
        """Create an instance of NamedDefault from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NamedDefault.parse_obj(obj)

        _obj = NamedDefault.parse_obj(
            {
                "name": obj.get("name"),
            }
        )

        return _obj


class NamedDefaultModel:
    def __init__(
        self,
        name: str,
        # optional properties
    ):
        """A model object representing the NamedDefault resource.

        Constructs an object of type NamedDefault with the provided properties.

        Parameters
        __________
        name : str
        """
        self.name = name

    __properties = ["name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NamedDefault(
            name=self.name,
        )

    @classmethod
    def _from_model(cls, model) -> NamedDefaultModel:
        return NamedDefaultModel(
            name=model.name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a NamedDefault.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NamedDefault object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NamedDefaultModel:
        """Create an instance of NamedDefault from a dict.

        This method constructs a NamedDefault object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NamedDefault
            A NamedDefault object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NamedDefault.from_dict(obj))


NamedDefault._model_class = NamedDefaultModel
