"""
Snowflake Stage API.

The Snowflake Stage API is a REST API that you can use to access, update, and perform certain actions on stage resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictInt


class PresignedUrlRequest(BaseModel):
    """A model object representing the PresignedUrlRequest resource.

    Constructs an object of type PresignedUrlRequest with the provided properties.

    Parameters
    __________
    expiration_time : int, optional
        Expiration time of the generated presigned url in seconds.
    """

    expiration_time: Optional[StrictInt] = None

    __properties = ["expiration_time"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PresignedUrlRequest:
        """Create an instance of PresignedUrlRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PresignedUrlRequest:
        """Create an instance of PresignedUrlRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PresignedUrlRequest.parse_obj(obj)

        _obj = PresignedUrlRequest.parse_obj(
            {
                "expiration_time": obj.get("expiration_time"),
            }
        )

        return _obj


class PresignedUrlRequestModel:
    def __init__(
        self,  # optional properties
        expiration_time: Optional[int] = None,
    ):
        """A model object representing the PresignedUrlRequest resource.

        Constructs an object of type PresignedUrlRequest with the provided properties.

        Parameters
        __________
        expiration_time : int, optional
            Expiration time of the generated presigned url in seconds.
        """
        self.expiration_time = expiration_time

    __properties = ["expiration_time"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PresignedUrlRequest(
            expiration_time=self.expiration_time,
        )

    @classmethod
    def _from_model(cls, model) -> PresignedUrlRequestModel:
        return PresignedUrlRequestModel(
            expiration_time=model.expiration_time,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PresignedUrlRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PresignedUrlRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PresignedUrlRequestModel:
        """Create an instance of PresignedUrlRequest from a dict.

        This method constructs a PresignedUrlRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PresignedUrlRequest
            A PresignedUrlRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PresignedUrlRequest.from_dict(obj))


PresignedUrlRequest._model_class = PresignedUrlRequestModel
