"""
Snowflake Stage API.

The Snowflake Stage API is a REST API that you can use to access, update, and perform certain actions on stage resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, StrictBool, StrictStr


class StageDirectoryTable(BaseModel):
    """A model object representing the StageDirectoryTable resource.

    Constructs an object of type StageDirectoryTable with the provided properties.

    Parameters
    __________
    enable : bool,  default False
        Specifies whether to add a directory table to the stage. When the value is TRUE, a directory table is created with the stage.
    refresh_on_create : bool,  default True
        Specifies whether to automatically refresh the directory table metadata once, immediately after the stage is created.
    auto_refresh : bool,  default False
        Specifies whether Snowflake should enable triggering automatic refreshes of the directory table metadata when new or updated data files are available in the named external stage specified in the URL value.
    notification_integration : str, optional
        Specifies the name of the notification integration used to automatically refresh the directory table metadata.
    """

    enable: Optional[StrictBool] = False

    refresh_on_create: Optional[StrictBool] = True

    auto_refresh: Optional[StrictBool] = False

    notification_integration: Optional[StrictStr] = None

    __properties = ["enable", "refresh_on_create", "auto_refresh", "notification_integration"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StageDirectoryTable:
        """Create an instance of StageDirectoryTable from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StageDirectoryTable:
        """Create an instance of StageDirectoryTable from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StageDirectoryTable.parse_obj(obj)

        _obj = StageDirectoryTable.parse_obj(
            {
                "enable": obj.get("enable") if obj.get("enable") is not None else False,
                "refresh_on_create": obj.get("refresh_on_create") if obj.get("refresh_on_create") is not None else True,
                "auto_refresh": obj.get("auto_refresh") if obj.get("auto_refresh") is not None else False,
                "notification_integration": obj.get("notification_integration"),
            }
        )

        return _obj


class StageDirectoryTableModel:
    def __init__(
        self,  # optional properties
        enable: Optional[bool] = False,
        refresh_on_create: Optional[bool] = True,
        auto_refresh: Optional[bool] = False,
        notification_integration: Optional[str] = None,
    ):
        """A model object representing the StageDirectoryTable resource.

        Constructs an object of type StageDirectoryTable with the provided properties.

        Parameters
        __________
        enable : bool,  default False
            Specifies whether to add a directory table to the stage. When the value is TRUE, a directory table is created with the stage.
        refresh_on_create : bool,  default True
            Specifies whether to automatically refresh the directory table metadata once, immediately after the stage is created.
        auto_refresh : bool,  default False
            Specifies whether Snowflake should enable triggering automatic refreshes of the directory table metadata when new or updated data files are available in the named external stage specified in the URL value.
        notification_integration : str, optional
            Specifies the name of the notification integration used to automatically refresh the directory table metadata.
        """
        self.enable = enable
        self.refresh_on_create = refresh_on_create
        self.auto_refresh = auto_refresh
        self.notification_integration = notification_integration

    __properties = ["enable", "refresh_on_create", "auto_refresh", "notification_integration"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StageDirectoryTable(
            enable=self.enable,
            refresh_on_create=self.refresh_on_create,
            auto_refresh=self.auto_refresh,
            notification_integration=self.notification_integration,
        )

    @classmethod
    def _from_model(cls, model) -> StageDirectoryTableModel:
        return StageDirectoryTableModel(
            enable=model.enable,
            refresh_on_create=model.refresh_on_create,
            auto_refresh=model.auto_refresh,
            notification_integration=model.notification_integration,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StageDirectoryTable.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StageDirectoryTable object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StageDirectoryTableModel:
        """Create an instance of StageDirectoryTable from a dict.

        This method constructs a StageDirectoryTable object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StageDirectoryTable
            A StageDirectoryTable object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StageDirectoryTable.from_dict(obj))


StageDirectoryTable._model_class = StageDirectoryTableModel
