"""
Snowflake Table API.

The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import json
import logging
import os
import re
import tempfile

from concurrent.futures import Future
from datetime import date, datetime
from typing import Iterable, Literal, Optional, Union, overload

from dateutil.parser import parse
from pydantic import Field, StrictBool, StrictStr, validate_call
from typing_extensions import Annotated

import snowflake.core._http_requests

from snowflake.core._generated import rest
from snowflake.core._generated.api_client import ApiClient
from snowflake.core._internal.utils import is_running_inside_stored_procedure
from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError,
    _APIValueError,
)
from snowflake.core.table._generated import models
from snowflake.core.table._generated.models.success_response import SuccessResponse
from snowflake.core.table._generated.models.table import Table
from snowflake.core.table._generated.models.table_as_select import TableAsSelect
from snowflake.core.table._generated.models.table_clone import TableClone
from snowflake.core.table._generated.models.table_like import TableLike
from snowflake.core.table._generated.models.table_using_template import TableUsingTemplate


logger = logging.getLogger(__name__)


class TableApi:
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = "table"
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default()

    @property
    def api_client(self):
        return self._api_client

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if isinstance(klass, str):
            if klass.startswith("Iterable["):
                sub_kls = re.match(r"Iterable\[(.*)]", klass).group(1)
                return [self.__deserialize(sub_data, sub_kls) for sub_data in data]

            if klass.startswith("Dict["):
                sub_kls = re.match(r"Dict\[([^,]*), (.*)]", klass).group(2)
                return {k: self.__deserialize(v, sub_kls) for k, v in data.items()}

            # convert str to class
            if klass in snowflake.core._http_requests.NATIVE_TYPES_MAPPING:
                klass = snowflake.core._http_requests.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in snowflake.core._http_requests.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:  # noqa: E721
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def __deserialize_file(self, response):
        """Deserializes body to file.

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.api_client.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=f"Failed to parse `{string}` as date object")

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=(f"Failed to parse `{string}` as datetime object"))

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        return klass.from_dict(data)

    @overload
    def create_or_alter_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table: Table,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_or_alter_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table: Table,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_or_alter_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table: Table,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_or_alter_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table: Table,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a (or alter an existing) table.  # noqa: E501

        Create a (or alter an existing) table. Even if the operation is just an alter, the full property set must be provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_table(database, var_schema, name, table, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param table: (required)
        :type table: Table
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_or_alter_table_with_http_info(database, var_schema, name, table, **kwargs)

    @validate_call
    def create_or_alter_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table: Table,
        **kwargs,
    ):
        r"""Create a (or alter an existing) table.  # noqa: E501

        Create a (or alter an existing) table. Even if the operation is just an alter, the full property set must be provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_table_with_http_info(database, var_schema, name, table, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param table: (required)
        :type table: Table
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "table"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_or_alter_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table"]:
            _body_params = _params["table"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table (clone and undrop are separate subresources)  # noqa: E501

        Create a table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table(database, var_schema, table, create_mode, copy_grants, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param table: (required)
        :type table: Table
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_with_http_info(database, var_schema, table, create_mode, copy_grants, **kwargs)

    @validate_call
    def create_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a table (clone and undrop are separate subresources)  # noqa: E501

        Create a table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_with_http_info(
        ...     database, var_schema, table, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param table: (required)
        :type table: Table
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "table", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table"]:
            _body_params = _params["table"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table_as_select(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table_as_select: TableAsSelect,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table_as_select(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table_as_select: TableAsSelect,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table_as_select(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table_as_select: TableAsSelect,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table_as_select(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table_as_select: TableAsSelect,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table using the result of the specified select query  # noqa: E501

        Create a table as select.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_as_select(
        ...     database, var_schema, query, table_as_select, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param query: The SQL select query to run to set up the table values (and possibly columns). (required)
        :type query: str
        :param table_as_select: (required)
        :type table_as_select: TableAsSelect
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_as_select_with_http_info(
            database, var_schema, query, table_as_select, create_mode, copy_grants, **kwargs
        )

    @validate_call
    def create_table_as_select_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table_as_select: TableAsSelect,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a table using the result of the specified select query  # noqa: E501

        Create a table as select.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_as_select_with_http_info(
        ...     database, var_schema, query, table_as_select, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param query: The SQL select query to run to set up the table values (and possibly columns). (required)
        :type query: str
        :param table_as_select: (required)
        :type table_as_select: TableAsSelect
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "query", "table_as_select", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_table_as_select")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        if _params.get("query") is not None:
            _query_params.append(("query", _params["query"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table_as_select"]:
            _body_params = _params["table_as_select"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables:as-select",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table_as_select_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table_as_select_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table_as_select_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table_as_select_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table using the result of the specified select query  # noqa: E501

        Create a table as select.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_as_select_deprecated(
        ...     database, var_schema, name, query, table, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param query: The SQL select query to run to set up the table values (and possibly columns). (required)
        :type query: str
        :param table: (required)
        :type table: Table
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_as_select_deprecated_with_http_info(
            database, var_schema, name, query, table, create_mode, copy_grants, **kwargs
        )

    @validate_call
    def create_table_as_select_deprecated_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(description="The SQL select query to run to set up the table values (and possibly columns)."),
        ],
        table: Table,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a table using the result of the specified select query  # noqa: E501

        Create a table as select.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_as_select_deprecated_with_http_info(
        ...     database, var_schema, name, query, table, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param query: The SQL select query to run to set up the table values (and possibly columns). (required)
        :type query: str
        :param table: (required)
        :type table: Table
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "query", "table", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method create_table_as_select_deprecated"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        if _params.get("query") is not None:
            _query_params.append(("query", _params["query"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table"]:
            _body_params = _params["table"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:as_select",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table_like(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_like: TableLike,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table_like(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_like: TableLike,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table_like(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_like: TableLike,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table_like(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_like: TableLike,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table like this existing one  # noqa: E501

        Create a new table like the specified resource, but empty  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_like(
        ...     database, var_schema, name, table_like, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param table_like: (required)
        :type table_like: TableLike
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_like_with_http_info(
            database, var_schema, name, table_like, create_mode, copy_grants, **kwargs
        )

    @validate_call
    def create_table_like_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_like: TableLike,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a table like this existing one  # noqa: E501

        Create a new table like the specified resource, but empty  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_like_with_http_info(
        ...     database, var_schema, name, table_like, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param table_like: (required)
        :type table_like: TableLike
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "table_like", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_table_like")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table_like"]:
            _body_params = _params["table_like"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:create-like",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table_like_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        new_table_name: Annotated[StrictStr, Field(description="The name of the table to be created.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table_like_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        new_table_name: Annotated[StrictStr, Field(description="The name of the table to be created.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table_like_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        new_table_name: Annotated[StrictStr, Field(description="The name of the table to be created.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table_like_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        new_table_name: Annotated[StrictStr, Field(description="The name of the table to be created.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table like this existing one  # noqa: E501

        Create a new table like the specified resource, but empty  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_like_deprecated(
        ...     database, var_schema, name, new_table_name, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param new_table_name: The name of the table to be created. (required)
        :type new_table_name: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_like_deprecated_with_http_info(
            database, var_schema, name, new_table_name, create_mode, copy_grants, **kwargs
        )

    @validate_call
    def create_table_like_deprecated_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        new_table_name: Annotated[StrictStr, Field(description="The name of the table to be created.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a table like this existing one  # noqa: E501

        Create a new table like the specified resource, but empty  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_like_deprecated_with_http_info(
        ...     database, var_schema, name, new_table_name, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param new_table_name: The name of the table to be created. (required)
        :type new_table_name: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "new_table_name", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method create_table_like_deprecated"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        if _params.get("new_table_name") is not None:
            _query_params.append(("newTableName", _params["new_table_name"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:create_like",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table_using_template(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        table_using_template: Optional[TableUsingTemplate] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table_using_template(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        table_using_template: Optional[TableUsingTemplate] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table_using_template(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        table_using_template: Optional[TableUsingTemplate] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table_using_template(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        table_using_template: Optional[TableUsingTemplate] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table using the templates specified in staged files  # noqa: E501

        Create a table using template.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_using_template(
        ...     database, var_schema, query, create_mode, copy_grants, table_using_template, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param query: The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table. (required)
        :type query: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param table_using_template:
        :type table_using_template: TableUsingTemplate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_using_template_with_http_info(
            database, var_schema, query, create_mode, copy_grants, table_using_template, **kwargs
        )

    @validate_call
    def create_table_using_template_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        table_using_template: Optional[TableUsingTemplate] = None,
        **kwargs,
    ):
        r"""Create a table using the templates specified in staged files  # noqa: E501

        Create a table using template.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_using_template_with_http_info(
        ...     database, var_schema, query, create_mode, copy_grants, table_using_template, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param query: The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table. (required)
        :type query: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param table_using_template:
        :type table_using_template: TableUsingTemplate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "query", "create_mode", "copy_grants", "table_using_template"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method create_table_using_template"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        if _params.get("query") is not None:
            _query_params.append(("query", _params["query"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table_using_template"]:
            _body_params = _params["table_using_template"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables:using-template",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_table_using_template_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_table_using_template_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_table_using_template_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_table_using_template_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a table using the templates specified in staged files  # noqa: E501

        Create a table using template.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_using_template_deprecated(
        ...     database, var_schema, name, query, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param query: The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table. (required)
        :type query: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_using_template_deprecated_with_http_info(
            database, var_schema, name, query, create_mode, copy_grants, **kwargs
        )

    @validate_call
    def create_table_using_template_deprecated_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        query: Annotated[
            StrictStr,
            Field(
                description="The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table."
            ),
        ],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a table using the templates specified in staged files  # noqa: E501

        Create a table using template.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_table_using_template_deprecated_with_http_info(
        ...     database, var_schema, name, query, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param query: The SQL query that uses INFER_SCHEMA on staged files to set the column definitions for the new table. (required)
        :type query: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "query", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method create_table_using_template_deprecated"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        if _params.get("query") is not None:
            _query_params.append(("query", _params["query"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:using_template",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def clone_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_clone: TableClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the newly created table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the newly created table. Defaults to the source table's schema."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def clone_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_clone: TableClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the newly created table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the newly created table. Defaults to the source table's schema."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def clone_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_clone: TableClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the newly created table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the newly created table. Defaults to the source table's schema."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def clone_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_clone: TableClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the newly created table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the newly created table. Defaults to the source table's schema."),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Clone table  # noqa: E501

        Create a new table by cloning from the specified resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.clone_table(
        ...     database,
        ...     var_schema,
        ...     name,
        ...     table_clone,
        ...     create_mode,
        ...     copy_grants,
        ...     target_database,
        ...     target_schema,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param table_clone: (required)
        :type table_clone: TableClone
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param target_database: Database of the newly created table. Defaults to the source table's database.
        :type target_database: str
        :param target_schema: Schema of the newly created table. Defaults to the source table's schema.
        :type target_schema: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.clone_table_with_http_info(
            database, var_schema, name, table_clone, create_mode, copy_grants, target_database, target_schema, **kwargs
        )

    @validate_call
    def clone_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        table_clone: TableClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the newly created table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the newly created table. Defaults to the source table's schema."),
        ] = None,
        **kwargs,
    ):
        r"""Clone table  # noqa: E501

        Create a new table by cloning from the specified resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.clone_table_with_http_info(
        ...     database,
        ...     var_schema,
        ...     name,
        ...     table_clone,
        ...     create_mode,
        ...     copy_grants,
        ...     target_database,
        ...     target_schema,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param table_clone: (required)
        :type table_clone: TableClone
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: Union[CreateMode, str]
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param target_database: Database of the newly created table. Defaults to the source table's database.
        :type target_database: str
        :param target_schema: Schema of the newly created table. Defaults to the source table's schema.
        :type target_schema: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = [
            "database",
            "var_schema",
            "name",
            "table_clone",
            "create_mode",
            "copy_grants",
            "target_database",
            "target_schema",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method clone_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        if _params.get("target_database") is not None:
            _query_params.append(("targetDatabase", _params["target_database"]))

        if _params.get("target_schema") is not None:
            _query_params.append(("targetSchema", _params["target_schema"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["table_clone"]:
            _body_params = _params["table_clone"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:clone",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def fetch_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Table: ...

    @overload
    def fetch_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Table]: ...

    @overload
    def fetch_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[Table, Future[Table]]: ...

    @validate_call
    def fetch_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        **kwargs,
    ) -> Union[Table, Future[Table]]:
        r"""Fetch a table.  # noqa: E501

        Fetch a Table using the describe command output.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_table(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Table, Future[Table]]
        """
        kwargs["_return_http_data_only"] = True
        return self.fetch_table_with_http_info(database, var_schema, name, **kwargs)

    @validate_call
    def fetch_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        **kwargs,
    ):
        r"""Fetch a table.  # noqa: E501

        Fetch a Table using the describe command output.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_table_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Table, Future[Table]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method fetch_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Table",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_tables(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dropped tables that have not yet been purged.")
        ] = None,
        deep: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dependency information of the table.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[Table]: ...

    @overload
    def list_tables(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dropped tables that have not yet been purged.")
        ] = None,
        deep: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dependency information of the table.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[Table]]: ...

    @overload
    def list_tables(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dropped tables that have not yet been purged.")
        ] = None,
        deep: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dependency information of the table.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[Table], Future[Iterable[Table]]]: ...

    @validate_call
    def list_tables(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dropped tables that have not yet been purged.")
        ] = None,
        deep: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dependency information of the table.")
        ] = None,
        **kwargs,
    ) -> Union[Iterable[Table], Future[Iterable[Table]]]:
        r"""List tables  # noqa: E501

        Lists the tables under the database and schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_tables(
        ...     database, var_schema, like, starts_with, show_limit, from_name, history, deep, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param history: Optionally includes dropped tables that have not yet been purged.
        :type history: bool
        :param deep: Optionally includes dependency information of the table.
        :type deep: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Table], Future[Iterable[Table]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_tables_with_http_info(
            database, var_schema, like, starts_with, show_limit, from_name, history, deep, **kwargs
        )

    @validate_call
    def list_tables_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dropped tables that have not yet been purged.")
        ] = None,
        deep: Annotated[
            Optional[StrictBool], Field(description="Optionally includes dependency information of the table.")
        ] = None,
        **kwargs,
    ):
        r"""List tables  # noqa: E501

        Lists the tables under the database and schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_tables_with_http_info(
        ...     database, var_schema, like, starts_with, show_limit, from_name, history, deep, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param history: Optionally includes dropped tables that have not yet been purged.
        :type history: bool
        :param deep: Optionally includes dependency information of the table.
        :type deep: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Table], Future[Iterable[Table]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "like", "starts_with", "show_limit", "from_name", "history", "deep"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_tables")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []

        if _params.get("like") is not None:
            _query_params.append(("like", _params["like"]))

        if _params.get("starts_with") is not None:
            _query_params.append(("startsWith", _params["starts_with"]))

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        if _params.get("from_name") is not None:
            _query_params.append(("fromName", _params["from_name"]))

        if _params.get("history") is not None:
            _query_params.append(("history", _params["history"]))

        if _params.get("deep") is not None:
            _query_params.append(("deep", _params["deep"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[Table]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def resume_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def resume_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def resume_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def resume_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Resume recluster of a table  # noqa: E501

        Resume recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_recluster_table(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.resume_recluster_table_with_http_info(database, var_schema, name, if_exists, **kwargs)

    @validate_call
    def resume_recluster_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Resume recluster of a table  # noqa: E501

        Resume recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_recluster_table_with_http_info(
        ...     database, var_schema, name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method resume_recluster_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:resume-recluster",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def resume_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def resume_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def resume_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def resume_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Resume recluster of a table  # noqa: E501

        Resume recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_recluster_table_deprecated(
        ...     database, var_schema, name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.resume_recluster_table_deprecated_with_http_info(database, var_schema, name, if_exists, **kwargs)

    @validate_call
    def resume_recluster_table_deprecated_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Resume recluster of a table  # noqa: E501

        Resume recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.resume_recluster_table_deprecated_with_http_info(
        ...     database, var_schema, name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method resume_recluster_table_deprecated"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:resume_recluster",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def suspend_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def suspend_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def suspend_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def suspend_recluster_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Suspend recluster of a table  # noqa: E501

        Suspend recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_recluster_table(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.suspend_recluster_table_with_http_info(database, var_schema, name, if_exists, **kwargs)

    @validate_call
    def suspend_recluster_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Suspend recluster of a table  # noqa: E501

        Suspend recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_recluster_table_with_http_info(
        ...     database, var_schema, name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method suspend_recluster_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:suspend-recluster",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def suspend_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def suspend_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def suspend_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def suspend_recluster_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Suspend recluster of a table  # noqa: E501

        Suspend recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_recluster_table_deprecated(
        ...     database, var_schema, name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.suspend_recluster_table_deprecated_with_http_info(database, var_schema, name, if_exists, **kwargs)

    @validate_call
    def suspend_recluster_table_deprecated_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Suspend recluster of a table  # noqa: E501

        Suspend recluster of a table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.suspend_recluster_table_deprecated_with_http_info(
        ...     database, var_schema, name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method suspend_recluster_table_deprecated"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:suspend_recluster",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def swap_with_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_name: Annotated[str, Field(strict=True, description="The name of the target table to be swapped with.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the target table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the target table. Defaults to the source table's schema."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def swap_with_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_name: Annotated[str, Field(strict=True, description="The name of the target table to be swapped with.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the target table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the target table. Defaults to the source table's schema."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def swap_with_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_name: Annotated[str, Field(strict=True, description="The name of the target table to be swapped with.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the target table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the target table. Defaults to the source table's schema."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def swap_with_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_name: Annotated[str, Field(strict=True, description="The name of the target table to be swapped with.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the target table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the target table. Defaults to the source table's schema."),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Swap with another table  # noqa: E501

        Swap with another table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.swap_with_table(
        ...     database,
        ...     var_schema,
        ...     name,
        ...     target_name,
        ...     if_exists,
        ...     target_database,
        ...     target_schema,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param target_name: The name of the target table to be swapped with. (required)
        :type target_name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param target_database: Database of the target table. Defaults to the source table's database.
        :type target_database: str
        :param target_schema: Schema of the target table. Defaults to the source table's schema.
        :type target_schema: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.swap_with_table_with_http_info(
            database, var_schema, name, target_name, if_exists, target_database, target_schema, **kwargs
        )

    @validate_call
    def swap_with_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_name: Annotated[str, Field(strict=True, description="The name of the target table to be swapped with.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Database of the target table. Defaults to the source table's database."),
        ] = None,
        target_schema: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(description="Schema of the target table. Defaults to the source table's schema."),
        ] = None,
        **kwargs,
    ):
        r"""Swap with another table  # noqa: E501

        Swap with another table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.swap_with_table_with_http_info(
        ...     database,
        ...     var_schema,
        ...     name,
        ...     target_name,
        ...     if_exists,
        ...     target_database,
        ...     target_schema,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param target_name: The name of the target table to be swapped with. (required)
        :type target_name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param target_database: Database of the target table. Defaults to the source table's database.
        :type target_database: str
        :param target_schema: Schema of the target table. Defaults to the source table's schema.
        :type target_schema: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "target_name", "if_exists", "target_database", "target_schema"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method swap_with_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        if _params.get("target_name") is not None:
            _query_params.append(("targetName", _params["target_name"]))

        if _params.get("target_database") is not None:
            _query_params.append(("targetDatabase", _params["target_database"]))

        if _params.get("target_schema") is not None:
            _query_params.append(("targetSchema", _params["target_schema"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:swap-with",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def swap_with_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_table_name: Annotated[
            StrictStr, Field(description="The fully-specified name of the target table to be swapped with.")
        ],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def swap_with_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_table_name: Annotated[
            StrictStr, Field(description="The fully-specified name of the target table to be swapped with.")
        ],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def swap_with_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_table_name: Annotated[
            StrictStr, Field(description="The fully-specified name of the target table to be swapped with.")
        ],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def swap_with_table_deprecated(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_table_name: Annotated[
            StrictStr, Field(description="The fully-specified name of the target table to be swapped with.")
        ],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Swap with another table  # noqa: E501

        Swap with another table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.swap_with_table_deprecated(
        ...     database, var_schema, name, target_table_name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param target_table_name: The fully-specified name of the target table to be swapped with. (required)
        :type target_table_name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.swap_with_table_deprecated_with_http_info(
            database, var_schema, name, target_table_name, if_exists, **kwargs
        )

    @validate_call
    def swap_with_table_deprecated_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        target_table_name: Annotated[
            StrictStr, Field(description="The fully-specified name of the target table to be swapped with.")
        ],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Swap with another table  # noqa: E501

        Swap with another table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.swap_with_table_deprecated_with_http_info(
        ...     database, var_schema, name, target_table_name, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param target_table_name: The fully-specified name of the target table to be swapped with. (required)
        :type target_table_name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "target_table_name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method swap_with_table_deprecated")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        if _params.get("target_table_name") is not None:
            _query_params.append(("targetTableName", _params["target_table_name"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:swapwith",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def undrop_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def undrop_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def undrop_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def undrop_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Undrop a table  # noqa: E501

        Undrop specified table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.undrop_table(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.undrop_table_with_http_info(database, var_schema, name, **kwargs)

    @validate_call
    def undrop_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        **kwargs,
    ):
        r"""Undrop a table  # noqa: E501

        Undrop specified table  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.undrop_table_with_http_info(database, var_schema, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method undrop_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}:undrop",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def delete_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def delete_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def delete_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def delete_table(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Delete a table  # noqa: E501

        Delete a table with the given name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_table(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_table_with_http_info(database, var_schema, name, if_exists, **kwargs)

    @validate_call
    def delete_table_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Delete a table  # noqa: E501

        Delete a table with the given name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_table_with_http_info(database, var_schema, name, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method delete_table")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/tables/{name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )
