"""
Snowflake Table API.

The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from snowflake.core.table._generated.models.constraint import Constraint


class PrimaryKey(Constraint):
    """A model object representing the PrimaryKey resource.

    Constructs an object of type PrimaryKey with the provided properties.

    Parameters
    __________

    name : str, optional
        Name of the Constraint

    column_names : list[str], optional
    """

    __properties = ["name", "column_names", "constraint_type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PrimaryKey:
        """Create an instance of PrimaryKey from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["constraint_type"] = Constraint.get_child_model_discriminator_value("PrimaryKey")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PrimaryKey:
        """Create an instance of PrimaryKey from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PrimaryKey.parse_obj(obj)

        _obj = PrimaryKey.parse_obj(
            {
                "name": obj.get("name"),
                "column_names": obj.get("column_names"),
            }
        )

        return _obj


class PrimaryKeyModel(Constraint):
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        column_names: Optional[list[str]] = None,
    ):
        """A model object representing the PrimaryKey resource.

        Constructs an object of type PrimaryKey with the provided properties.

        Parameters
        __________

        name : str, optional
            Name of the Constraint

        column_names : list[str], optional
        """
        super().__init__(
            name=name,
            column_names=column_names,
        )

    __properties = ["name", "column_names", "constraint_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PrimaryKey(
            name=self.name,
            column_names=self.column_names,
        )

    @classmethod
    def _from_model(cls, model) -> PrimaryKeyModel:
        return PrimaryKeyModel(
            name=model.name,
            column_names=model.column_names,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PrimaryKey.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PrimaryKey object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PrimaryKeyModel:
        """Create an instance of PrimaryKey from a dict.

        This method constructs a PrimaryKey object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PrimaryKey
            A PrimaryKey object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PrimaryKey.from_dict(obj))


PrimaryKey._model_class = PrimaryKeyModel
