"""
Snowflake Table API.

The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, StrictStr

from snowflake.core.table._generated.models.table_column import TableColumn, TableColumnModel


class TableAsSelect(BaseModel):
    """A model object representing the TableAsSelect resource.

    Constructs an object of type TableAsSelect with the provided properties.

    Parameters
    __________
    name : str, optional
        Specifies the name for the table, must be unique for the schema in which the table is created
    columns : list[TableColumn], optional

    cluster_by : list[str], optional
        Specifies one or more columns or column expressions in the table as the clustering key
    """

    name: Optional[StrictStr] = None

    columns: Optional[List[TableColumn]] = None

    cluster_by: Optional[List[StrictStr]] = None

    __properties = ["name", "columns", "cluster_by"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableAsSelect:
        """Create an instance of TableAsSelect from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict["columns"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableAsSelect:
        """Create an instance of TableAsSelect from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableAsSelect.parse_obj(obj)

        _obj = TableAsSelect.parse_obj(
            {
                "name": obj.get("name"),
                "columns": [TableColumn.from_dict(_item) for _item in obj.get("columns")]
                if obj.get("columns") is not None
                else None,
                "cluster_by": obj.get("cluster_by"),
            }
        )

        return _obj


class TableAsSelectModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        columns: Optional[list[TableColumn]] = None,
        cluster_by: Optional[list[str]] = None,
    ):
        """A model object representing the TableAsSelect resource.

        Constructs an object of type TableAsSelect with the provided properties.

        Parameters
        __________
        name : str, optional
            Specifies the name for the table, must be unique for the schema in which the table is created
        columns : list[TableColumn], optional

        cluster_by : list[str], optional
            Specifies one or more columns or column expressions in the table as the clustering key
        """
        self.name = name
        self.columns = columns
        self.cluster_by = cluster_by

    __properties = ["name", "columns", "cluster_by"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableAsSelect(
            name=self.name,
            columns=[x._to_model() for x in self.columns] if self.columns is not None else None,
            cluster_by=self.cluster_by,
        )

    @classmethod
    def _from_model(cls, model) -> TableAsSelectModel:
        return TableAsSelectModel(
            name=model.name,
            columns=[TableColumnModel._from_model(x) for x in model.columns] if model.columns else None,
            cluster_by=model.cluster_by,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TableAsSelect.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableAsSelect object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableAsSelectModel:
        """Create an instance of TableAsSelect from a dict.

        This method constructs a TableAsSelect object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableAsSelect
            A TableAsSelect object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableAsSelect.from_dict(obj))


TableAsSelect._model_class = TableAsSelectModel
