"""
Snowflake User API.

The Snowflake User API is a REST API that you can use to access, update, and perform certain action on Users in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, SecretStr, StrictBool, StrictInt, StrictStr, field_validator


class User(BaseModel):
    """A model object representing the User resource.

    Constructs an object of type User with the provided properties.

    Parameters
    __________
    name : str
        User name
    password : str, optional
        Password
    login_name : str, optional
        Login name
    display_name : str, optional
        Display name
    first_name : str, optional
        First name
    middle_name : str, optional
        Middle name
    last_name : str, optional
        Last name
    email : str, optional
        Email address
    must_change_password : bool, optional
        Does this user need to change their password (e.g., after assigning a temp password)
    disabled : bool, optional
        Has this user been disabled from the system
    days_to_expiry : int, optional
        How many days until this user expires
    mins_to_unlock : int, optional
        How many minutes until the account is unlocked after multiple failed logins
    default_warehouse : str, optional
        The default warehouse to use when this user starts a session
    default_namespace : str, optional
        The default namespace to use when this user starts a session
    default_role : str, optional
        The default role to use when this user starts a session
    default_secondary_roles : str,  default 'ALL'
        The default secondary roles of this user to use when starting a session. Only valid set values are ALL or NONE. Default is ALL after 2024-07 BCR.
    mins_to_bypass_mfa : int, optional
        How many minutes until MFA is required again
    rsa_public_key : str, optional
        RSA public key of the user
    rsa_public_key_2 : str, optional
        Second RSA public key of the user
    comment : str, optional
        Comment about the user.
    type : str, optional
        Indicates the type of user (PERSON | SERVICE | LEGACY_SERVICE)
    enable_unredacted_query_syntax_error : bool, optional
        Whether to show unredacted query syntax errors in the query history.
    network_policy : str, optional
        Specifies an existing network policy is active for the user. Otherwise, use account default.
    created_on : datetime, optional

    last_successful_login : datetime, optional

    expires_at : datetime, optional

    locked_until : datetime, optional

    has_password : bool, optional

    has_rsa_public_key : bool, optional

    rsa_public_key_fp : str, optional
        Fingerprint of the user's RSA public key
    rsa_public_key_2_fp : str, optional
        Fingerprint of the user's second RSA public key
    ext_authn_duo : bool, optional

    ext_authn_uid : str, optional

    owner : str, optional

    snowflake_lock : bool,  default False
        Whether the user, account, or organization is locked by Snowflake.
    snowflake_support : bool,  default False
        Whether Snowflake Support is allowed to use the user or account
    mins_to_bypass_network_policy : int, optional
        Temporary bypass network policy on the user for a specified number of minutes
    password_last_set : datetime, optional

    custom_landing_page_url : str, optional

    custom_landing_page_url_flush_next_ui_load : bool,  default False
        Whether or not to flush the custom landing page of the user on next UI load
    """

    name: StrictStr

    password: Optional[SecretStr] = None

    login_name: Optional[StrictStr] = None

    display_name: Optional[StrictStr] = None

    first_name: Optional[StrictStr] = None

    middle_name: Optional[StrictStr] = None

    last_name: Optional[StrictStr] = None

    email: Optional[StrictStr] = None

    must_change_password: Optional[StrictBool] = None

    disabled: Optional[StrictBool] = None

    days_to_expiry: Optional[StrictInt] = None

    mins_to_unlock: Optional[StrictInt] = None

    default_warehouse: Optional[StrictStr] = None

    default_namespace: Optional[StrictStr] = None

    default_role: Optional[StrictStr] = None

    default_secondary_roles: Optional[StrictStr] = "ALL"

    mins_to_bypass_mfa: Optional[StrictInt] = None

    rsa_public_key: Optional[StrictStr] = None

    rsa_public_key_2: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    type: Optional[StrictStr] = None

    enable_unredacted_query_syntax_error: Optional[StrictBool] = None

    network_policy: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    last_successful_login: Optional[datetime] = None

    expires_at: Optional[datetime] = None

    locked_until: Optional[datetime] = None

    has_password: Optional[StrictBool] = None

    has_rsa_public_key: Optional[StrictBool] = None

    rsa_public_key_fp: Optional[StrictStr] = None

    rsa_public_key_2_fp: Optional[StrictStr] = None

    ext_authn_duo: Optional[StrictBool] = None

    ext_authn_uid: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    snowflake_lock: Optional[StrictBool] = False

    snowflake_support: Optional[StrictBool] = False

    mins_to_bypass_network_policy: Optional[StrictInt] = None

    password_last_set: Optional[datetime] = None

    custom_landing_page_url: Optional[StrictStr] = None

    custom_landing_page_url_flush_next_ui_load: Optional[StrictBool] = False

    __properties = [
        "name",
        "password",
        "login_name",
        "display_name",
        "first_name",
        "middle_name",
        "last_name",
        "email",
        "must_change_password",
        "disabled",
        "days_to_expiry",
        "mins_to_unlock",
        "default_warehouse",
        "default_namespace",
        "default_role",
        "default_secondary_roles",
        "mins_to_bypass_mfa",
        "rsa_public_key",
        "rsa_public_key_2",
        "comment",
        "type",
        "enable_unredacted_query_syntax_error",
        "network_policy",
        "created_on",
        "last_successful_login",
        "expires_at",
        "locked_until",
        "has_password",
        "has_rsa_public_key",
        "rsa_public_key_fp",
        "rsa_public_key_2_fp",
        "ext_authn_duo",
        "ext_authn_uid",
        "owner",
        "snowflake_lock",
        "snowflake_support",
        "mins_to_bypass_network_policy",
        "password_last_set",
        "custom_landing_page_url",
        "custom_landing_page_url_flush_next_ui_load",
    ]

    @field_validator("default_secondary_roles")
    def default_secondary_roles_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("ALL", "NONE"):
            raise ValueError("must validate the enum values ('ALL','NONE')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> User:
        """Create an instance of User from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "last_successful_login",
                    "expires_at",
                    "locked_until",
                    "has_password",
                    "has_rsa_public_key",
                    "rsa_public_key_fp",
                    "rsa_public_key_2_fp",
                    "ext_authn_duo",
                    "ext_authn_uid",
                    "owner",
                    "snowflake_lock",
                    "snowflake_support",
                    "mins_to_bypass_network_policy",
                    "password_last_set",
                    "custom_landing_page_url",
                    "custom_landing_page_url_flush_next_ui_load",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> User:
        """Create an instance of User from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return User.parse_obj(obj)

        _obj = User.parse_obj(
            {
                "name": obj.get("name"),
                "password": obj.get("password"),
                "login_name": obj.get("login_name"),
                "display_name": obj.get("display_name"),
                "first_name": obj.get("first_name"),
                "middle_name": obj.get("middle_name"),
                "last_name": obj.get("last_name"),
                "email": obj.get("email"),
                "must_change_password": obj.get("must_change_password"),
                "disabled": obj.get("disabled"),
                "days_to_expiry": obj.get("days_to_expiry"),
                "mins_to_unlock": obj.get("mins_to_unlock"),
                "default_warehouse": obj.get("default_warehouse"),
                "default_namespace": obj.get("default_namespace"),
                "default_role": obj.get("default_role"),
                "default_secondary_roles": obj.get("default_secondary_roles")
                if obj.get("default_secondary_roles") is not None
                else "ALL",
                "mins_to_bypass_mfa": obj.get("mins_to_bypass_mfa"),
                "rsa_public_key": obj.get("rsa_public_key"),
                "rsa_public_key_2": obj.get("rsa_public_key_2"),
                "comment": obj.get("comment"),
                "type": obj.get("type"),
                "enable_unredacted_query_syntax_error": obj.get("enable_unredacted_query_syntax_error"),
                "network_policy": obj.get("network_policy"),
                "created_on": obj.get("created_on"),
                "last_successful_login": obj.get("last_successful_login"),
                "expires_at": obj.get("expires_at"),
                "locked_until": obj.get("locked_until"),
                "has_password": obj.get("has_password"),
                "has_rsa_public_key": obj.get("has_rsa_public_key"),
                "rsa_public_key_fp": obj.get("rsa_public_key_fp"),
                "rsa_public_key_2_fp": obj.get("rsa_public_key_2_fp"),
                "ext_authn_duo": obj.get("ext_authn_duo"),
                "ext_authn_uid": obj.get("ext_authn_uid"),
                "owner": obj.get("owner"),
                "snowflake_lock": obj.get("snowflake_lock") if obj.get("snowflake_lock") is not None else False,
                "snowflake_support": obj.get("snowflake_support")
                if obj.get("snowflake_support") is not None
                else False,
                "mins_to_bypass_network_policy": obj.get("mins_to_bypass_network_policy"),
                "password_last_set": obj.get("password_last_set"),
                "custom_landing_page_url": obj.get("custom_landing_page_url"),
                "custom_landing_page_url_flush_next_ui_load": obj.get("custom_landing_page_url_flush_next_ui_load")
                if obj.get("custom_landing_page_url_flush_next_ui_load") is not None
                else False,
            }
        )

        return _obj


class UserModel:
    def __init__(
        self,
        name: str,
        # optional properties
        password: Optional[str] = None,
        login_name: Optional[str] = None,
        display_name: Optional[str] = None,
        first_name: Optional[str] = None,
        middle_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email: Optional[str] = None,
        must_change_password: Optional[bool] = None,
        disabled: Optional[bool] = None,
        days_to_expiry: Optional[int] = None,
        mins_to_unlock: Optional[int] = None,
        default_warehouse: Optional[str] = None,
        default_namespace: Optional[str] = None,
        default_role: Optional[str] = None,
        default_secondary_roles: Optional[str] = "ALL",
        mins_to_bypass_mfa: Optional[int] = None,
        rsa_public_key: Optional[str] = None,
        rsa_public_key_2: Optional[str] = None,
        comment: Optional[str] = None,
        type: Optional[str] = None,
        enable_unredacted_query_syntax_error: Optional[bool] = None,
        network_policy: Optional[str] = None,
        created_on: Optional[datetime] = None,
        last_successful_login: Optional[datetime] = None,
        expires_at: Optional[datetime] = None,
        locked_until: Optional[datetime] = None,
        has_password: Optional[bool] = None,
        has_rsa_public_key: Optional[bool] = None,
        rsa_public_key_fp: Optional[str] = None,
        rsa_public_key_2_fp: Optional[str] = None,
        ext_authn_duo: Optional[bool] = None,
        ext_authn_uid: Optional[str] = None,
        owner: Optional[str] = None,
        snowflake_lock: Optional[bool] = False,
        snowflake_support: Optional[bool] = False,
        mins_to_bypass_network_policy: Optional[int] = None,
        password_last_set: Optional[datetime] = None,
        custom_landing_page_url: Optional[str] = None,
        custom_landing_page_url_flush_next_ui_load: Optional[bool] = False,
    ):
        """A model object representing the User resource.

        Constructs an object of type User with the provided properties.

        Parameters
        __________
        name : str
            User name
        password : str, optional
            Password
        login_name : str, optional
            Login name
        display_name : str, optional
            Display name
        first_name : str, optional
            First name
        middle_name : str, optional
            Middle name
        last_name : str, optional
            Last name
        email : str, optional
            Email address
        must_change_password : bool, optional
            Does this user need to change their password (e.g., after assigning a temp password)
        disabled : bool, optional
            Has this user been disabled from the system
        days_to_expiry : int, optional
            How many days until this user expires
        mins_to_unlock : int, optional
            How many minutes until the account is unlocked after multiple failed logins
        default_warehouse : str, optional
            The default warehouse to use when this user starts a session
        default_namespace : str, optional
            The default namespace to use when this user starts a session
        default_role : str, optional
            The default role to use when this user starts a session
        default_secondary_roles : str,  default 'ALL'
            The default secondary roles of this user to use when starting a session. Only valid set values are ALL or NONE. Default is ALL after 2024-07 BCR.
        mins_to_bypass_mfa : int, optional
            How many minutes until MFA is required again
        rsa_public_key : str, optional
            RSA public key of the user
        rsa_public_key_2 : str, optional
            Second RSA public key of the user
        comment : str, optional
            Comment about the user.
        type : str, optional
            Indicates the type of user (PERSON | SERVICE | LEGACY_SERVICE)
        enable_unredacted_query_syntax_error : bool, optional
            Whether to show unredacted query syntax errors in the query history.
        network_policy : str, optional
            Specifies an existing network policy is active for the user. Otherwise, use account default.
        created_on : datetime, optional

        last_successful_login : datetime, optional

        expires_at : datetime, optional

        locked_until : datetime, optional

        has_password : bool, optional

        has_rsa_public_key : bool, optional

        rsa_public_key_fp : str, optional
            Fingerprint of the user's RSA public key
        rsa_public_key_2_fp : str, optional
            Fingerprint of the user's second RSA public key
        ext_authn_duo : bool, optional

        ext_authn_uid : str, optional

        owner : str, optional

        snowflake_lock : bool,  default False
            Whether the user, account, or organization is locked by Snowflake.
        snowflake_support : bool,  default False
            Whether Snowflake Support is allowed to use the user or account
        mins_to_bypass_network_policy : int, optional
            Temporary bypass network policy on the user for a specified number of minutes
        password_last_set : datetime, optional

        custom_landing_page_url : str, optional

        custom_landing_page_url_flush_next_ui_load : bool,  default False
            Whether or not to flush the custom landing page of the user on next UI load
        """
        self.name = name
        self.password = password
        self.login_name = login_name
        self.display_name = display_name
        self.first_name = first_name
        self.middle_name = middle_name
        self.last_name = last_name
        self.email = email
        self.must_change_password = must_change_password
        self.disabled = disabled
        self.days_to_expiry = days_to_expiry
        self.mins_to_unlock = mins_to_unlock
        self.default_warehouse = default_warehouse
        self.default_namespace = default_namespace
        self.default_role = default_role
        self.default_secondary_roles = default_secondary_roles
        self.mins_to_bypass_mfa = mins_to_bypass_mfa
        self.rsa_public_key = rsa_public_key
        self.rsa_public_key_2 = rsa_public_key_2
        self.comment = comment
        self.type = type
        self.enable_unredacted_query_syntax_error = enable_unredacted_query_syntax_error
        self.network_policy = network_policy
        self.created_on = created_on
        self.last_successful_login = last_successful_login
        self.expires_at = expires_at
        self.locked_until = locked_until
        self.has_password = has_password
        self.has_rsa_public_key = has_rsa_public_key
        self.rsa_public_key_fp = rsa_public_key_fp
        self.rsa_public_key_2_fp = rsa_public_key_2_fp
        self.ext_authn_duo = ext_authn_duo
        self.ext_authn_uid = ext_authn_uid
        self.owner = owner
        self.snowflake_lock = snowflake_lock
        self.snowflake_support = snowflake_support
        self.mins_to_bypass_network_policy = mins_to_bypass_network_policy
        self.password_last_set = password_last_set
        self.custom_landing_page_url = custom_landing_page_url
        self.custom_landing_page_url_flush_next_ui_load = custom_landing_page_url_flush_next_ui_load

    __properties = [
        "name",
        "password",
        "login_name",
        "display_name",
        "first_name",
        "middle_name",
        "last_name",
        "email",
        "must_change_password",
        "disabled",
        "days_to_expiry",
        "mins_to_unlock",
        "default_warehouse",
        "default_namespace",
        "default_role",
        "default_secondary_roles",
        "mins_to_bypass_mfa",
        "rsa_public_key",
        "rsa_public_key_2",
        "comment",
        "type",
        "enable_unredacted_query_syntax_error",
        "network_policy",
        "created_on",
        "last_successful_login",
        "expires_at",
        "locked_until",
        "has_password",
        "has_rsa_public_key",
        "rsa_public_key_fp",
        "rsa_public_key_2_fp",
        "ext_authn_duo",
        "ext_authn_uid",
        "owner",
        "snowflake_lock",
        "snowflake_support",
        "mins_to_bypass_network_policy",
        "password_last_set",
        "custom_landing_page_url",
        "custom_landing_page_url_flush_next_ui_load",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return User(
            name=self.name,
            password=self.password,
            login_name=self.login_name,
            display_name=self.display_name,
            first_name=self.first_name,
            middle_name=self.middle_name,
            last_name=self.last_name,
            email=self.email,
            must_change_password=self.must_change_password,
            disabled=self.disabled,
            days_to_expiry=self.days_to_expiry,
            mins_to_unlock=self.mins_to_unlock,
            default_warehouse=self.default_warehouse,
            default_namespace=self.default_namespace,
            default_role=self.default_role,
            default_secondary_roles=self.default_secondary_roles,
            mins_to_bypass_mfa=self.mins_to_bypass_mfa,
            rsa_public_key=self.rsa_public_key,
            rsa_public_key_2=self.rsa_public_key_2,
            comment=self.comment,
            type=self.type,
            enable_unredacted_query_syntax_error=self.enable_unredacted_query_syntax_error,
            network_policy=self.network_policy,
            created_on=self.created_on,
            last_successful_login=self.last_successful_login,
            expires_at=self.expires_at,
            locked_until=self.locked_until,
            has_password=self.has_password,
            has_rsa_public_key=self.has_rsa_public_key,
            rsa_public_key_fp=self.rsa_public_key_fp,
            rsa_public_key_2_fp=self.rsa_public_key_2_fp,
            ext_authn_duo=self.ext_authn_duo,
            ext_authn_uid=self.ext_authn_uid,
            owner=self.owner,
            snowflake_lock=self.snowflake_lock,
            snowflake_support=self.snowflake_support,
            mins_to_bypass_network_policy=self.mins_to_bypass_network_policy,
            password_last_set=self.password_last_set,
            custom_landing_page_url=self.custom_landing_page_url,
            custom_landing_page_url_flush_next_ui_load=self.custom_landing_page_url_flush_next_ui_load,
        )

    @classmethod
    def _from_model(cls, model) -> UserModel:
        return UserModel(
            name=model.name,
            password=model.password,
            login_name=model.login_name,
            display_name=model.display_name,
            first_name=model.first_name,
            middle_name=model.middle_name,
            last_name=model.last_name,
            email=model.email,
            must_change_password=model.must_change_password,
            disabled=model.disabled,
            days_to_expiry=model.days_to_expiry,
            mins_to_unlock=model.mins_to_unlock,
            default_warehouse=model.default_warehouse,
            default_namespace=model.default_namespace,
            default_role=model.default_role,
            default_secondary_roles=model.default_secondary_roles,
            mins_to_bypass_mfa=model.mins_to_bypass_mfa,
            rsa_public_key=model.rsa_public_key,
            rsa_public_key_2=model.rsa_public_key_2,
            comment=model.comment,
            type=model.type,
            enable_unredacted_query_syntax_error=model.enable_unredacted_query_syntax_error,
            network_policy=model.network_policy,
            created_on=model.created_on,
            last_successful_login=model.last_successful_login,
            expires_at=model.expires_at,
            locked_until=model.locked_until,
            has_password=model.has_password,
            has_rsa_public_key=model.has_rsa_public_key,
            rsa_public_key_fp=model.rsa_public_key_fp,
            rsa_public_key_2_fp=model.rsa_public_key_2_fp,
            ext_authn_duo=model.ext_authn_duo,
            ext_authn_uid=model.ext_authn_uid,
            owner=model.owner,
            snowflake_lock=model.snowflake_lock,
            snowflake_support=model.snowflake_support,
            mins_to_bypass_network_policy=model.mins_to_bypass_network_policy,
            password_last_set=model.password_last_set,
            custom_landing_page_url=model.custom_landing_page_url,
            custom_landing_page_url_flush_next_ui_load=model.custom_landing_page_url_flush_next_ui_load,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a User.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the User object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> UserModel:
        """Create an instance of User from a dict.

        This method constructs a User object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        User
            A User object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(User.from_dict(obj))


User._model_class = UserModel
