"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from typing import TYPE_CHECKING, Any, Iterator, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.user_defined_function._generated.models.user_defined_function import UserDefinedFunction

from .user_defined_function_api import UserDefinedFunctionApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class UserDefinedFunctionCollectionBase(SchemaObjectCollectionParent["UserDefinedFunctionResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = UserDefinedFunctionApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(
        self,
        user_defined_function: UserDefinedFunction,
        mode: Optional[Union[CreateMode, str]] = None,
        copy_grants: Optional[bool] = None,
    ) -> "UserDefinedFunctionResource":  # noqa: F821
        """Create a UDF.

        Parameters
        __________
        user_defined_function: UserDefinedFunction
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        copy_grants: bool
             Parameter to enable copy grants when creating the object.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_user_defined_function(
            self.database.name,
            self.schema.name,
            user_defined_function=user_defined_function,
            create_mode=mode,
            copy_grants=copy_grants,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(user_defined_function), self)
        return self._ref_class(user_defined_function.name, self)

    @api_telemetry
    def create_async(
        self,
        user_defined_function: UserDefinedFunction,
        mode: Optional[Union[CreateMode, str]] = None,
        copy_grants: Optional[bool] = None,
    ) -> PollingOperation["UserDefinedFunctionResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_user_defined_function(
            self.database.name,
            self.schema.name,
            user_defined_function=user_defined_function,
            create_mode=mode,
            copy_grants=copy_grants,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(
                future, lambda _: self._ref_class(get_function_name_with_args(user_defined_function), self)
            )
        return PollingOperation(
            future,
            lambda _: self._ref_class(
                user_defined_function if isinstance(user_defined_function, str) else user_defined_function.name, self
            ),
        )

    @api_telemetry
    def iter(self, *, like: Optional[str] = None) -> Iterator[UserDefinedFunction]:
        """List UDFs.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        """
        resources = self._api.list_user_defined_functions(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(self, *, like: Optional[str] = None) -> PollingOperation[Iterator[UserDefinedFunction]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self._api.list_user_defined_functions(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class UserDefinedFunctionResourceBase(SchemaObjectReferenceMixin["UserDefinedFunctionCollection"]):
    _collection_class: UserDefinedFunctionCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: UserDefinedFunctionCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def fetch(
        self,
    ) -> UserDefinedFunction:
        """Fetch a UDF.

        Parameters
        __________
        """
        return self.collection._api.fetch_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[UserDefinedFunction]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def rename(
        self,
        target_database: str,
        target_schema: str,
        target_name: str,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Rename a UDF.

        Parameters
        __________
        target_database: str
             Database of the target resource. Defaults to the source's database (required)
        target_schema: str
             Schema of the target resource. Defaults to the source's schema (required)
        target_name: str
             Name of the target resource. (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.rename_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_database=target_database,
            target_schema=target_schema,
            target_name=target_name,
            if_exists=if_exists,
            async_req=False,
        )

        self._rename_finalizer(target_name, target_schema, target_database)

    @api_telemetry
    def rename_async(
        self,
        target_database: str,
        target_schema: str,
        target_name: str,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`rename`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.rename_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_database=target_database,
            target_schema=target_schema,
            target_name=target_name,
            if_exists=if_exists,
            async_req=True,
        )

        def finalize(_: Any) -> None:
            self._rename_finalizer(
                target_name=target_name, target_schema=target_schema, target_database=target_database
            )

        return PollingOperation(future, finalize)

    def _rename_finalizer(self, target_name: str, target_schema: str, target_database: str) -> None:
        """Finalizer for rename operation."""
        self._set_new_name(target_name)

        # Schema level resource
        if target_database != self.database.name or target_schema != self.schema.name:
            self.collection = getattr(self.root.databases[target_database].schemas[target_schema], self._plural_name)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a UDF.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
