"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from snowflake.core.user_defined_function._generated.models.function_language import (
    FunctionLanguage,
)


class JavaScriptFunction(FunctionLanguage):
    """A model object representing the JavaScriptFunction resource.

    Constructs an object of type JavaScriptFunction with the provided properties.

    Parameters
    __________

    called_on_null_input : bool, optional
        Decide if the function/procedure can receive null input

    is_volatile : bool, optional
         Specifies the behavior of the UDF when returning results. This Field is deprecated for Procedure.

                    If true, UDF might return different values for different rows, even for the same input.
                    This field is deprecated for Procedure.

                    If false, UDF assumes that the function, when called with the same inputs, will always return the same result.
                    This guarantee is not checked. Specifying IMMUTABLE for a UDF that returns different values for the same input will result in undefined behavior.
    """

    __properties = ["language", "called_on_null_input", "is_volatile"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JavaScriptFunction:
        """Create an instance of JavaScriptFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["language"] = FunctionLanguage.get_child_model_discriminator_value("JavaScriptFunction")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> JavaScriptFunction:
        """Create an instance of JavaScriptFunction from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JavaScriptFunction.parse_obj(obj)

        _obj = JavaScriptFunction.parse_obj(
            {
                "called_on_null_input": obj.get("called_on_null_input"),
                "is_volatile": obj.get("is_volatile"),
            }
        )

        return _obj


class JavaScriptFunctionModel(FunctionLanguage):
    def __init__(
        self,  # optional properties
        called_on_null_input: Optional[bool] = None,
        is_volatile: Optional[bool] = None,
    ):
        """A model object representing the JavaScriptFunction resource.

        Constructs an object of type JavaScriptFunction with the provided properties.

        Parameters
        __________

        called_on_null_input : bool, optional
            Decide if the function/procedure can receive null input

        is_volatile : bool, optional
             Specifies the behavior of the UDF when returning results. This Field is deprecated for Procedure.

            If true, UDF might return different values for different rows, even for the same input.
            This field is deprecated for Procedure.

            If false, UDF assumes that the function, when called with the same inputs, will always return the same result.
            This guarantee is not checked. Specifying IMMUTABLE for a UDF that returns different values for the same input will result in undefined behavior.
        """
        super().__init__(
            called_on_null_input=called_on_null_input,
            is_volatile=is_volatile,
        )

    __properties = ["language", "called_on_null_input", "is_volatile"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return JavaScriptFunction(
            called_on_null_input=self.called_on_null_input,
            is_volatile=self.is_volatile,
        )

    @classmethod
    def _from_model(cls, model) -> JavaScriptFunctionModel:
        return JavaScriptFunctionModel(
            called_on_null_input=model.called_on_null_input,
            is_volatile=model.is_volatile,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a JavaScriptFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the JavaScriptFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> JavaScriptFunctionModel:
        """Create an instance of JavaScriptFunction from a dict.

        This method constructs a JavaScriptFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        JavaScriptFunction
            A JavaScriptFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(JavaScriptFunction.from_dict(obj))


JavaScriptFunction._model_class = JavaScriptFunctionModel
