"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import StrictStr

from snowflake.core.user_defined_function._generated.models.base_language import BaseLanguage


class ScalaFunction(BaseLanguage):
    """A model object representing the ScalaFunction resource.

    Constructs an object of type ScalaFunction with the provided properties.

    Parameters
    __________

    packages : list[str]
        Packages to include with the function/procedure

    handler : str
        Fully qualified method name including the package and the class
    runtime_version : str
        Specifies the Scala runtime version to use. The supported versions of Scala are: 2.12

    imports : list[str], optional
        List of imports

    target_path : str, optional
        Specifies where Snowflake should write the compiled code for inline function/procedures
    """

    target_path: Optional[StrictStr] = None

    runtime_version: StrictStr

    __properties = ["packages", "imports", "handler", "language", "called_on_null_input", "is_volatile"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScalaFunction:
        """Create an instance of ScalaFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        _dict["language"] = BaseLanguage.get_child_model_discriminator_value("ScalaFunction")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ScalaFunction:
        """Create an instance of ScalaFunction from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ScalaFunction.parse_obj(obj)

        _obj = ScalaFunction.parse_obj(
            {
                "packages": obj.get("packages"),
                "imports": obj.get("imports"),
                "handler": obj.get("handler"),
                "target_path": obj.get("target_path"),
                "runtime_version": obj.get("runtime_version"),
            }
        )

        return _obj


class ScalaFunctionModel(BaseLanguage):
    def __init__(
        self,
        packages: list[str],
        handler: str,
        runtime_version: str,
        # optional properties
        called_on_null_input: Optional[bool] = None,
        is_volatile: Optional[bool] = None,
        target_path: Optional[str] = None,
    ):
        """A model object representing the ScalaFunction resource.

        Constructs an object of type ScalaFunction with the provided properties.

        Parameters
        __________

        packages : list[str]
            Packages to include with the function/procedure

        handler : str
            Fully qualified method name including the package and the class
        runtime_version : str
            Specifies the Scala runtime version to use. The supported versions of Scala are: 2.12

        imports : list[str], optional
            List of imports

        target_path : str, optional
            Specifies where Snowflake should write the compiled code for inline function/procedures
        """
        super().__init__(
            called_on_null_input=called_on_null_input,
            is_volatile=is_volatile,
        )
        self.target_path = target_path
        self.runtime_version = runtime_version

    __properties = ["packages", "imports", "handler", "language", "called_on_null_input", "is_volatile"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ScalaFunction(
            packages=self.packages,
            imports=self.imports,
            handler=self.handler,
            target_path=self.target_path,
            runtime_version=self.runtime_version,
        )

    @classmethod
    def _from_model(cls, model) -> ScalaFunctionModel:
        return ScalaFunctionModel(
            packages=model.packages,
            imports=model.imports,
            handler=model.handler,
            target_path=model.target_path,
            runtime_version=model.runtime_version,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ScalaFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ScalaFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ScalaFunctionModel:
        """Create an instance of ScalaFunction from a dict.

        This method constructs a ScalaFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ScalaFunction
            A ScalaFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ScalaFunction.from_dict(obj))


ScalaFunction._model_class = ScalaFunctionModel
