"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.user_defined_function._generated.models.argument import Argument, ArgumentModel
from snowflake.core.user_defined_function._generated.models.function_language import (
    FunctionLanguage,
    FunctionLanguageModel,
)
from snowflake.core.user_defined_function._generated.models.return_type import ReturnType, ReturnTypeModel


class UserDefinedFunction(BaseModel):
    """A model object representing the UserDefinedFunction resource.

    Constructs an object of type UserDefinedFunction with the provided properties.

    Parameters
    __________
    name : str
        The name of the UDF
    arguments : list[Argument]
        List of arguments for the function/procedure
    return_type : ReturnType

    language_config : FunctionLanguage

    is_temporary : bool, optional
        Specifies whether the UDF is temporary or not
    is_aggregate : bool, optional
        Specifies whether the UDF is an aggregate function. Applicable only for Python language type
    is_memoizable : bool, optional
        Indicates whether the function is memoizable. Applicable only for Python language type.
    is_table_function : bool, optional
        True if the UDF is a table function; false otherwise.
    valid_for_clustering : bool, optional
        True if the UDF is valid for clustering; false otherwise.
    is_secure : bool, optional
        Specifies whether the function/procedure is secure or not
    comment : str, optional
        Specifies a comment for the function/procedure
    body : str, optional
        Function/procedure definition
    created_on : datetime, optional
        The date and time when the function/procedure was created
    schema_name : str, optional
        The name of the schema in which the function/procedure exists.
    database_name : str, optional
        The name of the database in which the function/procedure exists.
    min_num_arguments : int, optional
        The minimum number of arguments
    max_num_arguments : int, optional
        The maximum number of arguments
    owner : str, optional
        Role that owns the function/procedure
    owner_role_type : str, optional
        The type of role that owns the function/procedure
    is_builtin : bool, optional
        If the function/procedure is built-in or not (user-defined)
    """

    name: Annotated[str, Field(strict=True)]

    is_temporary: Optional[StrictBool] = None

    is_aggregate: Optional[StrictBool] = None

    is_memoizable: Optional[StrictBool] = None

    is_table_function: Optional[StrictBool] = None

    valid_for_clustering: Optional[StrictBool] = None

    is_secure: Optional[StrictBool] = None

    arguments: List[Argument]

    return_type: ReturnType

    language_config: FunctionLanguage

    comment: Optional[StrictStr] = None

    body: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    min_num_arguments: Optional[StrictInt] = None

    max_num_arguments: Optional[StrictInt] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    is_builtin: Optional[StrictBool] = None

    __properties = [
        "name",
        "is_temporary",
        "is_aggregate",
        "is_memoizable",
        "is_table_function",
        "valid_for_clustering",
        "is_secure",
        "arguments",
        "return_type",
        "language_config",
        "comment",
        "body",
        "created_on",
        "schema_name",
        "database_name",
        "min_num_arguments",
        "max_num_arguments",
        "owner",
        "owner_role_type",
        "is_builtin",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner_role_type")
    def owner_role_type_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserDefinedFunction:
        """Create an instance of UserDefinedFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "is_table_function",
                    "valid_for_clustering",
                    "created_on",
                    "schema_name",
                    "database_name",
                    "min_num_arguments",
                    "max_num_arguments",
                    "owner",
                    "owner_role_type",
                    "is_builtin",
                }
            )

        _dict = dict(self._iter(to_dict=True, by_alias=True, exclude=exclude_properties, exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in arguments (list)
        _items = []
        if self.arguments:
            for _item in self.arguments:
                if _item:
                    _items.append(_item.to_dict())
            _dict["arguments"] = _items

        # override the default output from pydantic by calling `to_dict()` of return_type
        if self.return_type:
            _dict["return_type"] = self.return_type.to_dict()

        # override the default output from pydantic by calling `to_dict()` of language_config
        if self.language_config:
            _dict["language_config"] = self.language_config.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> UserDefinedFunction:
        """Create an instance of UserDefinedFunction from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UserDefinedFunction.parse_obj(obj)

        _obj = UserDefinedFunction.parse_obj(
            {
                "name": obj.get("name"),
                "is_temporary": obj.get("is_temporary"),
                "is_aggregate": obj.get("is_aggregate"),
                "is_memoizable": obj.get("is_memoizable"),
                "is_table_function": obj.get("is_table_function"),
                "valid_for_clustering": obj.get("valid_for_clustering"),
                "is_secure": obj.get("is_secure"),
                "arguments": [Argument.from_dict(_item) for _item in obj.get("arguments")]
                if obj.get("arguments") is not None
                else None,
                "return_type": ReturnType.from_dict(obj.get("return_type"))
                if obj.get("return_type") is not None
                else None,
                "language_config": FunctionLanguage.from_dict(obj.get("language_config"))
                if obj.get("language_config") is not None
                else None,
                "comment": obj.get("comment"),
                "body": obj.get("body"),
                "created_on": obj.get("created_on"),
                "schema_name": obj.get("schema_name"),
                "database_name": obj.get("database_name"),
                "min_num_arguments": obj.get("min_num_arguments"),
                "max_num_arguments": obj.get("max_num_arguments"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
                "is_builtin": obj.get("is_builtin"),
            }
        )

        return _obj


class UserDefinedFunctionModel:
    def __init__(
        self,
        name: str,
        arguments: list[Argument],
        return_type: ReturnType,
        language_config: FunctionLanguage,
        # optional properties
        is_temporary: Optional[bool] = None,
        is_aggregate: Optional[bool] = None,
        is_memoizable: Optional[bool] = None,
        is_table_function: Optional[bool] = None,
        valid_for_clustering: Optional[bool] = None,
        is_secure: Optional[bool] = None,
        comment: Optional[str] = None,
        body: Optional[str] = None,
        created_on: Optional[datetime] = None,
        schema_name: Optional[str] = None,
        database_name: Optional[str] = None,
        min_num_arguments: Optional[int] = None,
        max_num_arguments: Optional[int] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        is_builtin: Optional[bool] = None,
    ):
        """A model object representing the UserDefinedFunction resource.

        Constructs an object of type UserDefinedFunction with the provided properties.

        Parameters
        __________
        name : str
            The name of the UDF
        arguments : list[Argument]
            List of arguments for the function/procedure
        return_type : ReturnType

        language_config : FunctionLanguage

        is_temporary : bool, optional
            Specifies whether the UDF is temporary or not
        is_aggregate : bool, optional
            Specifies whether the UDF is an aggregate function. Applicable only for Python language type
        is_memoizable : bool, optional
            Indicates whether the function is memoizable. Applicable only for Python language type.
        is_table_function : bool, optional
            True if the UDF is a table function; false otherwise.
        valid_for_clustering : bool, optional
            True if the UDF is valid for clustering; false otherwise.
        is_secure : bool, optional
            Specifies whether the function/procedure is secure or not
        comment : str, optional
            Specifies a comment for the function/procedure
        body : str, optional
            Function/procedure definition
        created_on : datetime, optional
            The date and time when the function/procedure was created
        schema_name : str, optional
            The name of the schema in which the function/procedure exists.
        database_name : str, optional
            The name of the database in which the function/procedure exists.
        min_num_arguments : int, optional
            The minimum number of arguments
        max_num_arguments : int, optional
            The maximum number of arguments
        owner : str, optional
            Role that owns the function/procedure
        owner_role_type : str, optional
            The type of role that owns the function/procedure
        is_builtin : bool, optional
            If the function/procedure is built-in or not (user-defined)
        """
        self.name = name
        self.is_temporary = is_temporary
        self.is_aggregate = is_aggregate
        self.is_memoizable = is_memoizable
        self.is_table_function = is_table_function
        self.valid_for_clustering = valid_for_clustering
        self.is_secure = is_secure
        self.arguments = arguments
        self.return_type = return_type
        self.language_config = language_config
        self.comment = comment
        self.body = body
        self.created_on = created_on
        self.schema_name = schema_name
        self.database_name = database_name
        self.min_num_arguments = min_num_arguments
        self.max_num_arguments = max_num_arguments
        self.owner = owner
        self.owner_role_type = owner_role_type
        self.is_builtin = is_builtin

    __properties = [
        "name",
        "is_temporary",
        "is_aggregate",
        "is_memoizable",
        "is_table_function",
        "valid_for_clustering",
        "is_secure",
        "arguments",
        "return_type",
        "language_config",
        "comment",
        "body",
        "created_on",
        "schema_name",
        "database_name",
        "min_num_arguments",
        "max_num_arguments",
        "owner",
        "owner_role_type",
        "is_builtin",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return UserDefinedFunction(
            name=self.name,
            is_temporary=self.is_temporary,
            is_aggregate=self.is_aggregate,
            is_memoizable=self.is_memoizable,
            is_table_function=self.is_table_function,
            valid_for_clustering=self.valid_for_clustering,
            is_secure=self.is_secure,
            arguments=[x._to_model() for x in self.arguments] if self.arguments is not None else None,
            return_type=self.return_type._to_model() if self.return_type is not None else None,
            language_config=self.language_config._to_model() if self.language_config is not None else None,
            comment=self.comment,
            body=self.body,
            created_on=self.created_on,
            schema_name=self.schema_name,
            database_name=self.database_name,
            min_num_arguments=self.min_num_arguments,
            max_num_arguments=self.max_num_arguments,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            is_builtin=self.is_builtin,
        )

    @classmethod
    def _from_model(cls, model) -> UserDefinedFunctionModel:
        return UserDefinedFunctionModel(
            name=model.name,
            is_temporary=model.is_temporary,
            is_aggregate=model.is_aggregate,
            is_memoizable=model.is_memoizable,
            is_table_function=model.is_table_function,
            valid_for_clustering=model.valid_for_clustering,
            is_secure=model.is_secure,
            arguments=[ArgumentModel._from_model(x) for x in model.arguments] if model.arguments else None,
            return_type=ReturnTypeModel._from_model(model.return_type) if model.return_type else None,
            language_config=FunctionLanguageModel._from_model(model.language_config) if model.language_config else None,
            comment=model.comment,
            body=model.body,
            created_on=model.created_on,
            schema_name=model.schema_name,
            database_name=model.database_name,
            min_num_arguments=model.min_num_arguments,
            max_num_arguments=model.max_num_arguments,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            is_builtin=model.is_builtin,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a UserDefinedFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the UserDefinedFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> UserDefinedFunctionModel:
        """Create an instance of UserDefinedFunction from a dict.

        This method constructs a UserDefinedFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        UserDefinedFunction
            A UserDefinedFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(UserDefinedFunction.from_dict(obj))


UserDefinedFunction._model_class = UserDefinedFunctionModel
