"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DataframeType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataframeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataframeType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNDEFINED: _DataframeType.ValueType  # 0
    """The type is undefined"""
    SNOWPARK_API: _DataframeType.ValueType  # 1
    """Snowpark API"""
    SPARK_CONNECT: _DataframeType.ValueType  # 2
    """Spark connect API"""

class DataframeType(_DataframeType, metaclass=_DataframeTypeEnumTypeWrapper):
    """The type of the dataframe"""

UNDEFINED: DataframeType.ValueType  # 0
"""The type is undefined"""
SNOWPARK_API: DataframeType.ValueType  # 1
"""Snowpark API"""
SPARK_CONNECT: DataframeType.ValueType  # 2
"""Spark connect API"""
global___DataframeType = DataframeType

@typing.final
class Request(google.protobuf.message.Message):
    """The dataframe processor request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    DATAFRAME_TYPE_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    dataframe_type: global___DataframeType.ValueType
    @property
    def payload(self) -> google.protobuf.any_pb2.Any:
        """Type-specific payload.
        SNOWPARK_API requests use the protobuf generated from //Snowpark/ast: ast.ir => `entity Request`.
        SPARK_CONNECT requests use the public Spark Connect protocol.
        ... future extensions, e.g., telemetry, metrics config.
        """

    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        dataframe_type: global___DataframeType.ValueType = ...,
        payload: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dataframe_type", b"dataframe_type", "payload", b"payload", "request_id", b"request_id"]) -> None: ...

global___Request = Request

@typing.final
class Response(google.protobuf.message.Message):
    """Response of the dataframe processor request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _StatusCode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Response._StatusCode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OK: Response._StatusCode.ValueType  # 0
        INIT_ERROR: Response._StatusCode.ValueType  # 1
        """Failed to initialize"""
        EXECUTION_ERROR: Response._StatusCode.ValueType  # 2
        """Failed to execute the request"""
        SESSION_RESET_REQUIRED_ERROR: Response._StatusCode.ValueType  # 3
        """Session requires to retransmit the dependencies
        ... other status codes
        """

    class StatusCode(_StatusCode, metaclass=_StatusCodeEnumTypeWrapper):
        """The types of errors"""

    OK: Response.StatusCode.ValueType  # 0
    INIT_ERROR: Response.StatusCode.ValueType  # 1
    """Failed to initialize"""
    EXECUTION_ERROR: Response.StatusCode.ValueType  # 2
    """Failed to execute the request"""
    SESSION_RESET_REQUIRED_ERROR: Response.StatusCode.ValueType  # 3
    """Session requires to retransmit the dependencies
    ... other status codes
    """

    REQUEST_ID_FIELD_NUMBER: builtins.int
    DATAFRAME_TYPE_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    RESULT_JOB_UUID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """ID of the request with which this response is associated."""
    dataframe_type: global___DataframeType.ValueType
    """The type of the dataframe"""
    code: global___Response.StatusCode.ValueType
    result_job_uuid: builtins.str
    """The UUID of the job containing the result of the request."""
    error_message: builtins.str
    """Dataframe processor internal use only. The external protocol status is in the payload."""
    @property
    def payload(self) -> google.protobuf.any_pb2.Any:
        """The payload of the response for other types of responses."""

    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        dataframe_type: global___DataframeType.ValueType = ...,
        code: global___Response.StatusCode.ValueType = ...,
        result_job_uuid: builtins.str = ...,
        payload: google.protobuf.any_pb2.Any | None = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payload", b"payload", "result", b"result", "result_job_uuid", b"result_job_uuid"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["code", b"code", "dataframe_type", b"dataframe_type", "error_message", b"error_message", "payload", b"payload", "request_id", b"request_id", "result", b"result", "result_job_uuid", b"result_job_uuid"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["result", b"result"]) -> typing.Literal["result_job_uuid", "payload"] | None: ...

global___Response = Response

@typing.final
class TruncatedSparkRelation(google.protobuf.message.Message):
    """* Empty relation indicating that the real spark relation has been truncated *"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___TruncatedSparkRelation = TruncatedSparkRelation
