from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

VTK_ATTRIBUTE_MODE_DEFAULT:int
VTK_ATTRIBUTE_MODE_USE_CELL_DATA:int
VTK_ATTRIBUTE_MODE_USE_POINT_DATA:int
VTK_BEST_FITTING_PLANE:int
VTK_CELL_DATA:int
VTK_CELL_DATA_FIELD:int
VTK_COLOR_BY_SCALAR:int
VTK_COLOR_BY_SCALE:int
VTK_COLOR_BY_VECTOR:int
VTK_COMPONENT_MODE_USE_ALL:int
VTK_COMPONENT_MODE_USE_ANY:int
VTK_COMPONENT_MODE_USE_SELECTED:int
VTK_DATA_OBJECT_FIELD:int
VTK_DATA_SCALING_OFF:int
VTK_DELAUNAY_XY_PLANE:int
VTK_EXTRACT_ALL_REGIONS:int
VTK_EXTRACT_CELL_SEEDED_REGIONS:int
VTK_EXTRACT_CLOSEST_POINT_REGION:int
VTK_EXTRACT_LARGEST_REGION:int
VTK_EXTRACT_LARGE_REGIONS:int
VTK_EXTRACT_POINT_SEEDED_REGIONS:int
VTK_EXTRACT_SPECIFIED_REGIONS:int
VTK_FOLLOW_CAMERA_DIRECTION:int
VTK_INDEXING_BY_SCALAR:int
VTK_INDEXING_BY_VECTOR:int
VTK_INDEXING_OFF:int
VTK_POINT_DATA:int
VTK_POINT_DATA_FIELD:int
VTK_SCALE_BY_SCALAR:int
VTK_SCALE_BY_VECTOR:int
VTK_SCALE_BY_VECTORCOMPONENTS:int
VTK_SET_TRANSFORM_PLANE:int
VTK_SORT_BY_CELL:int
VTK_SORT_BY_VALUE:int
VTK_SPHERE_TREE_LEVELS:int
VTK_SPHERE_TREE_LINE:int
VTK_SPHERE_TREE_PLANE:int
VTK_SPHERE_TREE_POINT:int
VTK_TCOORDS_FROM_LENGTH:int
VTK_TCOORDS_FROM_NORMALIZED_LENGTH:int
VTK_TCOORDS_FROM_SCALARS:int
VTK_TCOORDS_OFF:int
VTK_USE_NORMAL:int
VTK_USE_VECTOR:int
VTK_VARY_RADIUS_BY_ABSOLUTE_SCALAR:int
VTK_VARY_RADIUS_BY_SCALAR:int
VTK_VARY_RADIUS_BY_VECTOR:int
VTK_VARY_RADIUS_BY_VECTOR_NORM:int
VTK_VARY_RADIUS_OFF:int
VTK_VECTOR_ROTATION_OFF:int

class vtk3DLinearGridCrinkleExtractor(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    copy_cell_data:'getset_descriptor'
    copy_point_data:'getset_descriptor'
    implicit_function:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_threads_used:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    remove_unused_points:'getset_descriptor'
    sequential_processing:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def CopyCellDataOff(self) -> None: ...
    def CopyCellDataOn(self) -> None: ...
    def CopyPointDataOff(self) -> None: ...
    def CopyPointDataOn(self) -> None: ...
    def GetCopyCellData(self) -> bool: ...
    def GetCopyPointData(self) -> bool: ...
    def GetImplicitFunction(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRemoveUnusedPoints(self) -> bool: ...
    def GetSequentialProcessing(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtk3DLinearGridCrinkleExtractor': ...
    def RemoveUnusedPointsOff(self) -> None: ...
    def RemoveUnusedPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DLinearGridCrinkleExtractor': ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetCopyCellData(self, _arg:bool) -> None: ...
    def SetCopyPointData(self, _arg:bool) -> None: ...
    def SetImplicitFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetRemoveUnusedPoints(self, _arg:bool) -> None: ...
    def SetSequentialProcessing(self, _arg:bool) -> None: ...

class vtk3DLinearGridPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    compute_normals:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    large_ids:'getset_descriptor'
    m_time:'getset_descriptor'
    merge_points:'getset_descriptor'
    number_of_threads_used:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    plane:'getset_descriptor'
    sequential_processing:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetComputeNormals(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetLargeIds(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def GetSequentialProcessing(self) -> bool: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtk3DLinearGridPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DLinearGridPlaneCutter': ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...
    def SetSequentialProcessing(self, _arg:bool) -> None: ...

class vtkAppendArcLength(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendArcLength': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendArcLength': ...

class vtkAppendCompositeDataLeaves(vtkmodules.vtkCommonExecutionModel.vtkCompositeDataSetAlgorithm):
    append_field_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AppendFieldDataOff(self) -> None: ...
    def AppendFieldDataOn(self) -> None: ...
    def GetAppendFieldData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendCompositeDataLeaves': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendCompositeDataLeaves': ...
    def SetAppendFieldData(self, _arg:int) -> None: ...

class vtkAppendDataSets(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    merge_points:'getset_descriptor'
    output_data_set_type:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDataSetType(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAppendDataSets': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendDataSets': ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetOutputDataSetType(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkAppendFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    input:'getset_descriptor'
    input_list:'getset_descriptor'
    merge_points:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkDataSet': ...
    @overload
    def GetInput(self) -> 'vtkDataSet': ...
    def GetInputList(self) -> 'vtkDataSetCollection': ...
    def GetMergePoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAppendFilter': ...
    def RemoveInputData(self, in_:'vtkDataSet') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendFilter': ...
    def SetMergePoints(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkAppendPartitionedDataSetCollection(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    class AppendModes(int): ...
    APPEND_PARTITIONS:'AppendModes'
    MERGE_PARTITIONS:'AppendModes'
    append_field_data:'getset_descriptor'
    append_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AppendFieldDataOff(self) -> None: ...
    def AppendFieldDataOn(self) -> None: ...
    def GetAppendFieldData(self) -> bool: ...
    def GetAppendMode(self) -> int: ...
    def GetAppendModeMaxValue(self) -> int: ...
    def GetAppendModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendPartitionedDataSetCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendPartitionedDataSetCollection': ...
    def SetAppendFieldData(self, _arg:bool) -> None: ...
    def SetAppendMode(self, _arg:int) -> None: ...
    def SetAppendModeToAppendPartitions(self) -> None: ...
    def SetAppendModeToMergePartitions(self) -> None: ...

class vtkAppendPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    input:'getset_descriptor'
    number_of_inputs:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    parallel_streaming:'getset_descriptor'
    user_managed_inputs:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddInputData(self, __a:'vtkPolyData') -> None: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkPolyData': ...
    @overload
    def GetInput(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetParallelStreaming(self) -> int: ...
    def GetUserManagedInputs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendPolyData': ...
    def ParallelStreamingOff(self) -> None: ...
    def ParallelStreamingOn(self) -> None: ...
    def RemoveInputData(self, __a:'vtkPolyData') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendPolyData': ...
    def SetInputConnectionByNumber(self, num:int, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputDataByNumber(self, num:int, ds:'vtkPolyData') -> None: ...
    def SetNumberOfInputs(self, num:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetParallelStreaming(self, _arg:int) -> None: ...
    def SetUserManagedInputs(self, _arg:int) -> None: ...
    def UserManagedInputsOff(self) -> None: ...
    def UserManagedInputsOn(self) -> None: ...

class vtkAppendSelection(vtkmodules.vtkCommonExecutionModel.vtkSelectionAlgorithm):
    append_by_union:'getset_descriptor'
    color_array_name:'getset_descriptor'
    expression:'getset_descriptor'
    input:'getset_descriptor'
    inverse:'getset_descriptor'
    number_of_inputs:'getset_descriptor'
    user_managed_inputs:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddInputData(self, __a:'vtkSelection') -> None: ...
    def AppendByUnionOff(self) -> None: ...
    def AppendByUnionOn(self) -> None: ...
    def GetAppendByUnion(self) -> int: ...
    @staticmethod
    def GetColorArrayName() -> str: ...
    def GetExpression(self) -> str: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkSelection': ...
    @overload
    def GetInput(self) -> 'vtkSelection': ...
    def GetInputColor(self, index:int) -> Pointer: ...
    def GetInputName(self, index:int) -> str: ...
    def GetInverse(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUserManagedInputs(self) -> int: ...
    def InverseOff(self) -> None: ...
    def InverseOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendSelection': ...
    def RemoveAllInputColors(self) -> None: ...
    def RemoveAllInputNames(self) -> None: ...
    def RemoveInputData(self, __a:'vtkSelection') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendSelection': ...
    def SetAppendByUnion(self, _arg:int) -> None: ...
    def SetExpression(self, arg:str) -> None: ...
    def SetInputColor(self, index:int, r:float, g:float, b:float) -> None: ...
    def SetInputConnectionByNumber(self, num:int, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputName(self, index:int, name:str) -> None: ...
    def SetInverse(self, _arg:bool) -> None: ...
    def SetNumberOfInputs(self, num:int) -> None: ...
    def SetUserManagedInputs(self, _arg:int) -> None: ...
    def UserManagedInputsOff(self) -> None: ...
    def UserManagedInputsOn(self) -> None: ...

class vtkArrayCalculator(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class FunctionParserTypes(int): ...
    DEFAULT_ATTRIBUTE_TYPE:int
    ExprTkFunctionParser:'FunctionParserTypes'
    FunctionParser:'FunctionParserTypes'
    NumberOfFunctionParserTypes:'FunctionParserTypes'
    attribute_type:'getset_descriptor'
    coordinate_results:'getset_descriptor'
    data_set_output:'getset_descriptor'
    function:'getset_descriptor'
    function_parser_type:'getset_descriptor'
    ignore_missing_arrays:'getset_descriptor'
    number_of_scalar_arrays:'getset_descriptor'
    number_of_vector_arrays:'getset_descriptor'
    replace_invalid_values:'getset_descriptor'
    replacement_value:'getset_descriptor'
    result_array_name:'getset_descriptor'
    result_array_type:'getset_descriptor'
    result_normals:'getset_descriptor'
    result_t_coords:'getset_descriptor'
    scalar_array_names:'getset_descriptor'
    scalar_variable_names:'getset_descriptor'
    selected_scalar_components:'getset_descriptor'
    vector_array_names:'getset_descriptor'
    vector_variable_names:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCoordinateScalarVariable(self, variableName:str, component:int=0) -> None: ...
    def AddCoordinateVectorVariable(self, variableName:str, component0:int=0, component1:int=1, component2:int=2) -> None: ...
    def AddScalarArrayName(self, arrayName:str, component:int=0) -> None: ...
    def AddScalarVariable(self, variableName:str, arrayName:str, component:int=0) -> None: ...
    def AddVectorArrayName(self, arrayName:str, component0:int=0, component1:int=1, component2:int=2) -> None: ...
    def AddVectorVariable(self, variableName:str, arrayName:str, component0:int=0, component1:int=1, component2:int=2) -> None: ...
    def CoordinateResultsOff(self) -> None: ...
    def CoordinateResultsOn(self) -> None: ...
    def GetAttributeType(self) -> int: ...
    def GetAttributeTypeAsString(self) -> str: ...
    def GetCoordinateResults(self) -> int: ...
    def GetDataSetOutput(self) -> 'vtkDataSet': ...
    def GetFunction(self) -> str: ...
    def GetFunctionParserType(self) -> 'FunctionParserTypes': ...
    def GetIgnoreMissingArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfScalarArrays(self) -> int: ...
    def GetNumberOfVectorArrays(self) -> int: ...
    def GetReplaceInvalidValues(self) -> int: ...
    def GetReplacementValue(self) -> float: ...
    def GetResultArrayName(self) -> str: ...
    def GetResultArrayType(self) -> int: ...
    def GetResultNormals(self) -> bool: ...
    def GetResultTCoords(self) -> bool: ...
    def GetScalarArrayName(self, i:int) -> str: ...
    def GetScalarArrayNames(self) -> Tuple[str, str]: ...
    def GetScalarVariableName(self, i:int) -> str: ...
    def GetScalarVariableNames(self) -> Tuple[str, str]: ...
    def GetSelectedScalarComponent(self, i:int) -> int: ...
    def GetSelectedScalarComponents(self) -> Tuple[int, int]: ...
    def GetSelectedVectorComponents(self, i:int) -> 'vtkTuple_IiLi3EE': ...
    def GetVectorArrayName(self, i:int) -> str: ...
    def GetVectorArrayNames(self) -> Tuple[str, str]: ...
    def GetVectorVariableName(self, i:int) -> str: ...
    def GetVectorVariableNames(self) -> Tuple[str, str]: ...
    def IgnoreMissingArraysOff(self) -> None: ...
    def IgnoreMissingArraysOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayCalculator': ...
    def RemoveAllVariables(self) -> None: ...
    def RemoveCoordinateScalarVariables(self) -> None: ...
    def RemoveCoordinateVectorVariables(self) -> None: ...
    def RemoveScalarVariables(self) -> None: ...
    def RemoveVectorVariables(self) -> None: ...
    def ReplaceInvalidValuesOff(self) -> None: ...
    def ReplaceInvalidValuesOn(self) -> None: ...
    def ResultNormalsOff(self) -> None: ...
    def ResultNormalsOn(self) -> None: ...
    def ResultTCoordsOff(self) -> None: ...
    def ResultTCoordsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayCalculator': ...
    def SetAttributeType(self, _arg:int) -> None: ...
    def SetAttributeTypeToCellData(self) -> None: ...
    def SetAttributeTypeToDefault(self) -> None: ...
    def SetAttributeTypeToEdgeData(self) -> None: ...
    def SetAttributeTypeToPointData(self) -> None: ...
    def SetAttributeTypeToRowData(self) -> None: ...
    def SetAttributeTypeToVertexData(self) -> None: ...
    def SetCoordinateResults(self, _arg:int) -> None: ...
    def SetFunction(self, _arg:str) -> None: ...
    def SetFunctionParserType(self, _arg:'FunctionParserTypes') -> None: ...
    def SetFunctionParserTypeToExprTkFunctionParser(self) -> None: ...
    def SetFunctionParserTypeToFunctionParser(self) -> None: ...
    def SetIgnoreMissingArrays(self, _arg:bool) -> None: ...
    def SetReplaceInvalidValues(self, _arg:int) -> None: ...
    def SetReplacementValue(self, _arg:float) -> None: ...
    def SetResultArrayName(self, _arg:str) -> None: ...
    def SetResultArrayType(self, _arg:int) -> None: ...
    def SetResultNormals(self, _arg:bool) -> None: ...
    def SetResultTCoords(self, _arg:bool) -> None: ...

class vtkArrayRename(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    number_of_cell_arrays:'getset_descriptor'
    number_of_edge_arrays:'getset_descriptor'
    number_of_field_arrays:'getset_descriptor'
    number_of_point_arrays:'getset_descriptor'
    number_of_row_arrays:'getset_descriptor'
    number_of_vertex_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearAll(self) -> None: ...
    def ClearCellMapping(self) -> None: ...
    def ClearEdgeMapping(self) -> None: ...
    def ClearFieldMapping(self) -> None: ...
    def ClearMapping(self, attributeType:int) -> None: ...
    def ClearPointMapping(self) -> None: ...
    def ClearRowMapping(self) -> None: ...
    def ClearVertexMapping(self) -> None: ...
    def GetArrayNewName(self, attributeType:int, idx:int) -> str: ...
    def GetArrayOriginalName(self, attributeType:int, idx:int) -> str: ...
    def GetCellArrayNewName(self, idx:int) -> str: ...
    def GetCellArrayOriginalName(self, idx:int) -> str: ...
    def GetEdgeArrayNewName(self, idx:int) -> str: ...
    def GetEdgeArrayOriginalName(self, idx:int) -> str: ...
    def GetFieldArrayNewName(self, idx:int) -> str: ...
    def GetFieldArrayOriginalName(self, idx:int) -> str: ...
    def GetNumberOfArrays(self, attributeType:int) -> int: ...
    def GetNumberOfCellArrays(self) -> int: ...
    def GetNumberOfEdgeArrays(self) -> int: ...
    def GetNumberOfFieldArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetNumberOfRowArrays(self) -> int: ...
    def GetNumberOfVertexArrays(self) -> int: ...
    def GetPointArrayNewName(self, idx:int) -> str: ...
    def GetPointArrayOriginalName(self, idx:int) -> str: ...
    def GetRowArrayNewName(self, idx:int) -> str: ...
    def GetRowArrayOriginalName(self, idx:int) -> str: ...
    def GetVertexArrayNewName(self, idx:int) -> str: ...
    def GetVertexArrayOriginalName(self, idx:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayRename': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayRename': ...
    @overload
    def SetArrayName(self, attributeType:int, idx:int, newName:str) -> None: ...
    @overload
    def SetArrayName(self, attributeType:int, inputName:str, newName:str) -> None: ...
    @overload
    def SetCellArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetCellArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetEdgeArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetEdgeArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetFieldArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetFieldArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetPointArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetPointArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetRowArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetRowArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetVertexArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetVertexArrayName(self, inputName:str, newName:str) -> None: ...

class vtkAssignAttribute(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class AttributeLocation(int): ...
    CELL_DATA:'AttributeLocation'
    EDGE_DATA:'AttributeLocation'
    NUM_ATTRIBUTE_LOCS:'AttributeLocation'
    POINT_DATA:'AttributeLocation'
    VERTEX_DATA:'AttributeLocation'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def Assign(self, inputAttributeType:int, attributeType:int, attributeLoc:int) -> None: ...
    @overload
    def Assign(self, fieldName:str, attributeType:int, attributeLoc:int) -> None: ...
    @overload
    def Assign(self, name:str, attributeType:str, attributeLoc:str) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAssignAttribute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAssignAttribute': ...

class vtkAttributeDataToFieldDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    pass_attribute_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassAttributeData(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAttributeDataToFieldDataFilter': ...
    def PassAttributeDataOff(self) -> None: ...
    def PassAttributeDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAttributeDataToFieldDataFilter': ...
    def SetPassAttributeData(self, _arg:int) -> None: ...

class vtkAttributeDataToTableFilter(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    add_meta_data:'getset_descriptor'
    field_association:'getset_descriptor'
    generate_cell_connectivity:'getset_descriptor'
    generate_original_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddMetaDataOff(self) -> None: ...
    def AddMetaDataOn(self) -> None: ...
    def GenerateCellConnectivityOff(self) -> None: ...
    def GenerateCellConnectivityOn(self) -> None: ...
    def GenerateOriginalIdsOff(self) -> None: ...
    def GenerateOriginalIdsOn(self) -> None: ...
    def GetAddMetaData(self) -> bool: ...
    def GetFieldAssociation(self) -> int: ...
    def GetGenerateCellConnectivity(self) -> bool: ...
    def GetGenerateOriginalIds(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAttributeDataToTableFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAttributeDataToTableFilter': ...
    def SetAddMetaData(self, _arg:bool) -> None: ...
    def SetFieldAssociation(self, _arg:int) -> None: ...
    def SetGenerateCellConnectivity(self, _arg:bool) -> None: ...
    def SetGenerateOriginalIds(self, _arg:bool) -> None: ...

class vtkBinCellDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class CellOverlapCriterion(int): ...
    CELL_CENTROID:'CellOverlapCriterion'
    CELL_POINTS:'CellOverlapCriterion'
    array_component:'getset_descriptor'
    cell_locator:'getset_descriptor'
    cell_overlap_method:'getset_descriptor'
    compute_tolerance:'getset_descriptor'
    number_of_bins:'getset_descriptor'
    number_of_nonzero_bins_array_name:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    spatial_match:'getset_descriptor'
    store_number_of_nonzero_bins:'getset_descriptor'
    tolerance:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    @overload
    def GenerateValues(self, numBins:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numBins:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetCellLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetCellOverlapMethod(self) -> int: ...
    def GetCellOverlapMethodMaxValue(self) -> int: ...
    def GetCellOverlapMethodMinValue(self) -> int: ...
    def GetComputeTolerance(self) -> bool: ...
    def GetNumberOfBins(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNonzeroBinsArrayName(self) -> str: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetSpatialMatch(self) -> int: ...
    def GetStoreNumberOfNonzeroBins(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, binValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBinCellDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBinCellDataFilter': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetCellLocator(self, cellLocator:'vtkAbstractCellLocator') -> None: ...
    def SetCellOverlapMethod(self, _arg:int) -> None: ...
    def SetComputeTolerance(self, _arg:bool) -> None: ...
    def SetNumberOfBins(self, numBins:int) -> None: ...
    def SetNumberOfNonzeroBinsArrayName(self, _arg:str) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetSpatialMatch(self, _arg:int) -> None: ...
    def SetStoreNumberOfNonzeroBins(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def SpatialMatchOff(self) -> None: ...
    def SpatialMatchOn(self) -> None: ...
    def StoreNumberOfNonzeroBinsOff(self) -> None: ...
    def StoreNumberOfNonzeroBinsOn(self) -> None: ...

class vtkBinnedDecimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    BIN_AVERAGES:int
    BIN_CENTERS:int
    BIN_POINTS:int
    INPUT_POINTS:int
    auto_adjust_number_of_divisions:'getset_descriptor'
    division_origin:'getset_descriptor'
    division_spacing:'getset_descriptor'
    large_ids:'getset_descriptor'
    number_of_divisions:'getset_descriptor'
    number_of_x_divisions:'getset_descriptor'
    number_of_y_divisions:'getset_descriptor'
    number_of_z_divisions:'getset_descriptor'
    point_generation_mode:'getset_descriptor'
    produce_cell_data:'getset_descriptor'
    produce_point_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoAdjustNumberOfDivisionsOff(self) -> None: ...
    def AutoAdjustNumberOfDivisionsOn(self) -> None: ...
    def GetAutoAdjustNumberOfDivisions(self) -> bool: ...
    def GetDivisionOrigin(self) -> Tuple[float, float, float]: ...
    def GetDivisionSpacing(self) -> Tuple[float, float, float]: ...
    def GetLargeIds(self) -> bool: ...
    @overload
    def GetNumberOfDivisions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfXDivisions(self) -> int: ...
    def GetNumberOfYDivisions(self) -> int: ...
    def GetNumberOfZDivisions(self) -> int: ...
    def GetPointGenerationMode(self) -> int: ...
    def GetPointGenerationModeMaxValue(self) -> int: ...
    def GetPointGenerationModeMinValue(self) -> int: ...
    def GetProduceCellData(self) -> bool: ...
    def GetProducePointData(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBinnedDecimation': ...
    def ProduceCellDataOff(self) -> None: ...
    def ProduceCellDataOn(self) -> None: ...
    def ProducePointDataOff(self) -> None: ...
    def ProducePointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBinnedDecimation': ...
    def SetAutoAdjustNumberOfDivisions(self, _arg:bool) -> None: ...
    @overload
    def SetDivisionOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionOrigin(self, o:MutableSequence[float]) -> None: ...
    @overload
    def SetDivisionSpacing(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionSpacing(self, s:MutableSequence[float]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div0:int, div1:int, div2:int) -> None: ...
    def SetNumberOfXDivisions(self, num:int) -> None: ...
    def SetNumberOfYDivisions(self, num:int) -> None: ...
    def SetNumberOfZDivisions(self, num:int) -> None: ...
    def SetPointGenerationMode(self, _arg:int) -> None: ...
    def SetPointGenerationModeToBinAverages(self) -> None: ...
    def SetPointGenerationModeToBinCenters(self) -> None: ...
    def SetPointGenerationModeToBinPoints(self) -> None: ...
    def SetPointGenerationModeToUseInputPoints(self) -> None: ...
    def SetProduceCellData(self, _arg:bool) -> None: ...
    def SetProducePointData(self, _arg:bool) -> None: ...

class vtkCellCenters(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    convert_ghost_cells_to_ghost_points:'getset_descriptor'
    copy_arrays:'getset_descriptor'
    vertex_cells:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ComputeCellCenters(dataset:'vtkDataSet', centers:'vtkDoubleArray') -> None: ...
    def ConvertGhostCellsToGhostPointsOff(self) -> None: ...
    def ConvertGhostCellsToGhostPointsOn(self) -> None: ...
    def CopyArraysOff(self) -> None: ...
    def CopyArraysOn(self) -> None: ...
    def GetConvertGhostCellsToGhostPoints(self) -> bool: ...
    def GetCopyArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertexCells(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellCenters': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellCenters': ...
    def SetConvertGhostCellsToGhostPoints(self, _arg:bool) -> None: ...
    def SetCopyArrays(self, _arg:bool) -> None: ...
    def SetVertexCells(self, _arg:bool) -> None: ...
    def VertexCellsOff(self) -> None: ...
    def VertexCellsOn(self) -> None: ...

class vtkCellDataToPointData(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class ContributingCellEnum(int): ...
    All:'ContributingCellEnum'
    DataSetMax:'ContributingCellEnum'
    Patch:'ContributingCellEnum'
    contributing_cell_option:'getset_descriptor'
    pass_cell_data:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    process_all_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCellDataArray(self, name:str) -> None: ...
    def ClearCellDataArrays(self) -> None: ...
    def GetContributingCellOption(self) -> int: ...
    def GetContributingCellOptionMaxValue(self) -> int: ...
    def GetContributingCellOptionMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellData(self) -> bool: ...
    def GetPieceInvariant(self) -> bool: ...
    def GetProcessAllArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellDataToPointData': ...
    def PassCellDataOff(self) -> None: ...
    def PassCellDataOn(self) -> None: ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def ProcessAllArraysOff(self) -> None: ...
    def ProcessAllArraysOn(self) -> None: ...
    def RemoveCellDataArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellDataToPointData': ...
    def SetContributingCellOption(self, _arg:int) -> None: ...
    def SetPassCellData(self, _arg:bool) -> None: ...
    def SetPieceInvariant(self, _arg:bool) -> None: ...
    def SetProcessAllArrays(self, _arg:bool) -> None: ...

class vtkCenterOfMass(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    center:'getset_descriptor'
    use_scalars_as_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ComputeCenterOfMass(input:'vtkPoints', scalars:'vtkDataArray', center:MutableSequence[float]) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseScalarsAsWeights(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCenterOfMass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCenterOfMass': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetUseScalarsAsWeights(self, _arg:bool) -> None: ...

class vtkCleanPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    absolute_tolerance:'getset_descriptor'
    convert_lines_to_points:'getset_descriptor'
    convert_polys_to_lines:'getset_descriptor'
    convert_strips_to_polys:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    point_merging:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ConvertLinesToPointsOff(self) -> None: ...
    def ConvertLinesToPointsOn(self) -> None: ...
    def ConvertPolysToLinesOff(self) -> None: ...
    def ConvertPolysToLinesOn(self) -> None: ...
    def ConvertStripsToPolysOff(self) -> None: ...
    def ConvertStripsToPolysOn(self) -> None: ...
    def CreateDefaultLocator(self, input:'vtkPolyData'=...) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetConvertLinesToPoints(self) -> int: ...
    def GetConvertPolysToLines(self) -> int: ...
    def GetConvertStripsToPolys(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def GetPointMerging(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> int: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCleanPolyData': ...
    def OperateOnBounds(self, in_:MutableSequence[float], out:MutableSequence[float]) -> None: ...
    def OperateOnPoint(self, in_:MutableSequence[float], out:MutableSequence[float]) -> None: ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def PointMergingOff(self) -> None: ...
    def PointMergingOn(self) -> None: ...
    def ReleaseLocator(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCleanPolyData': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetConvertLinesToPoints(self, _arg:int) -> None: ...
    def SetConvertPolysToLines(self, _arg:int) -> None: ...
    def SetConvertStripsToPolys(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    def SetPointMerging(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:int) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkClipPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    clip_function:'getset_descriptor'
    clipped_output:'getset_descriptor'
    clipped_output_port:'getset_descriptor'
    generate_clip_scalars:'getset_descriptor'
    generate_clipped_output:'getset_descriptor'
    inside_out:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    value:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GenerateClipScalarsOff(self) -> None: ...
    def GenerateClipScalarsOn(self) -> None: ...
    def GenerateClippedOutputOff(self) -> None: ...
    def GenerateClippedOutputOn(self) -> None: ...
    def GetClipFunction(self) -> 'vtkImplicitFunction': ...
    def GetClippedOutput(self) -> 'vtkPolyData': ...
    def GetClippedOutputPort(self) -> 'vtkAlgorithmOutput': ...
    def GetGenerateClipScalars(self) -> int: ...
    def GetGenerateClippedOutput(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetValue(self) -> float: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClipPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClipPolyData': ...
    def SetClipFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateClipScalars(self, _arg:int) -> None: ...
    def SetGenerateClippedOutput(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetValue(self, _arg:float) -> None: ...

class vtkCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    cut_function:'getset_descriptor'
    generate_cut_scalars:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    sort_by:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GenerateCutScalarsOff(self) -> None: ...
    def GenerateCutScalarsOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    @staticmethod
    def GetCellTypeDimensions(cellTypeDimensions:MutableSequence[int]) -> None: ...
    def GetCutFunction(self) -> 'vtkImplicitFunction': ...
    def GetGenerateCutScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetSortBy(self) -> int: ...
    def GetSortByAsString(self) -> str: ...
    def GetSortByMaxValue(self) -> int: ...
    def GetSortByMinValue(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCutter': ...
    def SetCutFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateCutScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSortBy(self, _arg:int) -> None: ...
    def SetSortByToSortByCell(self) -> None: ...
    def SetSortByToSortByValue(self) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkCompositeCutter(vtkCutter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeCutter': ...

class vtkProbeFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    categorical_data:'getset_descriptor'
    cell_locator_prototype:'getset_descriptor'
    compute_tolerance:'getset_descriptor'
    find_cell_strategy:'getset_descriptor'
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    snap_to_cell_with_closest_point:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    spatial_match:'getset_descriptor'
    tolerance:'getset_descriptor'
    valid_point_mask_array_name:'getset_descriptor'
    valid_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CategoricalDataOff(self) -> None: ...
    def CategoricalDataOn(self) -> None: ...
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    def GetCategoricalData(self) -> int: ...
    def GetCellLocatorPrototype(self) -> 'vtkAbstractCellLocator': ...
    def GetComputeTolerance(self) -> bool: ...
    def GetFindCellStrategy(self) -> 'vtkFindCellStrategy': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> int: ...
    def GetPassFieldArrays(self) -> int: ...
    def GetPassPointArrays(self) -> int: ...
    def GetSnapToCellWithClosestPoint(self) -> bool: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetSpatialMatch(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetValidPointMaskArrayName(self) -> str: ...
    def GetValidPoints(self) -> 'vtkIdTypeArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProbeFilter': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProbeFilter': ...
    def SetCategoricalData(self, _arg:int) -> None: ...
    def SetCellLocatorPrototype(self, __a:'vtkAbstractCellLocator') -> None: ...
    def SetComputeTolerance(self, _arg:bool) -> None: ...
    def SetFindCellStrategy(self, __a:'vtkFindCellStrategy') -> None: ...
    def SetPassCellArrays(self, _arg:int) -> None: ...
    def SetPassFieldArrays(self, _arg:int) -> None: ...
    def SetPassPointArrays(self, _arg:int) -> None: ...
    def SetSnapToCellWithClosestPoint(self, _arg:bool) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetSpatialMatch(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetValidPointMaskArrayName(self, _arg:str) -> None: ...
    def SnapToCellWithClosestPointOff(self) -> None: ...
    def SnapToCellWithClosestPointOn(self) -> None: ...
    def SpatialMatchOff(self) -> None: ...
    def SpatialMatchOn(self) -> None: ...

class vtkCompositeDataProbeFilter(vtkProbeFilter):
    pass_partial_arrays:'getset_descriptor'
    use_implicit_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassPartialArrays(self) -> bool: ...
    def GetUseImplicitArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataProbeFilter': ...
    def PassPartialArraysOff(self) -> None: ...
    def PassPartialArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataProbeFilter': ...
    def SetPassPartialArrays(self, _arg:bool) -> None: ...
    def SetUseImplicitArrays(self, _arg:bool) -> None: ...
    def UseImplicitArraysOff(self) -> None: ...
    def UseImplicitArraysOn(self) -> None: ...

class vtkConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    class RegionIdAssignment(int): ...
    CELL_COUNT_ASCENDING:'RegionIdAssignment'
    CELL_COUNT_DESCENDING:'RegionIdAssignment'
    UNSPECIFIED:'RegionIdAssignment'
    closest_point:'getset_descriptor'
    color_regions:'getset_descriptor'
    compress_arrays:'getset_descriptor'
    extraction_mode:'getset_descriptor'
    number_of_extracted_regions:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    region_id_assignment_mode:'getset_descriptor'
    scalar_connectivity:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def ColorRegionsOff(self) -> None: ...
    def ColorRegionsOn(self) -> None: ...
    def CompressArraysOff(self) -> None: ...
    def CompressArraysOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorRegions(self) -> int: ...
    def GetCompressArrays(self) -> bool: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRegionIdAssignmentMode(self) -> int: ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConnectivityFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorRegions(self, _arg:int) -> None: ...
    def SetCompressArrays(self, _arg:bool) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToCellSeededRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRegionIdAssignmentMode(self, _arg:int) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkConstrainedSmoothingFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    class ConstraintStrategyType(int): ...
    CONSTRAINT_ARRAY:'ConstraintStrategyType'
    CONSTRAINT_BOX:'ConstraintStrategyType'
    CONSTRAINT_DISTANCE:'ConstraintStrategyType'
    DEFAULT:'ConstraintStrategyType'
    constraint_box:'getset_descriptor'
    constraint_distance:'getset_descriptor'
    constraint_strategy:'getset_descriptor'
    convergence:'getset_descriptor'
    generate_error_scalars:'getset_descriptor'
    generate_error_vectors:'getset_descriptor'
    number_of_iterations:'getset_descriptor'
    number_of_iterations_max_value:'getset_descriptor'
    number_of_iterations_min_value:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    relaxation_factor:'getset_descriptor'
    smoothing_stencils:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateErrorScalarsOff(self) -> None: ...
    def GenerateErrorScalarsOn(self) -> None: ...
    def GenerateErrorVectorsOff(self) -> None: ...
    def GenerateErrorVectorsOn(self) -> None: ...
    def GetConstraintBox(self) -> Tuple[float, float, float]: ...
    def GetConstraintDistance(self) -> float: ...
    def GetConstraintDistanceMaxValue(self) -> float: ...
    def GetConstraintDistanceMinValue(self) -> float: ...
    def GetConstraintStrategy(self) -> int: ...
    def GetConstraintStrategyMaxValue(self) -> int: ...
    def GetConstraintStrategyMinValue(self) -> int: ...
    def GetConvergence(self) -> float: ...
    def GetConvergenceMaxValue(self) -> float: ...
    def GetConvergenceMinValue(self) -> float: ...
    def GetGenerateErrorScalars(self) -> bool: ...
    def GetGenerateErrorVectors(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRelaxationFactor(self) -> float: ...
    def GetSmoothingStencils(self) -> 'vtkCellArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConstrainedSmoothingFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConstrainedSmoothingFilter': ...
    @overload
    def SetConstraintBox(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetConstraintBox(self, _arg:Sequence[float]) -> None: ...
    def SetConstraintDistance(self, _arg:float) -> None: ...
    def SetConstraintStrategy(self, _arg:int) -> None: ...
    def SetConstraintStrategyToConstraintArray(self) -> None: ...
    def SetConstraintStrategyToConstraintBox(self) -> None: ...
    def SetConstraintStrategyToConstraintDistance(self) -> None: ...
    def SetConstraintStrategyToDefault(self) -> None: ...
    def SetConvergence(self, _arg:float) -> None: ...
    def SetGenerateErrorScalars(self, _arg:bool) -> None: ...
    def SetGenerateErrorVectors(self, _arg:bool) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRelaxationFactor(self, _arg:float) -> None: ...
    def SetSmoothingStencils(self, _arg:'vtkCellArray') -> None: ...

class vtkContour3DLinearGrid(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    large_ids:'getset_descriptor'
    m_time:'getset_descriptor'
    merge_points:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    number_of_threads_used:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    scalar_tree:'getset_descriptor'
    sequential_processing:'getset_descriptor'
    use_scalar_tree:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject', scalarArrayName:str) -> bool: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetLargeIds(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMergePoints(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScalarTree(self) -> 'vtkScalarTree': ...
    def GetSequentialProcessing(self) -> int: ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkContour3DLinearGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContour3DLinearGrid': ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetMergePoints(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScalarTree(self, __a:'vtkScalarTree') -> None: ...
    def SetSequentialProcessing(self, _arg:int) -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkContourFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    contour_values:'getset_descriptor'
    fast_mode:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    input_array:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    scalar_tree:'getset_descriptor'
    use_scalar_tree:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def FastModeOff(self) -> None: ...
    def FastModeOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetContourValues(self) -> Tuple[float, float]: ...
    def GetFastMode(self) -> bool: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScalarTree(self) -> 'vtkScalarTree': ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourFilter': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetContourValues(self, values:Sequence[float]) -> None: ...
    def SetFastMode(self, _arg:bool) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetInputArray(self, name:str) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScalarTree(self, __a:'vtkScalarTree') -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkContourGrid(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    scalar_tree:'getset_descriptor'
    use_scalar_tree:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScalarTree(self) -> 'vtkScalarTree': ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourGrid': ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetScalarTree(self, sTree:'vtkScalarTree') -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkContourHelper(object):
    def __init__(self, locator:'vtkIncrementalPointLocator', outVerts:'vtkCellArray', outLines:'vtkCellArray', outPolys:'vtkCellArray', inPd:'vtkPointData', inCd:'vtkCellData', outPd:'vtkPointData', outCd:'vtkCellData', trisEstimatedSize:int, outputTriangles:bool) -> None: ...
    def Contour(self, cell:'vtkCell', value:float, cellScalars:'vtkDataArray', cellId:int) -> None: ...

class vtkConvertToMultiBlockDataSet(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToMultiBlockDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToMultiBlockDataSet': ...

class vtkConvertToPartitionedDataSetCollection(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToPartitionedDataSetCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToPartitionedDataSetCollection': ...

class vtkConvertToPolyhedra(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    output_all_cells:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputAllCells(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToPolyhedra': ...
    def OutputAllCellsOff(self) -> None: ...
    def OutputAllCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToPolyhedra': ...
    def SetOutputAllCells(self, _arg:bool) -> None: ...

class vtkDataObjectGenerator(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    program:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProgram(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectGenerator': ...
    def SetProgram(self, _arg:str) -> None: ...

class vtkDataObjectToDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    cell_connectivity_component_array_component:'getset_descriptor'
    cell_connectivity_component_array_name:'getset_descriptor'
    cell_connectivity_component_max_range:'getset_descriptor'
    cell_connectivity_component_min_range:'getset_descriptor'
    cell_type_component_array_component:'getset_descriptor'
    cell_type_component_array_name:'getset_descriptor'
    cell_type_component_max_range:'getset_descriptor'
    cell_type_component_min_range:'getset_descriptor'
    data_set_type:'getset_descriptor'
    default_normalize:'getset_descriptor'
    dimensions:'getset_descriptor'
    input:'getset_descriptor'
    lines_component_array_component:'getset_descriptor'
    lines_component_array_name:'getset_descriptor'
    lines_component_max_range:'getset_descriptor'
    lines_component_min_range:'getset_descriptor'
    origin:'getset_descriptor'
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    polys_component_array_component:'getset_descriptor'
    polys_component_array_name:'getset_descriptor'
    polys_component_max_range:'getset_descriptor'
    polys_component_min_range:'getset_descriptor'
    rectilinear_grid_output:'getset_descriptor'
    spacing:'getset_descriptor'
    strips_component_array_component:'getset_descriptor'
    strips_component_array_name:'getset_descriptor'
    strips_component_max_range:'getset_descriptor'
    strips_component_min_range:'getset_descriptor'
    structured_grid_output:'getset_descriptor'
    structured_points_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    verts_component_array_component:'getset_descriptor'
    verts_component_array_name:'getset_descriptor'
    verts_component_max_range:'getset_descriptor'
    verts_component_min_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DefaultNormalizeOff(self) -> None: ...
    def DefaultNormalizeOn(self) -> None: ...
    def GetCellConnectivityComponentArrayComponent(self) -> int: ...
    def GetCellConnectivityComponentArrayName(self) -> str: ...
    def GetCellConnectivityComponentMaxRange(self) -> int: ...
    def GetCellConnectivityComponentMinRange(self) -> int: ...
    def GetCellTypeComponentArrayComponent(self) -> int: ...
    def GetCellTypeComponentArrayName(self) -> str: ...
    def GetCellTypeComponentMaxRange(self) -> int: ...
    def GetCellTypeComponentMinRange(self) -> int: ...
    def GetDataSetType(self) -> int: ...
    def GetDefaultNormalize(self) -> int: ...
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetLinesComponentArrayComponent(self) -> int: ...
    def GetLinesComponentArrayName(self) -> str: ...
    def GetLinesComponentMaxRange(self) -> int: ...
    def GetLinesComponentMinRange(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOutput(self) -> 'vtkDataSet': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkDataSet': ...
    def GetPointComponentArrayComponent(self, comp:int) -> int: ...
    def GetPointComponentArrayName(self, comp:int) -> str: ...
    def GetPointComponentMaxRange(self, comp:int) -> int: ...
    def GetPointComponentMinRange(self, comp:int) -> int: ...
    def GetPointComponentNormailzeFlag(self, comp:int) -> int: ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetPolysComponentArrayComponent(self) -> int: ...
    def GetPolysComponentArrayName(self) -> str: ...
    def GetPolysComponentMaxRange(self) -> int: ...
    def GetPolysComponentMinRange(self) -> int: ...
    def GetRectilinearGridOutput(self) -> 'vtkRectilinearGrid': ...
    def GetSpacing(self) -> Tuple[float, float, float]: ...
    def GetStripsComponentArrayComponent(self) -> int: ...
    def GetStripsComponentArrayName(self) -> str: ...
    def GetStripsComponentMaxRange(self) -> int: ...
    def GetStripsComponentMinRange(self) -> int: ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def GetVertsComponentArrayComponent(self) -> int: ...
    def GetVertsComponentArrayName(self) -> str: ...
    def GetVertsComponentMaxRange(self) -> int: ...
    def GetVertsComponentMinRange(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectToDataSetFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectToDataSetFilter': ...
    @overload
    def SetCellConnectivityComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetCellConnectivityComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetCellTypeComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetCellTypeComponent(self, arrayName:str, arrayComp:int) -> None: ...
    def SetDataSetType(self, __a:int) -> None: ...
    def SetDataSetTypeToPolyData(self) -> None: ...
    def SetDataSetTypeToRectilinearGrid(self) -> None: ...
    def SetDataSetTypeToStructuredGrid(self) -> None: ...
    def SetDataSetTypeToStructuredPoints(self) -> None: ...
    def SetDataSetTypeToUnstructuredGrid(self) -> None: ...
    def SetDefaultNormalize(self, _arg:int) -> None: ...
    @overload
    def SetDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDimensions(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetDimensionsComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetDimensionsComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetLinesComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetLinesComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOriginComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetOriginComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetPointComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetPointComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetPolysComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetPolysComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpacing(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSpacingComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetSpacingComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetStripsComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetStripsComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetVertsComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetVertsComponent(self, arrayName:str, arrayComp:int) -> None: ...

class vtkEdgeSubdivisionCriterion(vtkmodules.vtkCommonCore.vtkObject):
    field_ids:'getset_descriptor'
    field_offsets:'getset_descriptor'
    number_of_fields:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DontPassField(self, sourceId:int, t:'vtkStreamingTessellator') -> bool: ...
    def EvaluateLocationAndFields(self, p1:MutableSequence[float], field_start:int) -> bool: ...
    def GetFieldIds(self) -> Pointer: ...
    def GetFieldOffsets(self) -> Pointer: ...
    def GetNumberOfFields(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputField(self, fieldId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEdgeSubdivisionCriterion': ...
    def PassField(self, sourceId:int, sourceSize:int, t:'vtkStreamingTessellator') -> int: ...
    def ResetFieldList(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEdgeSubdivisionCriterion': ...

class vtkDataSetEdgeSubdivisionCriterion(vtkEdgeSubdivisionCriterion):
    active_field_criteria:'getset_descriptor'
    cell:'getset_descriptor'
    cell_id:'getset_descriptor'
    chord_error2:'getset_descriptor'
    mesh:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def EvaluateCellDataField(self, result:MutableSequence[float], weights:MutableSequence[float], field:int) -> None: ...
    def EvaluateFields(self, vertex:MutableSequence[float], weights:MutableSequence[float], field_start:int) -> Pointer: ...
    def EvaluateLocationAndFields(self, midpt:MutableSequence[float], field_start:int) -> bool: ...
    def EvaluatePointDataField(self, result:MutableSequence[float], weights:MutableSequence[float], field:int) -> None: ...
    def GetActiveFieldCriteria(self) -> int: ...
    def GetCell(self) -> 'vtkCell': ...
    def GetCellId(self) -> int: ...
    def GetChordError2(self) -> float: ...
    def GetFieldError2(self, s:int) -> float: ...
    def GetMesh(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetEdgeSubdivisionCriterion': ...
    def ResetFieldError2(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetEdgeSubdivisionCriterion': ...
    def SetCellId(self, cell:int) -> None: ...
    def SetChordError2(self, _arg:float) -> None: ...
    def SetFieldError2(self, s:int, err:float) -> None: ...
    def SetMesh(self, __a:'vtkDataSet') -> None: ...

class vtkDataSetToDataObjectFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    cell_data:'getset_descriptor'
    field_data:'getset_descriptor'
    geometry:'getset_descriptor'
    legacy_topology:'getset_descriptor'
    modern_topology:'getset_descriptor'
    point_data:'getset_descriptor'
    topology:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellDataOff(self) -> None: ...
    def CellDataOn(self) -> None: ...
    def FieldDataOff(self) -> None: ...
    def FieldDataOn(self) -> None: ...
    def GeometryOff(self) -> None: ...
    def GeometryOn(self) -> None: ...
    def GetCellData(self) -> int: ...
    def GetFieldData(self) -> int: ...
    def GetGeometry(self) -> int: ...
    def GetLegacyTopology(self) -> int: ...
    def GetModernTopology(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointData(self) -> int: ...
    def GetTopology(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LegacyTopologyOff(self) -> None: ...
    def LegacyTopologyOn(self) -> None: ...
    def ModernTopologyOff(self) -> None: ...
    def ModernTopologyOn(self) -> None: ...
    def NewInstance(self) -> 'vtkDataSetToDataObjectFilter': ...
    def PointDataOff(self) -> None: ...
    def PointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetToDataObjectFilter': ...
    def SetCellData(self, _arg:int) -> None: ...
    def SetFieldData(self, _arg:int) -> None: ...
    def SetGeometry(self, _arg:int) -> None: ...
    def SetLegacyTopology(self, _arg:int) -> None: ...
    def SetModernTopology(self, _arg:int) -> None: ...
    def SetPointData(self, _arg:int) -> None: ...
    def SetTopology(self, _arg:int) -> None: ...
    def TopologyOff(self) -> None: ...
    def TopologyOn(self) -> None: ...

class vtkDecimatePolylineStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeError(self, dataset:'vtkPointSet', originId:int, p1Id:int, p2Id:int) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsStateValid(self, dataset:'vtkPointSet') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePolylineStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePolylineStrategy': ...

class vtkDecimatePolylineAngleStrategy(vtkDecimatePolylineStrategy):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeError(self, dataset:'vtkPointSet', originId:int, p1Id:int, p2Id:int) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePolylineAngleStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePolylineAngleStrategy': ...

class vtkDecimatePolylineCustomFieldStrategy(vtkDecimatePolylineStrategy):
    field_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeError(self, dataset:'vtkPointSet', originId:int, p1Id:int, p2Id:int) -> float: ...
    def GetFieldName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsStateValid(self, dataset:'vtkPointSet') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePolylineCustomFieldStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePolylineCustomFieldStrategy': ...
    def SetFieldName(self, _arg:str) -> None: ...

class vtkDecimatePolylineDistanceStrategy(vtkDecimatePolylineStrategy):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeError(self, dataset:'vtkPointSet', originId:int, p1Id:int, p2Id:int) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePolylineDistanceStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePolylineDistanceStrategy': ...

class vtkDecimatePolylineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    decimation_strategy:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_error:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    target_reduction:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDecimationStrategy(self) -> 'vtkDecimatePolylineStrategy': ...
    def GetMTime(self) -> int: ...
    def GetMaximumError(self) -> float: ...
    def GetMaximumErrorMaxValue(self) -> float: ...
    def GetMaximumErrorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTargetReduction(self) -> float: ...
    def GetTargetReductionMaxValue(self) -> float: ...
    def GetTargetReductionMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePolylineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePolylineFilter': ...
    def SetDecimationStrategy(self, _arg:'vtkDecimatePolylineStrategy') -> None: ...
    def SetMaximumError(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...

class vtkDecimatePro(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    absolute_error:'getset_descriptor'
    accumulate_error:'getset_descriptor'
    boundary_vertex_deletion:'getset_descriptor'
    degree:'getset_descriptor'
    error_is_absolute:'getset_descriptor'
    feature_angle:'getset_descriptor'
    inflection_point_ratio:'getset_descriptor'
    inflection_points:'getset_descriptor'
    maximum_error:'getset_descriptor'
    number_of_inflection_points:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    pre_split_mesh:'getset_descriptor'
    preserve_topology:'getset_descriptor'
    split_angle:'getset_descriptor'
    splitting:'getset_descriptor'
    target_reduction:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AccumulateErrorOff(self) -> None: ...
    def AccumulateErrorOn(self) -> None: ...
    def BoundaryVertexDeletionOff(self) -> None: ...
    def BoundaryVertexDeletionOn(self) -> None: ...
    def GetAbsoluteError(self) -> float: ...
    def GetAbsoluteErrorMaxValue(self) -> float: ...
    def GetAbsoluteErrorMinValue(self) -> float: ...
    def GetAccumulateError(self) -> int: ...
    def GetBoundaryVertexDeletion(self) -> int: ...
    def GetDegree(self) -> int: ...
    def GetDegreeMaxValue(self) -> int: ...
    def GetDegreeMinValue(self) -> int: ...
    def GetErrorIsAbsolute(self) -> int: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetInflectionPointRatio(self) -> float: ...
    def GetInflectionPointRatioMaxValue(self) -> float: ...
    def GetInflectionPointRatioMinValue(self) -> float: ...
    @overload
    def GetInflectionPoints(self, inflectionPoints:MutableSequence[float]) -> None: ...
    @overload
    def GetInflectionPoints(self) -> Pointer: ...
    def GetMaximumError(self) -> float: ...
    def GetMaximumErrorMaxValue(self) -> float: ...
    def GetMaximumErrorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInflectionPoints(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPreSplitMesh(self) -> int: ...
    def GetPreserveTopology(self) -> int: ...
    def GetSplitAngle(self) -> float: ...
    def GetSplitAngleMaxValue(self) -> float: ...
    def GetSplitAngleMinValue(self) -> float: ...
    def GetSplitting(self) -> int: ...
    def GetTargetReduction(self) -> float: ...
    def GetTargetReductionMaxValue(self) -> float: ...
    def GetTargetReductionMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePro': ...
    def PreSplitMeshOff(self) -> None: ...
    def PreSplitMeshOn(self) -> None: ...
    def PreserveTopologyOff(self) -> None: ...
    def PreserveTopologyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePro': ...
    def SetAbsoluteError(self, _arg:float) -> None: ...
    def SetAccumulateError(self, _arg:int) -> None: ...
    def SetBoundaryVertexDeletion(self, _arg:int) -> None: ...
    def SetDegree(self, _arg:int) -> None: ...
    def SetErrorIsAbsolute(self, _arg:int) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetInflectionPointRatio(self, _arg:float) -> None: ...
    def SetMaximumError(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPreSplitMesh(self, _arg:int) -> None: ...
    def SetPreserveTopology(self, _arg:int) -> None: ...
    def SetSplitAngle(self, _arg:float) -> None: ...
    def SetSplitting(self, _arg:int) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...
    def SplittingOff(self) -> None: ...
    def SplittingOn(self) -> None: ...

class vtkDelaunay2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    alpha:'getset_descriptor'
    bounding_triangulation:'getset_descriptor'
    offset:'getset_descriptor'
    projection_plane_mode:'getset_descriptor'
    random_point_insertion:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundingTriangulationOff(self) -> None: ...
    def BoundingTriangulationOn(self) -> None: ...
    @staticmethod
    def ComputeBestFittingPlane(input:'vtkPointSet') -> 'vtkAbstractTransform': ...
    def GetAlpha(self) -> float: ...
    def GetAlphaMaxValue(self) -> float: ...
    def GetAlphaMinValue(self) -> float: ...
    def GetBoundingTriangulation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetOffsetMaxValue(self) -> float: ...
    def GetOffsetMinValue(self) -> float: ...
    def GetProjectionPlaneMode(self) -> int: ...
    def GetProjectionPlaneModeMaxValue(self) -> int: ...
    def GetProjectionPlaneModeMinValue(self) -> int: ...
    def GetRandomPointInsertion(self) -> int: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDelaunay2D': ...
    def RandomPointInsertionOff(self) -> None: ...
    def RandomPointInsertionOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDelaunay2D': ...
    def SetAlpha(self, _arg:float) -> None: ...
    def SetBoundingTriangulation(self, _arg:int) -> None: ...
    def SetOffset(self, _arg:float) -> None: ...
    def SetProjectionPlaneMode(self, _arg:int) -> None: ...
    def SetRandomPointInsertion(self, _arg:int) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, __a:'vtkPolyData') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetTransform(self, _arg:'vtkAbstractTransform') -> None: ...

class vtkDelaunay3D(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    alpha:'getset_descriptor'
    alpha_lines:'getset_descriptor'
    alpha_tets:'getset_descriptor'
    alpha_tris:'getset_descriptor'
    alpha_verts:'getset_descriptor'
    bounding_triangulation:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    offset:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AlphaLinesOff(self) -> None: ...
    def AlphaLinesOn(self) -> None: ...
    def AlphaTetsOff(self) -> None: ...
    def AlphaTetsOn(self) -> None: ...
    def AlphaTrisOff(self) -> None: ...
    def AlphaTrisOn(self) -> None: ...
    def AlphaVertsOff(self) -> None: ...
    def AlphaVertsOn(self) -> None: ...
    def BoundingTriangulationOff(self) -> None: ...
    def BoundingTriangulationOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def EndPointInsertion(self) -> None: ...
    def GetAlpha(self) -> float: ...
    def GetAlphaLines(self) -> int: ...
    def GetAlphaMaxValue(self) -> float: ...
    def GetAlphaMinValue(self) -> float: ...
    def GetAlphaTets(self) -> int: ...
    def GetAlphaTris(self) -> int: ...
    def GetAlphaVerts(self) -> int: ...
    def GetBoundingTriangulation(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetOffsetMaxValue(self) -> float: ...
    def GetOffsetMinValue(self) -> float: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def InsertPoint(self, Mesh:'vtkUnstructuredGrid', points:'vtkPoints', id:int, x:MutableSequence[float], holeTetras:'vtkIdList') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDelaunay3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDelaunay3D': ...
    def SetAlpha(self, _arg:float) -> None: ...
    def SetAlphaLines(self, _arg:int) -> None: ...
    def SetAlphaTets(self, _arg:int) -> None: ...
    def SetAlphaTris(self, _arg:int) -> None: ...
    def SetAlphaVerts(self, _arg:int) -> None: ...
    def SetBoundingTriangulation(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOffset(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkElevationFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    high_point:'getset_descriptor'
    low_point:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetHighPoint(self) -> Tuple[float, float, float]: ...
    def GetLowPoint(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkElevationFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkElevationFilter': ...
    @overload
    def SetHighPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHighPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetLowPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLowPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkExecutionTimer(vtkmodules.vtkCommonCore.vtkObject):
    elapsed_cpu_time:'getset_descriptor'
    elapsed_wall_clock_time:'getset_descriptor'
    filter:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetElapsedCPUTime(self) -> float: ...
    def GetElapsedWallClockTime(self) -> float: ...
    def GetFilter(self) -> 'vtkAlgorithm': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExecutionTimer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExecutionTimer': ...
    def SetFilter(self, filter:'vtkAlgorithm') -> None: ...

class vtkExplicitStructuredGridCrop(vtkmodules.vtkCommonExecutionModel.vtkExplicitStructuredGridAlgorithm):
    output_whole_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetOutputWholeExtent(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGridCrop': ...
    def ResetOutputWholeExtent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGridCrop': ...
    @overload
    def SetOutputWholeExtent(self, extent:MutableSequence[int], outInfo:'vtkInformation'=...) -> None: ...
    @overload
    def SetOutputWholeExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...

class vtkExplicitStructuredGridToUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGridToUnstructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGridToUnstructuredGrid': ...

class vtkExtractCells(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    assume_sorted_and_unique_ids:'getset_descriptor'
    batch_size:'getset_descriptor'
    cell_list:'getset_descriptor'
    extract_all_cells:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCellIds(self, ptr:Sequence[int], numValues:int) -> None: ...
    def AddCellList(self, l:'vtkIdList') -> None: ...
    def AddCellRange(self, from_:int, to:int) -> None: ...
    def AssumeSortedAndUniqueIdsOff(self) -> None: ...
    def AssumeSortedAndUniqueIdsOn(self) -> None: ...
    def ExtractAllCellsOff(self) -> None: ...
    def ExtractAllCellsOn(self) -> None: ...
    def GetAssumeSortedAndUniqueIds(self) -> bool: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetExtractAllCells(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassThroughCellIds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractCells': ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractCells': ...
    def SetAssumeSortedAndUniqueIds(self, _arg:bool) -> None: ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetCellIds(self, ptr:Sequence[int], numValues:int) -> None: ...
    def SetCellList(self, l:'vtkIdList') -> None: ...
    def SetExtractAllCells(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPassThroughCellIds(self, _arg:bool) -> None: ...

class vtkExtractCellsAlongPolyLine(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    output_points_precision:'getset_descriptor'
    source_connection:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractCellsAlongPolyLine': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractCellsAlongPolyLine': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSourceConnection(self, input:'vtkAlgorithmOutput') -> None: ...

class vtkExtractEdges(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    use_all_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseAllPoints(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractEdges': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractEdges': ...
    def SetLocator(self, _arg:'vtkIncrementalPointLocator') -> None: ...
    def SetUseAllPoints(self, _arg:bool) -> None: ...
    def UseAllPointsOff(self) -> None: ...
    def UseAllPointsOn(self) -> None: ...

class vtkFeatureEdges(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    boundary_edges:'getset_descriptor'
    coloring:'getset_descriptor'
    feature_angle:'getset_descriptor'
    feature_edges:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    manifold_edges:'getset_descriptor'
    non_manifold_edges:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    pass_lines:'getset_descriptor'
    remove_ghost_interfaces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundaryEdgesOff(self) -> None: ...
    def BoundaryEdgesOn(self) -> None: ...
    def ColoringOff(self) -> None: ...
    def ColoringOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def ExtractAllEdgeTypesOff(self) -> None: ...
    def ExtractAllEdgeTypesOn(self) -> None: ...
    def FeatureEdgesOff(self) -> None: ...
    def FeatureEdgesOn(self) -> None: ...
    def GetBoundaryEdges(self) -> bool: ...
    def GetColoring(self) -> bool: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFeatureEdges(self) -> bool: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetManifoldEdges(self) -> bool: ...
    def GetNonManifoldEdges(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassLines(self) -> bool: ...
    def GetRemoveGhostInterfaces(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ManifoldEdgesOff(self) -> None: ...
    def ManifoldEdgesOn(self) -> None: ...
    def NewInstance(self) -> 'vtkFeatureEdges': ...
    def NonManifoldEdgesOff(self) -> None: ...
    def NonManifoldEdgesOn(self) -> None: ...
    def PassLinesOff(self) -> None: ...
    def PassLinesOn(self) -> None: ...
    def RemoveGhostInterfacesOff(self) -> None: ...
    def RemoveGhostInterfacesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFeatureEdges': ...
    def SetBoundaryEdges(self, _arg:bool) -> None: ...
    def SetColoring(self, _arg:bool) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFeatureEdges(self, _arg:bool) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetManifoldEdges(self, _arg:bool) -> None: ...
    def SetNonManifoldEdges(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPassLines(self, _arg:bool) -> None: ...
    def SetRemoveGhostInterfaces(self, _arg:bool) -> None: ...

class vtkFieldDataToAttributeDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    default_normalize:'getset_descriptor'
    input_field:'getset_descriptor'
    output_attribute_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ConstructArray(da:'vtkDataArray', comp:int, fieldArray:'vtkDataArray', fieldComp:int, min:int, max:int, normalize:int) -> int: ...
    def DefaultNormalizeOff(self) -> None: ...
    def DefaultNormalizeOn(self) -> None: ...
    def GetDefaultNormalize(self) -> int: ...
    @staticmethod
    def GetFieldArray(fd:'vtkFieldData', name:str, comp:int) -> 'vtkDataArray': ...
    def GetInputField(self) -> int: ...
    def GetNormalComponentArrayComponent(self, comp:int) -> int: ...
    def GetNormalComponentArrayName(self, comp:int) -> str: ...
    def GetNormalComponentMaxRange(self, comp:int) -> int: ...
    def GetNormalComponentMinRange(self, comp:int) -> int: ...
    def GetNormalComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputAttributeData(self) -> int: ...
    def GetScalarComponentArrayComponent(self, comp:int) -> int: ...
    def GetScalarComponentArrayName(self, comp:int) -> str: ...
    def GetScalarComponentMaxRange(self, comp:int) -> int: ...
    def GetScalarComponentMinRange(self, comp:int) -> int: ...
    def GetScalarComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetTCoordComponentArrayComponent(self, comp:int) -> int: ...
    def GetTCoordComponentArrayName(self, comp:int) -> str: ...
    def GetTCoordComponentMaxRange(self, comp:int) -> int: ...
    def GetTCoordComponentMinRange(self, comp:int) -> int: ...
    def GetTCoordComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetTensorComponentArrayComponent(self, comp:int) -> int: ...
    def GetTensorComponentArrayName(self, comp:int) -> str: ...
    def GetTensorComponentMaxRange(self, comp:int) -> int: ...
    def GetTensorComponentMinRange(self, comp:int) -> int: ...
    def GetTensorComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetVectorComponentArrayComponent(self, comp:int) -> int: ...
    def GetVectorComponentArrayName(self, comp:int) -> str: ...
    def GetVectorComponentMaxRange(self, comp:int) -> int: ...
    def GetVectorComponentMinRange(self, comp:int) -> int: ...
    def GetVectorComponentNormalizeFlag(self, comp:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFieldDataToAttributeDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFieldDataToAttributeDataFilter': ...
    def SetDefaultNormalize(self, _arg:int) -> None: ...
    def SetInputField(self, _arg:int) -> None: ...
    def SetInputFieldToCellDataField(self) -> None: ...
    def SetInputFieldToDataObjectField(self) -> None: ...
    def SetInputFieldToPointDataField(self) -> None: ...
    @overload
    def SetNormalComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetNormalComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    def SetOutputAttributeData(self, _arg:int) -> None: ...
    def SetOutputAttributeDataToCellData(self) -> None: ...
    def SetOutputAttributeDataToPointData(self) -> None: ...
    @overload
    def SetScalarComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetScalarComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetTCoordComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetTCoordComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetTensorComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetTensorComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetVectorComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetVectorComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @staticmethod
    def UpdateComponentRange(da:'vtkDataArray', compRange:MutableSequence[int]) -> int: ...

class vtkFieldDataToDataSetAttribute(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    output_field_type:'getset_descriptor'
    process_all_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddFieldDataArray(self, name:str) -> None: ...
    def ClearFieldDataArrays(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputFieldType(self) -> int: ...
    def GetProcessAllArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFieldDataToDataSetAttribute': ...
    def ProcessAllArraysOff(self) -> None: ...
    def ProcessAllArraysOn(self) -> None: ...
    def RemoveFieldDataArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFieldDataToDataSetAttribute': ...
    def SetOutputFieldType(self, _arg:int) -> None: ...
    def SetProcessAllArrays(self, _arg:bool) -> None: ...

class vtkFlyingEdges2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlyingEdges2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlyingEdges2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkFlyingEdges3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlyingEdges3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlyingEdges3D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkFlyingEdgesPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_normals:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    m_time:'getset_descriptor'
    plane:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlyingEdgesPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlyingEdgesPlaneCutter': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkGenerateIds(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    cell_ids:'getset_descriptor'
    cell_ids_array_name:'getset_descriptor'
    field_data:'getset_descriptor'
    point_ids:'getset_descriptor'
    point_ids_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellIdsOff(self) -> None: ...
    def CellIdsOn(self) -> None: ...
    def FieldDataOff(self) -> None: ...
    def FieldDataOn(self) -> None: ...
    def GetCellIds(self) -> bool: ...
    def GetCellIdsArrayName(self) -> str: ...
    def GetFieldData(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIds(self) -> bool: ...
    def GetPointIdsArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenerateIds': ...
    def PointIdsOff(self) -> None: ...
    def PointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenerateIds': ...
    def SetCellIds(self, _arg:bool) -> None: ...
    def SetCellIdsArrayName(self, _arg:str) -> None: ...
    def SetFieldData(self, _arg:bool) -> None: ...
    def SetPointIds(self, _arg:bool) -> None: ...
    def SetPointIdsArrayName(self, _arg:str) -> None: ...

class vtkGenerateRegionIds(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    max_angle:'getset_descriptor'
    region_ids_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMaxAngle(self) -> float: ...
    def GetMaxAngleMaxValue(self) -> float: ...
    def GetMaxAngleMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRegionIdsArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenerateRegionIds': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenerateRegionIds': ...
    def SetMaxAngle(self, _arg:float) -> None: ...
    def SetRegionIdsArrayName(self, _arg:str) -> None: ...

class vtkGlyph3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    clamping:'getset_descriptor'
    color_mode:'getset_descriptor'
    fill_cell_data:'getset_descriptor'
    followed_camera_position:'getset_descriptor'
    followed_camera_view_up:'getset_descriptor'
    generate_point_ids:'getset_descriptor'
    index_mode:'getset_descriptor'
    m_time:'getset_descriptor'
    orient:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    point_ids_name:'getset_descriptor'
    range:'getset_descriptor'
    scale_factor:'getset_descriptor'
    scale_mode:'getset_descriptor'
    scaling:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    source_transform:'getset_descriptor'
    vector_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def FillCellDataOff(self) -> None: ...
    def FillCellDataOn(self) -> None: ...
    def GeneratePointIdsOff(self) -> None: ...
    def GeneratePointIdsOn(self) -> None: ...
    def GetClamping(self) -> int: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetFillCellData(self) -> int: ...
    def GetFollowedCameraPosition(self) -> Tuple[float, float, float]: ...
    def GetFollowedCameraViewUp(self) -> Tuple[float, float, float]: ...
    def GetGeneratePointIds(self) -> int: ...
    def GetIndexMode(self) -> int: ...
    def GetIndexModeAsString(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrient(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPointIdsName(self) -> str: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleMode(self) -> int: ...
    def GetScaleModeAsString(self) -> str: ...
    def GetScaling(self) -> int: ...
    def GetSource(self, id:int=0) -> 'vtkPolyData': ...
    def GetSourceTransform(self) -> 'vtkTransform': ...
    def GetVectorMode(self) -> int: ...
    def GetVectorModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsPointVisible(self, __a:'vtkDataSet', __b:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGlyph3D': ...
    def OrientOff(self) -> None: ...
    def OrientOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGlyph3D': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetClamping(self, _arg:int) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToColorByScalar(self) -> None: ...
    def SetColorModeToColorByScale(self) -> None: ...
    def SetColorModeToColorByVector(self) -> None: ...
    def SetFillCellData(self, _arg:int) -> None: ...
    def SetFollowedCameraPosition(self, data:Sequence[float]) -> None: ...
    def SetFollowedCameraViewUp(self, data:Sequence[float]) -> None: ...
    def SetGeneratePointIds(self, _arg:int) -> None: ...
    def SetIndexMode(self, _arg:int) -> None: ...
    def SetIndexModeToOff(self) -> None: ...
    def SetIndexModeToScalar(self) -> None: ...
    def SetIndexModeToVector(self) -> None: ...
    def SetOrient(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPointIdsName(self, _arg:str) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:Sequence[float]) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaleMode(self, _arg:int) -> None: ...
    def SetScaleModeToDataScalingOff(self) -> None: ...
    def SetScaleModeToScaleByScalar(self) -> None: ...
    def SetScaleModeToScaleByVector(self) -> None: ...
    def SetScaleModeToScaleByVectorComponents(self) -> None: ...
    def SetScaling(self, _arg:int) -> None: ...
    @overload
    def SetSourceConnection(self, id:int, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceData(self, pd:'vtkPolyData') -> None: ...
    @overload
    def SetSourceData(self, id:int, pd:'vtkPolyData') -> None: ...
    def SetSourceTransform(self, __a:'vtkTransform') -> None: ...
    def SetVectorMode(self, _arg:int) -> None: ...
    def SetVectorModeToFollowCameraDirection(self) -> None: ...
    def SetVectorModeToUseNormal(self) -> None: ...
    def SetVectorModeToUseVector(self) -> None: ...
    def SetVectorModeToVectorRotationOff(self) -> None: ...

class vtkGlyph2D(vtkGlyph3D):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGlyph2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGlyph2D': ...

class vtkGridSynchronizedTemplates3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    input_memory_limit:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGridSynchronizedTemplates3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridSynchronizedTemplates3D': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetInputMemoryLimit(self, limit:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkHedgeHog(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    output_points_precision:'getset_descriptor'
    scale_factor:'getset_descriptor'
    vector_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetVectorMode(self) -> int: ...
    def GetVectorModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHedgeHog': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHedgeHog': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetVectorMode(self, _arg:int) -> None: ...
    def SetVectorModeToUseNormal(self) -> None: ...
    def SetVectorModeToUseVector(self) -> None: ...

class vtkHull(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    number_of_planes:'getset_descriptor'
    planes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCubeEdgePlanes(self) -> None: ...
    def AddCubeFacePlanes(self) -> None: ...
    def AddCubeVertexPlanes(self) -> None: ...
    @overload
    def AddPlane(self, A:float, B:float, C:float) -> int: ...
    @overload
    def AddPlane(self, plane:MutableSequence[float]) -> int: ...
    @overload
    def AddPlane(self, A:float, B:float, C:float, D:float) -> int: ...
    @overload
    def AddPlane(self, plane:MutableSequence[float], D:float) -> int: ...
    def AddRecursiveSpherePlanes(self, level:int) -> None: ...
    @overload
    def GenerateHull(self, pd:'vtkPolyData', bounds:MutableSequence[float]) -> None: ...
    @overload
    def GenerateHull(self, pd:'vtkPolyData', xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlanes(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHull': ...
    def RemoveAllPlanes(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHull': ...
    @overload
    def SetPlane(self, i:int, A:float, B:float, C:float) -> None: ...
    @overload
    def SetPlane(self, i:int, plane:MutableSequence[float]) -> None: ...
    @overload
    def SetPlane(self, i:int, A:float, B:float, C:float, D:float) -> None: ...
    @overload
    def SetPlane(self, i:int, plane:MutableSequence[float], D:float) -> None: ...
    def SetPlanes(self, planes:'vtkPlanes') -> None: ...

class vtkHyperTreeGridProbeFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    compute_tolerance:'getset_descriptor'
    locator:'getset_descriptor'
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    use_implicit_arrays:'getset_descriptor'
    valid_point_mask_array_name:'getset_descriptor'
    valid_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetComputeTolerance(self) -> bool: ...
    def GetLocator(self) -> 'vtkHyperTreeGridLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> bool: ...
    def GetPassFieldArrays(self) -> bool: ...
    def GetPassPointArrays(self) -> bool: ...
    def GetSource(self) -> 'vtkHyperTreeGrid': ...
    def GetTolerance(self) -> float: ...
    def GetUseImplicitArrays(self) -> bool: ...
    def GetValidPointMaskArrayName(self) -> str: ...
    def GetValidPoints(self) -> 'vtkIdTypeArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridProbeFilter': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridProbeFilter': ...
    def SetComputeTolerance(self, _arg:bool) -> None: ...
    def SetLocator(self, __a:'vtkHyperTreeGridLocator') -> None: ...
    def SetPassCellArrays(self, _arg:bool) -> None: ...
    def SetPassFieldArrays(self, _arg:bool) -> None: ...
    def SetPassPointArrays(self, _arg:bool) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkHyperTreeGrid') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetUseImplicitArrays(self, _arg:bool) -> None: ...
    def SetValidPointMaskArrayName(self, _arg:str) -> None: ...
    def UseImplicitArraysOff(self) -> None: ...
    def UseImplicitArraysOn(self) -> None: ...

class vtkIdFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    cell_ids:'getset_descriptor'
    cell_ids_array_name:'getset_descriptor'
    field_data:'getset_descriptor'
    point_ids:'getset_descriptor'
    point_ids_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellIdsOff(self) -> None: ...
    def CellIdsOn(self) -> None: ...
    def FieldDataOff(self) -> None: ...
    def FieldDataOn(self) -> None: ...
    def GetCellIds(self) -> int: ...
    def GetCellIdsArrayName(self) -> str: ...
    def GetFieldData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIds(self) -> int: ...
    def GetPointIdsArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIdFilter': ...
    def PointIdsOff(self) -> None: ...
    def PointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIdFilter': ...
    def SetCellIds(self, _arg:int) -> None: ...
    def SetCellIdsArrayName(self, _arg:str) -> None: ...
    def SetFieldData(self, _arg:int) -> None: ...
    def SetPointIds(self, _arg:int) -> None: ...
    def SetPointIdsArrayName(self, _arg:str) -> None: ...

class vtkImageAppend(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    append_axis:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    preserve_extents:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAppendAxis(self) -> int: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputs(self) -> int: ...
    def GetPreserveExtents(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageAppend': ...
    def PreserveExtentsOff(self) -> None: ...
    def PreserveExtentsOn(self) -> None: ...
    def ReplaceNthInputConnection(self, idx:int, input:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageAppend': ...
    def SetAppendAxis(self, _arg:int) -> None: ...
    @overload
    def SetInputData(self, idx:int, input:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, input:'vtkDataObject') -> None: ...
    def SetPreserveExtents(self, _arg:int) -> None: ...

class vtkImageDataToExplicitStructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkExplicitStructuredGridAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataToExplicitStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataToExplicitStructuredGrid': ...

class vtkImplicitPolyDataDistance(vtkmodules.vtkCommonDataModel.vtkImplicitFunction):
    input:'getset_descriptor'
    m_time:'getset_descriptor'
    no_closest_point:'getset_descriptor'
    no_gradient:'getset_descriptor'
    no_value:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateFunctionAndGetClosestPoint(self, x:MutableSequence[float], closestPoint:MutableSequence[float]) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNoClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetNoGradient(self) -> Tuple[float, float, float]: ...
    def GetNoValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitPolyDataDistance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitPolyDataDistance': ...
    def SetInput(self, input:'vtkPolyData') -> None: ...
    @overload
    def SetNoClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNoClosestPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetNoGradient(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNoGradient(self, _arg:Sequence[float]) -> None: ...
    def SetNoValue(self, _arg:float) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkImplicitProjectOnPlaneDistance(vtkmodules.vtkCommonDataModel.vtkImplicitFunction):
    class NormType(int):
        L0:'NormType'
        L2:'NormType'
    input:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    norm:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetMTime(self) -> int: ...
    def GetNorm(self) -> 'NormType': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitProjectOnPlaneDistance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitProjectOnPlaneDistance': ...
    def SetInput(self, input:'vtkPolyData') -> None: ...
    def SetLocator(self, _arg:'vtkAbstractCellLocator') -> None: ...
    @overload
    def SetNorm(self, n:'NormType') -> None: ...
    @overload
    def SetNorm(self, n:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkMarchingCubes(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarchingCubes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarchingCubes': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkMarchingSquares(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    image_range:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetImageRange(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarchingSquares': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarchingSquares': ...
    @overload
    def SetImageRange(self, data:Sequence[int]) -> None: ...
    @overload
    def SetImageRange(self, imin:int, imax:int, jmin:int, jmax:int, kmin:int, kmax:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkMaskFields(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldLocation(int): ...
    CELL_DATA:'FieldLocation'
    OBJECT_DATA:'FieldLocation'
    POINT_DATA:'FieldLocation'
    def __init__(self, **properties:Any) -> None: ...
    def CopyAllOff(self) -> None: ...
    def CopyAllOn(self) -> None: ...
    @overload
    def CopyAttributeOff(self, attributeLocation:int, attributeType:int) -> None: ...
    @overload
    def CopyAttributeOff(self, attributeLoc:str, attributeType:str) -> None: ...
    @overload
    def CopyAttributeOn(self, attributeLocation:int, attributeType:int) -> None: ...
    @overload
    def CopyAttributeOn(self, attributeLoc:str, attributeType:str) -> None: ...
    def CopyAttributesOff(self) -> None: ...
    def CopyAttributesOn(self) -> None: ...
    @overload
    def CopyFieldOff(self, fieldLocation:int, name:str) -> None: ...
    @overload
    def CopyFieldOff(self, fieldLoc:str, name:str) -> None: ...
    @overload
    def CopyFieldOn(self, fieldLocation:int, name:str) -> None: ...
    @overload
    def CopyFieldOn(self, fieldLoc:str, name:str) -> None: ...
    def CopyFieldsOff(self) -> None: ...
    def CopyFieldsOn(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskFields': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskFields': ...

class vtkMaskPoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class DistributionType(int): ...
    RANDOMIZED_ID_STRIDES:'DistributionType'
    RANDOM_SAMPLING:'DistributionType'
    SPATIALLY_STRATIFIED:'DistributionType'
    UNIFORM_SPATIAL_BOUNDS:'DistributionType'
    UNIFORM_SPATIAL_SURFACE:'DistributionType'
    UNIFORM_SPATIAL_VOLUME:'DistributionType'
    generate_vertices:'getset_descriptor'
    maximum_number_of_points:'getset_descriptor'
    offset:'getset_descriptor'
    on_ratio:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    proportional_maximum_number_of_points:'getset_descriptor'
    random_mode:'getset_descriptor'
    random_mode_type:'getset_descriptor'
    random_seed:'getset_descriptor'
    single_vertex_per_cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateVerticesOff(self) -> None: ...
    def GenerateVerticesOn(self) -> None: ...
    def GetGenerateVertices(self) -> bool: ...
    def GetMaximumNumberOfPoints(self) -> int: ...
    def GetMaximumNumberOfPointsMaxValue(self) -> int: ...
    def GetMaximumNumberOfPointsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetProportionalMaximumNumberOfPoints(self) -> bool: ...
    def GetRandomMode(self) -> bool: ...
    def GetRandomModeType(self) -> int: ...
    def GetRandomModeTypeMaxValue(self) -> int: ...
    def GetRandomModeTypeMinValue(self) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetSingleVertexPerCell(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskPoints': ...
    def ProportionalMaximumNumberOfPointsOff(self) -> None: ...
    def ProportionalMaximumNumberOfPointsOn(self) -> None: ...
    def RandomModeOff(self) -> None: ...
    def RandomModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskPoints': ...
    def SetGenerateVertices(self, _arg:bool) -> None: ...
    def SetMaximumNumberOfPoints(self, _arg:int) -> None: ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetProportionalMaximumNumberOfPoints(self, _arg:bool) -> None: ...
    def SetRandomMode(self, _arg:bool) -> None: ...
    def SetRandomModeType(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetSingleVertexPerCell(self, _arg:bool) -> None: ...
    def SingleVertexPerCellOff(self) -> None: ...
    def SingleVertexPerCellOn(self) -> None: ...

class vtkMaskPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    offset:'getset_descriptor'
    on_ratio:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskPolyData': ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...

class vtkMassProperties(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    kx:'getset_descriptor'
    ky:'getset_descriptor'
    kz:'getset_descriptor'
    max_cell_area:'getset_descriptor'
    min_cell_area:'getset_descriptor'
    normalized_shape_index:'getset_descriptor'
    surface_area:'getset_descriptor'
    volume:'getset_descriptor'
    volume_projected:'getset_descriptor'
    volume_x:'getset_descriptor'
    volume_y:'getset_descriptor'
    volume_z:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetKx(self) -> float: ...
    def GetKy(self) -> float: ...
    def GetKz(self) -> float: ...
    def GetMaxCellArea(self) -> float: ...
    def GetMinCellArea(self) -> float: ...
    def GetNormalizedShapeIndex(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSurfaceArea(self) -> float: ...
    def GetVolume(self) -> float: ...
    def GetVolumeProjected(self) -> float: ...
    def GetVolumeX(self) -> float: ...
    def GetVolumeY(self) -> float: ...
    def GetVolumeZ(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMassProperties': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMassProperties': ...

class vtkMergeDataObjectFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    data_object:'getset_descriptor'
    data_object_input_data:'getset_descriptor'
    output_field:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDataObject(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputField(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeDataObjectFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeDataObjectFilter': ...
    def SetDataObjectInputData(self, object:'vtkDataObject') -> None: ...
    def SetOutputField(self, _arg:int) -> None: ...
    def SetOutputFieldToCellDataField(self) -> None: ...
    def SetOutputFieldToDataObjectField(self) -> None: ...
    def SetOutputFieldToPointDataField(self) -> None: ...

class vtkMergeFields(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldLocations(int): ...
    CELL_DATA:'FieldLocations'
    DATA_OBJECT:'FieldLocations'
    POINT_DATA:'FieldLocations'
    number_of_components:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Merge(self, component:int, arrayName:str, sourceComp:int) -> None: ...
    def NewInstance(self) -> 'vtkMergeFields': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeFields': ...
    def SetNumberOfComponents(self, _arg:int) -> None: ...
    @overload
    def SetOutputField(self, name:str, fieldLoc:int) -> None: ...
    @overload
    def SetOutputField(self, name:str, fieldLoc:str) -> None: ...

class vtkMergeFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    geometry:'getset_descriptor'
    geometry_connection:'getset_descriptor'
    geometry_input_data:'getset_descriptor'
    normals:'getset_descriptor'
    normals_connection:'getset_descriptor'
    normals_data:'getset_descriptor'
    scalars:'getset_descriptor'
    scalars_connection:'getset_descriptor'
    scalars_data:'getset_descriptor'
    t_coords:'getset_descriptor'
    t_coords_connection:'getset_descriptor'
    t_coords_data:'getset_descriptor'
    tensors:'getset_descriptor'
    tensors_connection:'getset_descriptor'
    tensors_data:'getset_descriptor'
    vectors:'getset_descriptor'
    vectors_connection:'getset_descriptor'
    vectors_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddField(self, name:str, input:'vtkDataSet') -> None: ...
    def GetGeometry(self) -> 'vtkDataSet': ...
    def GetNormals(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalars(self) -> 'vtkDataSet': ...
    def GetTCoords(self) -> 'vtkDataSet': ...
    def GetTensors(self) -> 'vtkDataSet': ...
    def GetVectors(self) -> 'vtkDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeFilter': ...
    def SetGeometryConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetGeometryInputData(self, input:'vtkDataSet') -> None: ...
    def SetNormalsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetNormalsData(self, __a:'vtkDataSet') -> None: ...
    def SetScalarsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetScalarsData(self, __a:'vtkDataSet') -> None: ...
    def SetTCoordsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetTCoordsData(self, __a:'vtkDataSet') -> None: ...
    def SetTensorsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetTensorsData(self, __a:'vtkDataSet') -> None: ...
    def SetVectorsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetVectorsData(self, __a:'vtkDataSet') -> None: ...

class vtkMoleculeAppend(vtkmodules.vtkCommonExecutionModel.vtkMoleculeAlgorithm):
    input:'getset_descriptor'
    merge_coincident_atoms:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetMergeCoincidentAtoms(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergeCoincidentAtomsOff(self) -> None: ...
    def MergeCoincidentAtomsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMoleculeAppend': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeAppend': ...
    def SetMergeCoincidentAtoms(self, _arg:bool) -> None: ...

class vtkMultiObjectMassProperties(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    all_valid:'getset_descriptor'
    number_of_objects:'getset_descriptor'
    object_ids_array_name:'getset_descriptor'
    skip_validity_check:'getset_descriptor'
    total_area:'getset_descriptor'
    total_volume:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAllValid(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfObjects(self) -> int: ...
    def GetObjectIdsArrayName(self) -> str: ...
    def GetSkipValidityCheck(self) -> int: ...
    def GetTotalArea(self) -> float: ...
    def GetTotalVolume(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiObjectMassProperties': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiObjectMassProperties': ...
    def SetObjectIdsArrayName(self, arg:str) -> None: ...
    def SetSkipValidityCheck(self, _arg:int) -> None: ...
    def SkipValidityCheckOff(self) -> None: ...
    def SkipValidityCheckOn(self) -> None: ...

class vtkOrientPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    auto_orient_normals:'getset_descriptor'
    consistency:'getset_descriptor'
    flip_normals:'getset_descriptor'
    non_manifold_traversal:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoOrientNormalsOff(self) -> None: ...
    def AutoOrientNormalsOn(self) -> None: ...
    def ConsistencyOff(self) -> None: ...
    def ConsistencyOn(self) -> None: ...
    def FlipNormalsOff(self) -> None: ...
    def FlipNormalsOn(self) -> None: ...
    def GetAutoOrientNormals(self) -> bool: ...
    def GetConsistency(self) -> bool: ...
    def GetFlipNormals(self) -> bool: ...
    def GetNonManifoldTraversal(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrientPolyData': ...
    def NonManifoldTraversalOff(self) -> None: ...
    def NonManifoldTraversalOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientPolyData': ...
    def SetAutoOrientNormals(self, _arg:bool) -> None: ...
    def SetConsistency(self, _arg:bool) -> None: ...
    def SetFlipNormals(self, _arg:bool) -> None: ...
    def SetNonManifoldTraversal(self, _arg:bool) -> None: ...

class vtkPackLabels(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class DefaultScalarType(int): ...
    class SortBy(int): ...
    SORT_BY_LABEL_COUNT:'SortBy'
    SORT_BY_LABEL_VALUE:'SortBy'
    VTK_DEFAULT_TYPE:'DefaultScalarType'
    background_value:'getset_descriptor'
    labels:'getset_descriptor'
    labels_count:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    pass_cell_data:'getset_descriptor'
    pass_field_data:'getset_descriptor'
    pass_point_data:'getset_descriptor'
    sort_by:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBackgroundValue(self) -> int: ...
    def GetLabels(self) -> 'vtkDataArray': ...
    def GetLabelsCount(self) -> 'vtkIdTypeArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def GetPassCellData(self) -> bool: ...
    def GetPassFieldData(self) -> bool: ...
    def GetPassPointData(self) -> bool: ...
    def GetSortBy(self) -> int: ...
    def GetSortByMaxValue(self) -> int: ...
    def GetSortByMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPackLabels': ...
    def PassCellDataOff(self) -> None: ...
    def PassCellDataOn(self) -> None: ...
    def PassFieldDataOff(self) -> None: ...
    def PassFieldDataOn(self) -> None: ...
    def PassPointDataOff(self) -> None: ...
    def PassPointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPackLabels': ...
    def SetBackgroundValue(self, _arg:int) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToDefault(self) -> None: ...
    def SetOutputScalarTypeToUnsignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedInt(self) -> None: ...
    def SetOutputScalarTypeToUnsignedLong(self) -> None: ...
    def SetOutputScalarTypeToUnsignedShort(self) -> None: ...
    def SetPassCellData(self, _arg:bool) -> None: ...
    def SetPassFieldData(self, _arg:bool) -> None: ...
    def SetPassPointData(self, _arg:bool) -> None: ...
    def SetSortBy(self, _arg:int) -> None: ...
    def SortByLabelCount(self) -> None: ...
    def SortByLabelValue(self) -> None: ...

class vtkPassThrough(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    allow_null_input:'getset_descriptor'
    deep_copy_input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllowNullInputOff(self) -> None: ...
    def AllowNullInputOn(self) -> None: ...
    def DeepCopyInputOff(self) -> None: ...
    def DeepCopyInputOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetAllowNullInput(self) -> bool: ...
    def GetDeepCopyInput(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPassThrough': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPassThrough': ...
    def SetAllowNullInput(self, _arg:bool) -> None: ...
    def SetDeepCopyInput(self, _arg:int) -> None: ...

class vtkPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    build_hierarchy:'getset_descriptor'
    build_tree:'getset_descriptor'
    compute_normals:'getset_descriptor'
    generate_polygons:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    m_time:'getset_descriptor'
    merge_points:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    plane:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildHierarchyOff(self) -> None: ...
    def BuildHierarchyOn(self) -> None: ...
    def BuildTreeOff(self) -> None: ...
    def BuildTreeOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GeneratePolygonsOff(self) -> None: ...
    def GeneratePolygonsOn(self) -> None: ...
    def GetBuildHierarchy(self) -> bool: ...
    def GetBuildTree(self) -> bool: ...
    def GetComputeNormals(self) -> bool: ...
    def GetGeneratePolygons(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlaneCutter': ...
    def SetBuildHierarchy(self, _arg:bool) -> None: ...
    def SetBuildTree(self, _arg:bool) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetGeneratePolygons(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkPointDataToCellData(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    categorical_data:'getset_descriptor'
    pass_point_data:'getset_descriptor'
    process_all_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPointDataArray(self, name:str) -> None: ...
    def CategoricalDataOff(self) -> None: ...
    def CategoricalDataOn(self) -> None: ...
    def ClearPointDataArrays(self) -> None: ...
    def GetCategoricalData(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassPointData(self) -> bool: ...
    def GetProcessAllArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointDataToCellData': ...
    def PassPointDataOff(self) -> None: ...
    def PassPointDataOn(self) -> None: ...
    def ProcessAllArraysOff(self) -> None: ...
    def ProcessAllArraysOn(self) -> None: ...
    def RemovePointDataArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointDataToCellData': ...
    def SetCategoricalData(self, _arg:bool) -> None: ...
    def SetPassPointData(self, _arg:bool) -> None: ...
    def SetProcessAllArrays(self, _arg:bool) -> None: ...

class vtkPolyDataConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    closest_point:'getset_descriptor'
    color_regions:'getset_descriptor'
    extraction_mode:'getset_descriptor'
    full_scalar_connectivity:'getset_descriptor'
    mark_visited_point_ids:'getset_descriptor'
    number_of_extracted_regions:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    region_sizes:'getset_descriptor'
    scalar_connectivity:'getset_descriptor'
    scalar_range:'getset_descriptor'
    visited_point_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def ColorRegionsOff(self) -> None: ...
    def ColorRegionsOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def FullScalarConnectivityOff(self) -> None: ...
    def FullScalarConnectivityOn(self) -> None: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorRegions(self) -> int: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetFullScalarConnectivity(self) -> int: ...
    def GetMarkVisitedPointIds(self) -> int: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRegionSizes(self) -> 'vtkIdTypeArray': ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetVisitedPointIds(self) -> 'vtkIdList': ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkVisitedPointIdsOff(self) -> None: ...
    def MarkVisitedPointIdsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPolyDataConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataConnectivityFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorRegions(self, _arg:int) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToCellSeededRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetFullScalarConnectivity(self, _arg:int) -> None: ...
    def SetMarkVisitedPointIds(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkPolyDataEdgeConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class RegionGrowingType(int): ...
    LargeRegions:'RegionGrowingType'
    RegionGrowingOff:'RegionGrowingType'
    SmallRegions:'RegionGrowingType'
    barrier_edge_length:'getset_descriptor'
    barrier_edges:'getset_descriptor'
    cell_region_areas:'getset_descriptor'
    closest_point:'getset_descriptor'
    color_regions:'getset_descriptor'
    extraction_mode:'getset_descriptor'
    large_region_threshold:'getset_descriptor'
    number_of_extracted_regions:'getset_descriptor'
    number_of_specified_regions:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    region_growing:'getset_descriptor'
    region_sizes:'getset_descriptor'
    scalar_connectivity:'getset_descriptor'
    scalar_range:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    total_area:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def BarrierEdgesOff(self) -> None: ...
    def BarrierEdgesOn(self) -> None: ...
    def CellRegionAreasOff(self) -> None: ...
    def CellRegionAreasOn(self) -> None: ...
    def ColorRegionsOff(self) -> None: ...
    def ColorRegionsOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def GetBarrierEdgeLength(self) -> Tuple[float, float]: ...
    def GetBarrierEdges(self) -> int: ...
    def GetCellRegionAreas(self) -> int: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorRegions(self) -> int: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetLargeRegionThreshold(self) -> float: ...
    def GetLargeRegionThresholdMaxValue(self) -> float: ...
    def GetLargeRegionThresholdMinValue(self) -> float: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSpecifiedRegions(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRegionGrowing(self) -> int: ...
    def GetRegionGrowingMaxValue(self) -> int: ...
    def GetRegionGrowingMinValue(self) -> int: ...
    def GetRegionSizes(self) -> 'vtkIdTypeArray': ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def GetTotalArea(self) -> float: ...
    def GrowLargeRegionsOff(self) -> None: ...
    def GrowLargeRegionsOn(self) -> None: ...
    def GrowSmallRegionsOff(self) -> None: ...
    def GrowSmallRegionsOn(self) -> None: ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataEdgeConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataEdgeConnectivityFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetBarrierEdgeLength(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetBarrierEdgeLength(self, _arg:Sequence[float]) -> None: ...
    def SetBarrierEdges(self, _arg:int) -> None: ...
    def SetCellRegionAreas(self, _arg:int) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorRegions(self, _arg:int) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToCellSeededRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargeRegions(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetLargeRegionThreshold(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRegionGrowing(self, _arg:int) -> None: ...
    def SetRegionGrowingOff(self) -> None: ...
    def SetRegionGrowingToLargeRegions(self) -> None: ...
    def SetRegionGrowingToSmallRegions(self) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, __a:'vtkPolyData') -> None: ...

class vtkPolyDataNormals(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    auto_orient_normals:'getset_descriptor'
    compute_cell_normals:'getset_descriptor'
    compute_point_normals:'getset_descriptor'
    consistency:'getset_descriptor'
    feature_angle:'getset_descriptor'
    flip_normals:'getset_descriptor'
    non_manifold_traversal:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    splitting:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoOrientNormalsOff(self) -> None: ...
    def AutoOrientNormalsOn(self) -> None: ...
    def ComputeCellNormalsOff(self) -> None: ...
    def ComputeCellNormalsOn(self) -> None: ...
    def ComputePointNormalsOff(self) -> None: ...
    def ComputePointNormalsOn(self) -> None: ...
    def ConsistencyOff(self) -> None: ...
    def ConsistencyOn(self) -> None: ...
    def FlipNormalsOff(self) -> None: ...
    def FlipNormalsOn(self) -> None: ...
    def GetAutoOrientNormals(self) -> int: ...
    @staticmethod
    def GetCellNormals(data:'vtkPolyData') -> 'vtkFloatArray': ...
    def GetComputeCellNormals(self) -> int: ...
    def GetComputePointNormals(self) -> int: ...
    def GetConsistency(self) -> int: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFlipNormals(self) -> int: ...
    def GetNonManifoldTraversal(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    @staticmethod
    def GetPointNormals(data:'vtkPolyData', cellNormals:'vtkFloatArray', flipDirection:float=1.0) -> 'vtkFloatArray': ...
    def GetSplitting(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataNormals': ...
    def NonManifoldTraversalOff(self) -> None: ...
    def NonManifoldTraversalOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataNormals': ...
    def SetAutoOrientNormals(self, _arg:int) -> None: ...
    def SetComputeCellNormals(self, _arg:int) -> None: ...
    def SetComputePointNormals(self, _arg:int) -> None: ...
    def SetConsistency(self, _arg:int) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFlipNormals(self, _arg:int) -> None: ...
    def SetNonManifoldTraversal(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSplitting(self, _arg:int) -> None: ...
    def SplittingOff(self) -> None: ...
    def SplittingOn(self) -> None: ...

class vtkPolyDataPlaneClipper(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    batch_size:'getset_descriptor'
    cap:'getset_descriptor'
    capping:'getset_descriptor'
    clipping_loops:'getset_descriptor'
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    pass_cap_point_data:'getset_descriptor'
    plane:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def ClippingLoopsOff(self) -> None: ...
    def ClippingLoopsOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetCap(self) -> 'vtkPolyData': ...
    def GetCapping(self) -> bool: ...
    def GetClippingLoops(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassCapPointData(self) -> bool: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataPlaneClipper': ...
    def PassCapPointDataOff(self) -> None: ...
    def PassCapPointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataPlaneClipper': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetCapping(self, _arg:bool) -> None: ...
    def SetClippingLoops(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPassCapPointData(self, _arg:bool) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkPolyDataPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    batch_size:'getset_descriptor'
    compute_normals:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    plane:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetComputeNormals(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataPlaneCutter': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkPolyDataTangents(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_cell_tangents:'getset_descriptor'
    compute_point_tangents:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeCellTangentsOff(self) -> None: ...
    def ComputeCellTangentsOn(self) -> None: ...
    def ComputePointTangentsOff(self) -> None: ...
    def ComputePointTangentsOn(self) -> None: ...
    def GetComputeCellTangents(self) -> bool: ...
    def GetComputePointTangents(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataTangents': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataTangents': ...
    def SetComputeCellTangents(self, _arg:bool) -> None: ...
    def SetComputePointTangents(self, _arg:bool) -> None: ...

class vtkPolyDataToUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanBeProcessedFast(polyData:'vtkPolyData') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataToUnstructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataToUnstructuredGrid': ...

class vtkQuadricClustering(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    auto_adjust_number_of_divisions:'getset_descriptor'
    copy_cell_data:'getset_descriptor'
    division_origin:'getset_descriptor'
    division_spacing:'getset_descriptor'
    feature_edges:'getset_descriptor'
    feature_points_angle:'getset_descriptor'
    number_of_divisions:'getset_descriptor'
    number_of_x_divisions:'getset_descriptor'
    number_of_y_divisions:'getset_descriptor'
    number_of_z_divisions:'getset_descriptor'
    prevent_duplicate_cells:'getset_descriptor'
    use_feature_edges:'getset_descriptor'
    use_feature_points:'getset_descriptor'
    use_input_points:'getset_descriptor'
    use_internal_triangles:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Append(self, piece:'vtkPolyData') -> None: ...
    def AutoAdjustNumberOfDivisionsOff(self) -> None: ...
    def AutoAdjustNumberOfDivisionsOn(self) -> None: ...
    def CopyCellDataOff(self) -> None: ...
    def CopyCellDataOn(self) -> None: ...
    def EndAppend(self) -> None: ...
    def GetAutoAdjustNumberOfDivisions(self) -> int: ...
    def GetCopyCellData(self) -> int: ...
    def GetDivisionOrigin(self) -> Tuple[float, float, float]: ...
    def GetDivisionSpacing(self) -> Tuple[float, float, float]: ...
    def GetFeatureEdges(self) -> 'vtkFeatureEdges': ...
    def GetFeaturePointsAngle(self) -> float: ...
    def GetFeaturePointsAngleMaxValue(self) -> float: ...
    def GetFeaturePointsAngleMinValue(self) -> float: ...
    @overload
    def GetNumberOfDivisions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfXDivisions(self) -> int: ...
    def GetNumberOfYDivisions(self) -> int: ...
    def GetNumberOfZDivisions(self) -> int: ...
    def GetPreventDuplicateCells(self) -> int: ...
    def GetUseFeatureEdges(self) -> int: ...
    def GetUseFeaturePoints(self) -> int: ...
    def GetUseInputPoints(self) -> int: ...
    def GetUseInternalTriangles(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadricClustering': ...
    def PreventDuplicateCellsOff(self) -> None: ...
    def PreventDuplicateCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadricClustering': ...
    def SetAutoAdjustNumberOfDivisions(self, _arg:int) -> None: ...
    def SetCopyCellData(self, _arg:int) -> None: ...
    @overload
    def SetDivisionOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionOrigin(self, o:MutableSequence[float]) -> None: ...
    @overload
    def SetDivisionSpacing(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionSpacing(self, s:MutableSequence[float]) -> None: ...
    def SetFeaturePointsAngle(self, _arg:float) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div0:int, div1:int, div2:int) -> None: ...
    def SetNumberOfXDivisions(self, num:int) -> None: ...
    def SetNumberOfYDivisions(self, num:int) -> None: ...
    def SetNumberOfZDivisions(self, num:int) -> None: ...
    def SetPreventDuplicateCells(self, _arg:int) -> None: ...
    def SetUseFeatureEdges(self, _arg:int) -> None: ...
    def SetUseFeaturePoints(self, _arg:int) -> None: ...
    def SetUseInputPoints(self, _arg:int) -> None: ...
    def SetUseInternalTriangles(self, _arg:int) -> None: ...
    @overload
    def StartAppend(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def StartAppend(self, x0:float, x1:float, y0:float, y1:float, z0:float, z1:float) -> None: ...
    def UseFeatureEdgesOff(self) -> None: ...
    def UseFeatureEdgesOn(self) -> None: ...
    def UseFeaturePointsOff(self) -> None: ...
    def UseFeaturePointsOn(self) -> None: ...
    def UseInputPointsOff(self) -> None: ...
    def UseInputPointsOn(self) -> None: ...
    def UseInternalTrianglesOff(self) -> None: ...
    def UseInternalTrianglesOn(self) -> None: ...

class vtkQuadricDecimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    actual_reduction:'getset_descriptor'
    attribute_error_metric:'getset_descriptor'
    boundary_weight_factor:'getset_descriptor'
    map_point_data:'getset_descriptor'
    maximum_error:'getset_descriptor'
    normals_attribute:'getset_descriptor'
    normals_weight:'getset_descriptor'
    regularization:'getset_descriptor'
    regularize:'getset_descriptor'
    scalars_attribute:'getset_descriptor'
    scalars_weight:'getset_descriptor'
    t_coords_attribute:'getset_descriptor'
    t_coords_weight:'getset_descriptor'
    target_reduction:'getset_descriptor'
    tensors_attribute:'getset_descriptor'
    tensors_weight:'getset_descriptor'
    vectors_attribute:'getset_descriptor'
    vectors_weight:'getset_descriptor'
    volume_preservation:'getset_descriptor'
    weigh_boundary_constraints_by_length:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AttributeErrorMetricOff(self) -> None: ...
    def AttributeErrorMetricOn(self) -> None: ...
    def GetActualReduction(self) -> float: ...
    def GetAttributeErrorMetric(self) -> int: ...
    def GetBoundaryWeightFactor(self) -> float: ...
    def GetMapPointData(self) -> bool: ...
    def GetMaximumError(self) -> float: ...
    def GetNormalsAttribute(self) -> int: ...
    def GetNormalsWeight(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRegularization(self) -> float: ...
    def GetRegularize(self) -> int: ...
    def GetScalarsAttribute(self) -> int: ...
    def GetScalarsWeight(self) -> float: ...
    def GetTCoordsAttribute(self) -> int: ...
    def GetTCoordsWeight(self) -> float: ...
    def GetTargetReduction(self) -> float: ...
    def GetTargetReductionMaxValue(self) -> float: ...
    def GetTargetReductionMinValue(self) -> float: ...
    def GetTensorsAttribute(self) -> int: ...
    def GetTensorsWeight(self) -> float: ...
    def GetVectorsAttribute(self) -> int: ...
    def GetVectorsWeight(self) -> float: ...
    def GetVolumePreservation(self) -> int: ...
    def GetWeighBoundaryConstraintsByLength(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapPointDataOff(self) -> None: ...
    def MapPointDataOn(self) -> None: ...
    def NewInstance(self) -> 'vtkQuadricDecimation': ...
    def NormalsAttributeOff(self) -> None: ...
    def NormalsAttributeOn(self) -> None: ...
    def RegularizeOff(self) -> None: ...
    def RegularizeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadricDecimation': ...
    def ScalarsAttributeOff(self) -> None: ...
    def ScalarsAttributeOn(self) -> None: ...
    def SetAttributeErrorMetric(self, _arg:int) -> None: ...
    def SetBoundaryWeightFactor(self, _arg:float) -> None: ...
    def SetMapPointData(self, _arg:bool) -> None: ...
    def SetMaximumError(self, _arg:float) -> None: ...
    def SetNormalsAttribute(self, _arg:int) -> None: ...
    def SetNormalsWeight(self, _arg:float) -> None: ...
    def SetRegularization(self, _arg:float) -> None: ...
    def SetRegularize(self, _arg:int) -> None: ...
    def SetScalarsAttribute(self, _arg:int) -> None: ...
    def SetScalarsWeight(self, _arg:float) -> None: ...
    def SetTCoordsAttribute(self, _arg:int) -> None: ...
    def SetTCoordsWeight(self, _arg:float) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...
    def SetTensorsAttribute(self, _arg:int) -> None: ...
    def SetTensorsWeight(self, _arg:float) -> None: ...
    def SetVectorsAttribute(self, _arg:int) -> None: ...
    def SetVectorsWeight(self, _arg:float) -> None: ...
    def SetVolumePreservation(self, _arg:int) -> None: ...
    def SetWeighBoundaryConstraintsByLength(self, _arg:int) -> None: ...
    def TCoordsAttributeOff(self) -> None: ...
    def TCoordsAttributeOn(self) -> None: ...
    def TensorsAttributeOff(self) -> None: ...
    def TensorsAttributeOn(self) -> None: ...
    def VectorsAttributeOff(self) -> None: ...
    def VectorsAttributeOn(self) -> None: ...
    def VolumePreservationOff(self) -> None: ...
    def VolumePreservationOn(self) -> None: ...
    def WeighBoundaryConstraintsByLengthOff(self) -> None: ...
    def WeighBoundaryConstraintsByLengthOn(self) -> None: ...

class vtkRearrangeFields(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldType(int): ...
    class FieldLocation(int): ...
    class OperationType(int): ...
    ATTRIBUTE:'FieldType'
    CELL_DATA:'FieldLocation'
    COPY:'OperationType'
    DATA_OBJECT:'FieldLocation'
    MOVE:'OperationType'
    NAME:'FieldType'
    POINT_DATA:'FieldLocation'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddOperation(self, operationType:int, attributeType:int, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def AddOperation(self, operationType:int, name:str, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def AddOperation(self, operationType:str, attributeType:str, fromFieldLoc:str, toFieldLoc:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRearrangeFields': ...
    def RemoveAllOperations(self) -> None: ...
    @overload
    def RemoveOperation(self, operationId:int) -> int: ...
    @overload
    def RemoveOperation(self, operationType:int, attributeType:int, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def RemoveOperation(self, operationType:int, name:str, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def RemoveOperation(self, operationType:str, attributeType:str, fromFieldLoc:str, toFieldLoc:str) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRearrangeFields': ...

class vtkRectilinearSynchronizedTemplates(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def ComputeSpacing(self, data:'vtkRectilinearGrid', i:int, j:int, k:int, extent:MutableSequence[int], spacing:MutableSequence[float]) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearSynchronizedTemplates': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearSynchronizedTemplates': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkRemoveDuplicatePolys(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveDuplicatePolys': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveDuplicatePolys': ...

class vtkRemoveUnusedPoints(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    generate_original_point_ids:'getset_descriptor'
    original_point_ids_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateOriginalPointIdsOff(self) -> None: ...
    def GenerateOriginalPointIdsOn(self) -> None: ...
    def GetGenerateOriginalPointIds(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalPointIdsArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveUnusedPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveUnusedPoints': ...
    def SetGenerateOriginalPointIds(self, _arg:bool) -> None: ...
    def SetOriginalPointIdsArrayName(self, _arg:str) -> None: ...

class vtkResampleToImage(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    mask_array_name:'getset_descriptor'
    output:'getset_descriptor'
    sampling_bounds:'getset_descriptor'
    sampling_dimensions:'getset_descriptor'
    use_input_bounds:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMaskArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def GetSamplingBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetSamplingDimensions(self) -> Tuple[int, int, int]: ...
    def GetUseInputBounds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResampleToImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResampleToImage': ...
    @overload
    def SetSamplingBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetSamplingBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSamplingDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSamplingDimensions(self, _arg:Sequence[int]) -> None: ...
    def SetUseInputBounds(self, _arg:bool) -> None: ...
    def UseInputBoundsOff(self) -> None: ...
    def UseInputBoundsOn(self) -> None: ...

class vtkResampleWithDataSet(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    categorical_data:'getset_descriptor'
    cell_locator_prototype:'getset_descriptor'
    compute_tolerance:'getset_descriptor'
    m_time:'getset_descriptor'
    mark_blank_points_and_cells:'getset_descriptor'
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_partial_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    snap_to_cell_with_closest_point:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    use_implicit_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    def GetCategoricalData(self) -> bool: ...
    def GetCellLocatorPrototype(self) -> 'vtkAbstractCellLocator': ...
    def GetComputeTolerance(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMarkBlankPointsAndCells(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> bool: ...
    def GetPassFieldArrays(self) -> bool: ...
    def GetPassPartialArrays(self) -> bool: ...
    def GetPassPointArrays(self) -> bool: ...
    def GetSnapToCellWithClosestPoint(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetUseImplicitArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkBlankPointsAndCellsOff(self) -> None: ...
    def MarkBlankPointsAndCellsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkResampleWithDataSet': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPartialArraysOff(self) -> None: ...
    def PassPartialArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResampleWithDataSet': ...
    def SetCategoricalData(self, arg:bool) -> None: ...
    def SetCellLocatorPrototype(self, __a:'vtkAbstractCellLocator') -> None: ...
    def SetComputeTolerance(self, arg:bool) -> None: ...
    def SetMarkBlankPointsAndCells(self, _arg:bool) -> None: ...
    def SetPassCellArrays(self, arg:bool) -> None: ...
    def SetPassFieldArrays(self, arg:bool) -> None: ...
    def SetPassPartialArrays(self, arg:bool) -> None: ...
    def SetPassPointArrays(self, arg:bool) -> None: ...
    def SetSnapToCellWithClosestPoint(self, arg:bool) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetTolerance(self, arg:float) -> None: ...
    def SetUseImplicitArrays(self, arg:bool) -> None: ...
    def SnapToCellWithClosestPointOff(self) -> None: ...
    def SnapToCellWithClosestPointOn(self) -> None: ...
    def UseImplicitArraysOff(self) -> None: ...
    def UseImplicitArraysOn(self) -> None: ...

class vtkReverseSense(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    reverse_cells:'getset_descriptor'
    reverse_normals:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverseCells(self) -> int: ...
    def GetReverseNormals(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReverseSense': ...
    def ReverseCellsOff(self) -> None: ...
    def ReverseCellsOn(self) -> None: ...
    def ReverseNormalsOff(self) -> None: ...
    def ReverseNormalsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReverseSense': ...
    def SetReverseCells(self, _arg:int) -> None: ...
    def SetReverseNormals(self, _arg:int) -> None: ...

class vtkSimpleElevationFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    vector:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleElevationFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleElevationFilter': ...
    @overload
    def SetVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVector(self, _arg:Sequence[float]) -> None: ...

class vtkSmoothPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    boundary_smoothing:'getset_descriptor'
    convergence:'getset_descriptor'
    edge_angle:'getset_descriptor'
    feature_angle:'getset_descriptor'
    feature_edge_smoothing:'getset_descriptor'
    generate_error_scalars:'getset_descriptor'
    generate_error_vectors:'getset_descriptor'
    number_of_iterations:'getset_descriptor'
    number_of_iterations_max_value:'getset_descriptor'
    number_of_iterations_min_value:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    relaxation_factor:'getset_descriptor'
    source:'getset_descriptor'
    source_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundarySmoothingOff(self) -> None: ...
    def BoundarySmoothingOn(self) -> None: ...
    def FeatureEdgeSmoothingOff(self) -> None: ...
    def FeatureEdgeSmoothingOn(self) -> None: ...
    def GenerateErrorScalarsOff(self) -> None: ...
    def GenerateErrorScalarsOn(self) -> None: ...
    def GenerateErrorVectorsOff(self) -> None: ...
    def GenerateErrorVectorsOn(self) -> None: ...
    def GetBoundarySmoothing(self) -> int: ...
    def GetConvergence(self) -> float: ...
    def GetConvergenceMaxValue(self) -> float: ...
    def GetConvergenceMinValue(self) -> float: ...
    def GetEdgeAngle(self) -> float: ...
    def GetEdgeAngleMaxValue(self) -> float: ...
    def GetEdgeAngleMinValue(self) -> float: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFeatureEdgeSmoothing(self) -> int: ...
    def GetGenerateErrorScalars(self) -> int: ...
    def GetGenerateErrorVectors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRelaxationFactor(self) -> float: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSmoothPolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSmoothPolyDataFilter': ...
    def SetBoundarySmoothing(self, _arg:int) -> None: ...
    def SetConvergence(self, _arg:float) -> None: ...
    def SetEdgeAngle(self, _arg:float) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFeatureEdgeSmoothing(self, _arg:int) -> None: ...
    def SetGenerateErrorScalars(self, _arg:int) -> None: ...
    def SetGenerateErrorVectors(self, _arg:int) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRelaxationFactor(self, _arg:float) -> None: ...
    def SetSourceData(self, source:'vtkPolyData') -> None: ...

class vtkSphereTreeFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    extraction_mode:'getset_descriptor'
    level:'getset_descriptor'
    m_time:'getset_descriptor'
    normal:'getset_descriptor'
    point:'getset_descriptor'
    ray:'getset_descriptor'
    sphere_tree:'getset_descriptor'
    tree_hierarchy:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetLevel(self) -> int: ...
    def GetLevelMaxValue(self) -> int: ...
    def GetLevelMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint(self) -> Tuple[float, float, float]: ...
    def GetRay(self) -> Tuple[float, float, float]: ...
    def GetSphereTree(self) -> 'vtkSphereTree': ...
    def GetTreeHierarchy(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereTreeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereTreeFilter': ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToLevels(self) -> None: ...
    def SetExtractionModeToLine(self) -> None: ...
    def SetExtractionModeToPlane(self) -> None: ...
    def SetExtractionModeToPoint(self) -> None: ...
    def SetLevel(self, _arg:int) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetRay(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRay(self, _arg:Sequence[float]) -> None: ...
    def SetSphereTree(self, __a:'vtkSphereTree') -> None: ...
    def SetTreeHierarchy(self, _arg:bool) -> None: ...
    def TreeHierarchyOff(self) -> None: ...
    def TreeHierarchyOn(self) -> None: ...

class vtkSplitSharpEdgesPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    feature_angle:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplitSharpEdgesPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplitSharpEdgesPolyData': ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkStaticCleanPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    absolute_tolerance:'getset_descriptor'
    average_point_data:'getset_descriptor'
    convert_lines_to_points:'getset_descriptor'
    convert_polys_to_lines:'getset_descriptor'
    convert_strips_to_polys:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    merging_array:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    produce_merge_map:'getset_descriptor'
    remove_unused_points:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AveragePointDataOff(self) -> None: ...
    def AveragePointDataOn(self) -> None: ...
    def ConvertLinesToPointsOff(self) -> None: ...
    def ConvertLinesToPointsOn(self) -> None: ...
    def ConvertPolysToLinesOff(self) -> None: ...
    def ConvertPolysToLinesOn(self) -> None: ...
    def ConvertStripsToPolysOff(self) -> None: ...
    def ConvertStripsToPolysOn(self) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetAveragePointData(self) -> bool: ...
    def GetConvertLinesToPoints(self) -> bool: ...
    def GetConvertPolysToLines(self) -> bool: ...
    def GetConvertStripsToPolys(self) -> bool: ...
    def GetLocator(self) -> 'vtkStaticPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergingArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPieceInvariant(self) -> bool: ...
    def GetProduceMergeMap(self) -> bool: ...
    def GetRemoveUnusedPoints(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStaticCleanPolyData': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def ProduceMergeMapOff(self) -> None: ...
    def ProduceMergeMapOn(self) -> None: ...
    def RemoveUnusedPointsOff(self) -> None: ...
    def RemoveUnusedPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticCleanPolyData': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetAveragePointData(self, _arg:bool) -> None: ...
    def SetConvertLinesToPoints(self, _arg:bool) -> None: ...
    def SetConvertPolysToLines(self, _arg:bool) -> None: ...
    def SetConvertStripsToPolys(self, _arg:bool) -> None: ...
    def SetMergingArray(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:bool) -> None: ...
    def SetProduceMergeMap(self, _arg:bool) -> None: ...
    def SetRemoveUnusedPoints(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkStaticCleanUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    absolute_tolerance:'getset_descriptor'
    average_point_data:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    merging_array:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    produce_merge_map:'getset_descriptor'
    remove_unused_points:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AveragePointDataOff(self) -> None: ...
    def AveragePointDataOn(self) -> None: ...
    @staticmethod
    def AveragePoints(inPts:'vtkPoints', inPD:'vtkPointData', outPts:'vtkPoints', outPD:'vtkPointData', ptMap:MutableSequence[int], tol:float) -> None: ...
    @staticmethod
    def BuildPointMap(numPts:int, pmap:MutableSequence[int], ptUses:MutableSequence[int], mergeMap:MutableSequence[int]) -> int: ...
    @staticmethod
    def CopyPoints(inPts:'vtkPoints', inPD:'vtkPointData', outPts:'vtkPoints', outPD:'vtkPointData', ptMap:MutableSequence[int]) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetAveragePointData(self) -> bool: ...
    def GetLocator(self) -> 'vtkStaticPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergingArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPieceInvariant(self) -> bool: ...
    def GetProduceMergeMap(self) -> bool: ...
    def GetRemoveUnusedPoints(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MarkPointUses(ca:'vtkCellArray', mergeMap:MutableSequence[int], ptUses:MutableSequence[int]) -> None: ...
    def NewInstance(self) -> 'vtkStaticCleanUnstructuredGrid': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def ProduceMergeMapOff(self) -> None: ...
    def ProduceMergeMapOn(self) -> None: ...
    def RemoveUnusedPointsOff(self) -> None: ...
    def RemoveUnusedPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticCleanUnstructuredGrid': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetAveragePointData(self, _arg:bool) -> None: ...
    def SetMergingArray(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:bool) -> None: ...
    def SetProduceMergeMap(self, _arg:bool) -> None: ...
    def SetRemoveUnusedPoints(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkStreamerBase(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamerBase': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamerBase': ...

class vtkStreamingTessellator(vtkmodules.vtkCommonCore.vtkObject):
    MaxFieldSize:int
    const_private_data:'getset_descriptor'
    embedding_dimension:'getset_descriptor'
    field_size:'getset_descriptor'
    maximum_number_of_subdivisions:'getset_descriptor'
    private_data:'getset_descriptor'
    subdivision_algorithm:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AdaptivelySample0Facet(self, v0:MutableSequence[float]) -> None: ...
    def AdaptivelySample1Facet(self, v0:MutableSequence[float], v1:MutableSequence[float]) -> None: ...
    def AdaptivelySample1FacetLinear(self, v0:MutableSequence[float], v1:MutableSequence[float]) -> None: ...
    def AdaptivelySample2Facet(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float]) -> None: ...
    def AdaptivelySample2FacetLinear(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float]) -> None: ...
    def AdaptivelySample3Facet(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float], v3:MutableSequence[float]) -> None: ...
    def AdaptivelySample3FacetLinear(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float], v3:MutableSequence[float]) -> None: ...
    def GetCaseCount(self, c:int) -> int: ...
    def GetConstPrivateData(self) -> Pointer: ...
    def GetEmbeddingDimension(self, k:int) -> int: ...
    def GetFieldSize(self, k:int) -> int: ...
    def GetMaximumNumberOfSubdivisions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrivateData(self) -> Pointer: ...
    def GetSubcaseCount(self, casenum:int, sub:int) -> int: ...
    def GetSubdivisionAlgorithm(self) -> 'vtkEdgeSubdivisionCriterion': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamingTessellator': ...
    def ResetCounts(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamingTessellator': ...
    def SetConstPrivateData(self, ConstPrivate:Pointer) -> None: ...
    def SetEmbeddingDimension(self, k:int, d:int) -> None: ...
    def SetFieldSize(self, k:int, s:int) -> None: ...
    def SetMaximumNumberOfSubdivisions(self, num_subdiv_in:int) -> None: ...
    def SetPrivateData(self, Private:Pointer) -> None: ...
    def SetSubdivisionAlgorithm(self, __a:'vtkEdgeSubdivisionCriterion') -> None: ...

class vtkStripper(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    join_contiguous_segments:'getset_descriptor'
    maximum_length:'getset_descriptor'
    pass_cell_data_as_field_data:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    pass_through_point_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetJoinContiguousSegments(self) -> int: ...
    def GetMaximumLength(self) -> int: ...
    def GetMaximumLengthMaxValue(self) -> int: ...
    def GetMaximumLengthMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellDataAsFieldData(self) -> int: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def JoinContiguousSegmentsOff(self) -> None: ...
    def JoinContiguousSegmentsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkStripper': ...
    def PassCellDataAsFieldDataOff(self) -> None: ...
    def PassCellDataAsFieldDataOn(self) -> None: ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStripper': ...
    def SetJoinContiguousSegments(self, _arg:int) -> None: ...
    def SetMaximumLength(self, _arg:int) -> None: ...
    def SetPassCellDataAsFieldData(self, _arg:int) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...

class vtkStructuredDataPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    batch_size:'getset_descriptor'
    build_hierarchy:'getset_descriptor'
    build_tree:'getset_descriptor'
    compute_normals:'getset_descriptor'
    generate_polygons:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    plane:'getset_descriptor'
    sphere_tree:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildHierarchyOff(self) -> None: ...
    def BuildHierarchyOn(self) -> None: ...
    def BuildTreeOff(self) -> None: ...
    def BuildTreeOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GeneratePolygonsOff(self) -> None: ...
    def GeneratePolygonsOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetBuildHierarchy(self) -> bool: ...
    def GetBuildTree(self) -> bool: ...
    def GetComputeNormals(self) -> bool: ...
    def GetGeneratePolygons(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def GetSphereTree(self) -> 'vtkSphereTree': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredDataPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredDataPlaneCutter': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetBuildHierarchy(self, _arg:bool) -> None: ...
    def SetBuildTree(self, _arg:bool) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetGeneratePolygons(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...
    def SetSphereTree(self, __a:'vtkSphereTree') -> None: ...

class vtkStructuredGridAppend(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self, num:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridAppend': ...
    def ReplaceNthInputConnection(self, idx:int, input:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridAppend': ...
    @overload
    def SetInputData(self, num:int, input:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, input:'vtkDataObject') -> None: ...

class vtkStructuredGridOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridOutlineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridOutlineFilter': ...

class vtkSurfaceNets2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    background_label:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    data_caching:'getset_descriptor'
    labels:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    smoother:'getset_descriptor'
    smoothing:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def DataCachingOff(self) -> None: ...
    def DataCachingOn(self) -> None: ...
    @overload
    def GenerateLabels(self, numLabels:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateLabels(self, numLabels:int, rangeStart:float, rangeEnd:float) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetBackgroundLabel(self) -> float: ...
    def GetComputeScalars(self) -> bool: ...
    def GetDataCaching(self) -> bool: ...
    def GetLabel(self, i:int) -> float: ...
    @overload
    def GetLabels(self) -> Pointer: ...
    @overload
    def GetLabels(self, contourValues:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetSmoother(self) -> 'vtkConstrainedSmoothingFilter': ...
    def GetSmoothing(self) -> bool: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSurfaceNets2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSurfaceNets2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetBackgroundLabel(self, _arg:float) -> None: ...
    def SetComputeScalars(self, _arg:bool) -> None: ...
    def SetDataCaching(self, _arg:bool) -> None: ...
    def SetLabel(self, i:int, value:float) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetNumberOfLabels(self, number:int) -> None: ...
    def SetSmoothing(self, _arg:bool) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def SmoothingOff(self) -> None: ...
    def SmoothingOn(self) -> None: ...

class vtkSurfaceNets3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class MeshType(int): ...
    class OutputType(int): ...
    class TriangulationType(int): ...
    MESH_TYPE_DEFAULT:'MeshType'
    MESH_TYPE_QUADS:'MeshType'
    MESH_TYPE_TRIANGLES:'MeshType'
    OUTPUT_STYLE_BOUNDARY:'OutputType'
    OUTPUT_STYLE_DEFAULT:'OutputType'
    OUTPUT_STYLE_SELECTED:'OutputType'
    TRIANGULATION_GREEDY:'TriangulationType'
    TRIANGULATION_MIN_AREA:'TriangulationType'
    TRIANGULATION_MIN_EDGE:'TriangulationType'
    array_component:'getset_descriptor'
    automatic_smoothing_constraints:'getset_descriptor'
    background_label:'getset_descriptor'
    constraint_box:'getset_descriptor'
    constraint_distance:'getset_descriptor'
    constraint_scale:'getset_descriptor'
    constraint_strategy:'getset_descriptor'
    data_caching:'getset_descriptor'
    labels:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    number_of_iterations:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    number_of_selected_labels:'getset_descriptor'
    optimized_smoothing_stencils:'getset_descriptor'
    output_mesh_type:'getset_descriptor'
    output_style:'getset_descriptor'
    relaxation_factor:'getset_descriptor'
    smoother:'getset_descriptor'
    smoothing:'getset_descriptor'
    triangulation_strategy:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddSelectedLabel(self, label:float) -> None: ...
    def AutomaticSmoothingConstraintsOff(self) -> None: ...
    def AutomaticSmoothingConstraintsOn(self) -> None: ...
    def DataCachingOff(self) -> None: ...
    def DataCachingOn(self) -> None: ...
    def DeleteSelectedLabel(self, label:float) -> None: ...
    @overload
    def GenerateLabels(self, numLabels:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateLabels(self, numLabels:int, rangeStart:float, rangeEnd:float) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetAutomaticSmoothingConstraints(self) -> bool: ...
    def GetBackgroundLabel(self) -> float: ...
    @overload
    def GetConstraintBox(self) -> Tuple[float, float, float]: ...
    @overload
    def GetConstraintBox(self, s:MutableSequence[float]) -> None: ...
    def GetConstraintDistance(self) -> float: ...
    def GetConstraintScale(self) -> float: ...
    def GetConstraintScaleMaxValue(self) -> float: ...
    def GetConstraintScaleMinValue(self) -> float: ...
    def GetConstraintStrategy(self) -> int: ...
    def GetDataCaching(self) -> bool: ...
    def GetLabel(self, i:int) -> float: ...
    @overload
    def GetLabels(self) -> Pointer: ...
    @overload
    def GetLabels(self, contourValues:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetNumberOfSelectedLabels(self) -> int: ...
    def GetOptimizedSmoothingStencils(self) -> bool: ...
    def GetOutputMeshType(self) -> int: ...
    def GetOutputMeshTypeMaxValue(self) -> int: ...
    def GetOutputMeshTypeMinValue(self) -> int: ...
    def GetOutputStyle(self) -> int: ...
    def GetOutputStyleMaxValue(self) -> int: ...
    def GetOutputStyleMinValue(self) -> int: ...
    def GetRelaxationFactor(self) -> float: ...
    def GetSelectedLabel(self, ithLabel:int) -> float: ...
    def GetSmoother(self) -> 'vtkConstrainedSmoothingFilter': ...
    def GetSmoothing(self) -> bool: ...
    def GetTriangulationStrategy(self) -> int: ...
    def GetTriangulationStrategyMaxValue(self) -> int: ...
    def GetTriangulationStrategyMinValue(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def InitializeSelectedLabelsList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSurfaceNets3D': ...
    def OptimizedSmoothingStencilsOff(self) -> None: ...
    def OptimizedSmoothingStencilsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSurfaceNets3D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetAutomaticSmoothingConstraints(self, _arg:bool) -> None: ...
    def SetBackgroundLabel(self, _arg:float) -> None: ...
    @overload
    def SetConstraintBox(self, sx:float, sy:float, sz:float) -> None: ...
    @overload
    def SetConstraintBox(self, s:MutableSequence[float]) -> None: ...
    def SetConstraintDistance(self, d:float) -> None: ...
    def SetConstraintScale(self, _arg:float) -> None: ...
    def SetConstraintStrategyToConstraintBox(self) -> None: ...
    def SetConstraintStrategyToConstraintDistance(self) -> None: ...
    def SetDataCaching(self, _arg:bool) -> None: ...
    def SetLabel(self, i:int, value:float) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetNumberOfIterations(self, n:int) -> None: ...
    def SetNumberOfLabels(self, number:int) -> None: ...
    def SetOptimizedSmoothingStencils(self, _arg:bool) -> None: ...
    def SetOutputMeshType(self, _arg:int) -> None: ...
    def SetOutputMeshTypeToDefault(self) -> None: ...
    def SetOutputMeshTypeToQuads(self) -> None: ...
    def SetOutputMeshTypeToTriangles(self) -> None: ...
    def SetOutputStyle(self, _arg:int) -> None: ...
    def SetOutputStyleToBoundary(self) -> None: ...
    def SetOutputStyleToDefault(self) -> None: ...
    def SetOutputStyleToSelected(self) -> None: ...
    def SetRelaxationFactor(self, f:float) -> None: ...
    def SetSmoothing(self, _arg:bool) -> None: ...
    def SetTriangulationStrategy(self, _arg:int) -> None: ...
    def SetTriangulationStrategyToGreedy(self) -> None: ...
    def SetTriangulationStrategyToMinArea(self) -> None: ...
    def SetTriangulationStrategyToMinEdge(self) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def SmoothingOff(self) -> None: ...
    def SmoothingOn(self) -> None: ...

class vtkSynchronizedTemplates2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizedTemplates2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizedTemplates2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkSynchronizedTemplates3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    input_memory_limit:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetInputMemoryLimit(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizedTemplates3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizedTemplates3D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetInputMemoryLimit(self, limit:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def ThreadedExecute(self, data:'vtkImageData', inInfo:'vtkInformation', outInfo:'vtkInformation', inScalars:'vtkDataArray') -> None: ...

class vtkSynchronizedTemplatesCutter3D(vtkSynchronizedTemplates3D):
    cut_function:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCutFunction(self) -> 'vtkImplicitFunction': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizedTemplatesCutter3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizedTemplatesCutter3D': ...
    def SetCutFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def ThreadedExecute(self, data:'vtkImageData', outInfo:'vtkInformation', __c:int) -> None: ...

class vtkTensorGlyph(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    COLOR_BY_EIGENVALUES:int
    COLOR_BY_SCALARS:int
    clamp_scaling:'getset_descriptor'
    color_glyphs:'getset_descriptor'
    color_mode:'getset_descriptor'
    extract_eigenvalues:'getset_descriptor'
    length:'getset_descriptor'
    max_scale_factor:'getset_descriptor'
    scale_factor:'getset_descriptor'
    scaling:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    symmetric:'getset_descriptor'
    three_glyphs:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClampScalingOff(self) -> None: ...
    def ClampScalingOn(self) -> None: ...
    def ColorGlyphsOff(self) -> None: ...
    def ColorGlyphsOn(self) -> None: ...
    def ExtractEigenvaluesOff(self) -> None: ...
    def ExtractEigenvaluesOn(self) -> None: ...
    def GetClampScaling(self) -> int: ...
    def GetColorGlyphs(self) -> int: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeMaxValue(self) -> int: ...
    def GetColorModeMinValue(self) -> int: ...
    def GetExtractEigenvalues(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetMaxScaleFactor(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaling(self) -> int: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def GetSymmetric(self) -> int: ...
    def GetThreeGlyphs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTensorGlyph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTensorGlyph': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetClampScaling(self, _arg:int) -> None: ...
    def SetColorGlyphs(self, _arg:int) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToEigenvalues(self) -> None: ...
    def SetColorModeToScalars(self) -> None: ...
    def SetExtractEigenvalues(self, _arg:int) -> None: ...
    def SetLength(self, _arg:float) -> None: ...
    def SetMaxScaleFactor(self, _arg:float) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaling(self, _arg:int) -> None: ...
    @overload
    def SetSourceConnection(self, id:int, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkPolyData') -> None: ...
    def SetSymmetric(self, _arg:int) -> None: ...
    def SetThreeGlyphs(self, _arg:int) -> None: ...
    def SymmetricOff(self) -> None: ...
    def SymmetricOn(self) -> None: ...
    def ThreeGlyphsOff(self) -> None: ...
    def ThreeGlyphsOn(self) -> None: ...

class vtkThreshold(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    class ThresholdType(int): ...
    THRESHOLD_BETWEEN:'ThresholdType'
    THRESHOLD_LOWER:'ThresholdType'
    THRESHOLD_UPPER:'ThresholdType'
    all_scalars:'getset_descriptor'
    component_mode:'getset_descriptor'
    invert:'getset_descriptor'
    lower_threshold:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    selected_component:'getset_descriptor'
    threshold_function:'getset_descriptor'
    upper_threshold:'getset_descriptor'
    use_continuous_cell_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllScalarsOff(self) -> None: ...
    def AllScalarsOn(self) -> None: ...
    def Between(self, s:float) -> int: ...
    def GetAllScalars(self) -> int: ...
    def GetComponentMode(self) -> int: ...
    def GetComponentModeAsString(self) -> str: ...
    def GetComponentModeMaxValue(self) -> int: ...
    def GetComponentModeMinValue(self) -> int: ...
    def GetInvert(self) -> bool: ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetSelectedComponent(self) -> int: ...
    def GetSelectedComponentMaxValue(self) -> int: ...
    def GetSelectedComponentMinValue(self) -> int: ...
    def GetThresholdFunction(self) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def GetUseContinuousCellRange(self) -> int: ...
    def InvertOff(self) -> None: ...
    def InvertOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Lower(self, s:float) -> int: ...
    def NewInstance(self) -> 'vtkThreshold': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThreshold': ...
    def SetAllScalars(self, _arg:int) -> None: ...
    def SetComponentMode(self, _arg:int) -> None: ...
    def SetComponentModeToUseAll(self) -> None: ...
    def SetComponentModeToUseAny(self) -> None: ...
    def SetComponentModeToUseSelected(self) -> None: ...
    def SetInvert(self, _arg:bool) -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSelectedComponent(self, _arg:int) -> None: ...
    def SetThresholdFunction(self, function:int) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    def SetUseContinuousCellRange(self, _arg:int) -> None: ...
    def Upper(self, s:float) -> int: ...
    def UseContinuousCellRangeOff(self) -> None: ...
    def UseContinuousCellRangeOn(self) -> None: ...

class vtkThresholdPoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    input_array_component:'getset_descriptor'
    lower_threshold:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    upper_threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInputArrayComponent(self) -> int: ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkThresholdPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThresholdPoints': ...
    def SetInputArrayComponent(self, _arg:int) -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    def ThresholdBetween(self, lower:float, upper:float) -> None: ...
    def ThresholdByLower(self, lower:float) -> None: ...
    def ThresholdByUpper(self, upper:float) -> None: ...

class vtkTransposeTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    add_id_column:'getset_descriptor'
    id_column_name:'getset_descriptor'
    use_id_column:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddIdColumnOff(self) -> None: ...
    def AddIdColumnOn(self) -> None: ...
    def GetAddIdColumn(self) -> bool: ...
    def GetIdColumnName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseIdColumn(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransposeTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransposeTable': ...
    def SetAddIdColumn(self, _arg:bool) -> None: ...
    def SetIdColumnName(self, _arg:str) -> None: ...
    def SetUseIdColumn(self, _arg:bool) -> None: ...
    def UseIdColumnOff(self) -> None: ...
    def UseIdColumnOn(self) -> None: ...

class vtkTriangleFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    pass_lines:'getset_descriptor'
    pass_verts:'getset_descriptor'
    preserve_polys:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassLines(self) -> int: ...
    def GetPassVerts(self) -> int: ...
    def GetPreservePolys(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriangleFilter': ...
    def PassLinesOff(self) -> None: ...
    def PassLinesOn(self) -> None: ...
    def PassVertsOff(self) -> None: ...
    def PassVertsOn(self) -> None: ...
    def PreservePolysOff(self) -> None: ...
    def PreservePolysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriangleFilter': ...
    def SetPassLines(self, _arg:int) -> None: ...
    def SetPassVerts(self, _arg:int) -> None: ...
    def SetPreservePolys(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkTriangleMeshPointNormals(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriangleMeshPointNormals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriangleMeshPointNormals': ...

class vtkTubeBender(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTubeBender': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTubeBender': ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkTubeFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    capping:'getset_descriptor'
    default_normal:'getset_descriptor'
    generate_t_coords:'getset_descriptor'
    number_of_sides:'getset_descriptor'
    number_of_sides_max_value:'getset_descriptor'
    number_of_sides_min_value:'getset_descriptor'
    offset:'getset_descriptor'
    on_ratio:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    radius:'getset_descriptor'
    radius_factor:'getset_descriptor'
    sides_share_vertices:'getset_descriptor'
    texture_length:'getset_descriptor'
    use_default_normal:'getset_descriptor'
    vary_radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetCapping(self) -> int: ...
    def GetDefaultNormal(self) -> Tuple[float, float, float]: ...
    def GetGenerateTCoords(self) -> int: ...
    def GetGenerateTCoordsAsString(self) -> str: ...
    def GetGenerateTCoordsMaxValue(self) -> int: ...
    def GetGenerateTCoordsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSides(self) -> int: ...
    def GetNumberOfSidesMaxValue(self) -> int: ...
    def GetNumberOfSidesMinValue(self) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusFactor(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetSidesShareVertices(self) -> int: ...
    def GetTextureLength(self) -> float: ...
    def GetTextureLengthMaxValue(self) -> float: ...
    def GetTextureLengthMinValue(self) -> float: ...
    def GetUseDefaultNormal(self) -> int: ...
    def GetVaryRadius(self) -> int: ...
    def GetVaryRadiusAsString(self) -> str: ...
    def GetVaryRadiusMaxValue(self) -> int: ...
    def GetVaryRadiusMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTubeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTubeFilter': ...
    def SetCapping(self, _arg:int) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg:Sequence[float]) -> None: ...
    def SetGenerateTCoords(self, _arg:int) -> None: ...
    def SetGenerateTCoordsToNormalizedLength(self) -> None: ...
    def SetGenerateTCoordsToOff(self) -> None: ...
    def SetGenerateTCoordsToUseLength(self) -> None: ...
    def SetGenerateTCoordsToUseScalars(self) -> None: ...
    def SetNumberOfSides(self, _arg:int) -> None: ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetRadiusFactor(self, _arg:float) -> None: ...
    def SetSidesShareVertices(self, _arg:int) -> None: ...
    def SetTextureLength(self, _arg:float) -> None: ...
    def SetUseDefaultNormal(self, _arg:int) -> None: ...
    def SetVaryRadius(self, _arg:int) -> None: ...
    def SetVaryRadiusToVaryRadiusByAbsoluteScalar(self) -> None: ...
    def SetVaryRadiusToVaryRadiusByScalar(self) -> None: ...
    def SetVaryRadiusToVaryRadiusByVector(self) -> None: ...
    def SetVaryRadiusToVaryRadiusByVectorNorm(self) -> None: ...
    def SetVaryRadiusToVaryRadiusOff(self) -> None: ...
    def SidesShareVerticesOff(self) -> None: ...
    def SidesShareVerticesOn(self) -> None: ...
    def UseDefaultNormalOff(self) -> None: ...
    def UseDefaultNormalOn(self) -> None: ...

class vtkUnstructuredGridQuadricDecimation(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    NON_ERROR:int
    NON_TETRAHEDRA:int
    NO_CELLS:int
    NO_SCALARS:int
    auto_add_candidates:'getset_descriptor'
    auto_add_candidates_threshold:'getset_descriptor'
    boundary_weight:'getset_descriptor'
    number_of_candidates:'getset_descriptor'
    number_of_edges_to_decimate:'getset_descriptor'
    number_of_tets_output:'getset_descriptor'
    scalars_name:'getset_descriptor'
    target_reduction:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAutoAddCandidates(self) -> int: ...
    def GetAutoAddCandidatesThreshold(self) -> float: ...
    def GetBoundaryWeight(self) -> float: ...
    def GetNumberOfCandidates(self) -> int: ...
    def GetNumberOfEdgesToDecimate(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTetsOutput(self) -> int: ...
    def GetScalarsName(self) -> str: ...
    def GetTargetReduction(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridQuadricDecimation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridQuadricDecimation': ...
    def SetAutoAddCandidates(self, _arg:int) -> None: ...
    def SetAutoAddCandidatesThreshold(self, _arg:float) -> None: ...
    def SetBoundaryWeight(self, _arg:float) -> None: ...
    def SetNumberOfCandidates(self, _arg:int) -> None: ...
    def SetNumberOfEdgesToDecimate(self, _arg:int) -> None: ...
    def SetNumberOfTetsOutput(self, _arg:int) -> None: ...
    def SetScalarsName(self, _arg:str) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...

class vtkUnstructuredGridToExplicitStructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkExplicitStructuredGridAlgorithm):
    whole_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridToExplicitStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridToExplicitStructuredGrid': ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...

class vtkVectorDot(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    actual_range:'getset_descriptor'
    map_scalars:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActualRange(self) -> Tuple[float, float]: ...
    def GetMapScalars(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsOff(self) -> None: ...
    def MapScalarsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkVectorDot': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVectorDot': ...
    def SetMapScalars(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkVectorNorm(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    attribute_mode:'getset_descriptor'
    normalize:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAttributeMode(self) -> int: ...
    def GetAttributeModeAsString(self) -> str: ...
    def GetNormalize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVectorNorm': ...
    def NormalizeOff(self) -> None: ...
    def NormalizeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVectorNorm': ...
    def SetAttributeMode(self, _arg:int) -> None: ...
    def SetAttributeModeToDefault(self) -> None: ...
    def SetAttributeModeToUseCellData(self) -> None: ...
    def SetAttributeModeToUsePointData(self) -> None: ...
    def SetNormalize(self, _arg:int) -> None: ...

class vtkVoronoi2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class ProjectionPlaneStrategy(int): ...
    class GenerateScalarsStrategy(int): ...
    BEST_FITTING_PLANE:'ProjectionPlaneStrategy'
    NONE:'GenerateScalarsStrategy'
    POINT_IDS:'GenerateScalarsStrategy'
    SPECIFIED_TRANSFORM_PLANE:'ProjectionPlaneStrategy'
    THREAD_IDS:'GenerateScalarsStrategy'
    XY_PLANE:'ProjectionPlaneStrategy'
    generate_scalars:'getset_descriptor'
    generate_voronoi_flower:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_number_of_tile_clips:'getset_descriptor'
    number_of_threads_used:'getset_descriptor'
    padding:'getset_descriptor'
    point_of_interest:'getset_descriptor'
    projection_plane_mode:'getset_descriptor'
    spheres:'getset_descriptor'
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateVoronoiFlowerOff(self) -> None: ...
    def GenerateVoronoiFlowerOn(self) -> None: ...
    def GetGenerateScalars(self) -> int: ...
    def GetGenerateVoronoiFlower(self) -> int: ...
    def GetLocator(self) -> 'vtkStaticPointLocator2D': ...
    def GetMTime(self) -> int: ...
    def GetMaximumNumberOfTileClips(self) -> int: ...
    def GetMaximumNumberOfTileClipsMaxValue(self) -> int: ...
    def GetMaximumNumberOfTileClipsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetPadding(self) -> float: ...
    def GetPaddingMaxValue(self) -> float: ...
    def GetPaddingMinValue(self) -> float: ...
    def GetPointOfInterest(self) -> int: ...
    def GetPointOfInterestMaxValue(self) -> int: ...
    def GetPointOfInterestMinValue(self) -> int: ...
    def GetProjectionPlaneMode(self) -> int: ...
    def GetProjectionPlaneModeMaxValue(self) -> int: ...
    def GetProjectionPlaneModeMinValue(self) -> int: ...
    def GetSpheres(self) -> 'vtkSpheres': ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoronoi2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoronoi2D': ...
    def SetGenerateScalars(self, _arg:int) -> None: ...
    def SetGenerateScalarsToNone(self) -> None: ...
    def SetGenerateScalarsToPointIds(self) -> None: ...
    def SetGenerateScalarsToThreadIds(self) -> None: ...
    def SetGenerateVoronoiFlower(self, _arg:int) -> None: ...
    def SetMaximumNumberOfTileClips(self, _arg:int) -> None: ...
    def SetPadding(self, _arg:float) -> None: ...
    def SetPointOfInterest(self, _arg:int) -> None: ...
    def SetProjectionPlaneMode(self, _arg:int) -> None: ...
    def SetProjectionPlaneModeToBestFittingPlane(self) -> None: ...
    def SetProjectionPlaneModeToSpecifiedTransformPlane(self) -> None: ...
    def SetProjectionPlaneModeToXYPlane(self) -> None: ...
    def SetTransform(self, __a:'vtkAbstractTransform') -> None: ...

class vtkWindowedSincPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    BLACKMAN:int
    HAMMING:int
    HANNING:int
    NUTTALL:int
    boundary_smoothing:'getset_descriptor'
    edge_angle:'getset_descriptor'
    feature_angle:'getset_descriptor'
    feature_edge_smoothing:'getset_descriptor'
    generate_error_scalars:'getset_descriptor'
    generate_error_vectors:'getset_descriptor'
    non_manifold_smoothing:'getset_descriptor'
    normalize_coordinates:'getset_descriptor'
    number_of_iterations:'getset_descriptor'
    number_of_iterations_max_value:'getset_descriptor'
    number_of_iterations_min_value:'getset_descriptor'
    pass_band:'getset_descriptor'
    weight_non_manifold_edges:'getset_descriptor'
    window_function:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundarySmoothingOff(self) -> None: ...
    def BoundarySmoothingOn(self) -> None: ...
    def FeatureEdgeSmoothingOff(self) -> None: ...
    def FeatureEdgeSmoothingOn(self) -> None: ...
    def GenerateErrorScalarsOff(self) -> None: ...
    def GenerateErrorScalarsOn(self) -> None: ...
    def GenerateErrorVectorsOff(self) -> None: ...
    def GenerateErrorVectorsOn(self) -> None: ...
    def GetBoundarySmoothing(self) -> int: ...
    def GetEdgeAngle(self) -> float: ...
    def GetEdgeAngleMaxValue(self) -> float: ...
    def GetEdgeAngleMinValue(self) -> float: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFeatureEdgeSmoothing(self) -> int: ...
    def GetGenerateErrorScalars(self) -> int: ...
    def GetGenerateErrorVectors(self) -> int: ...
    def GetNonManifoldSmoothing(self) -> int: ...
    def GetNormalizeCoordinates(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetPassBand(self) -> float: ...
    def GetPassBandMaxValue(self) -> float: ...
    def GetPassBandMinValue(self) -> float: ...
    def GetWeightNonManifoldEdges(self) -> int: ...
    def GetWindowFunction(self) -> int: ...
    def GetWindowFunctionMaxValue(self) -> int: ...
    def GetWindowFunctionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWindowedSincPolyDataFilter': ...
    def NonManifoldSmoothingOff(self) -> None: ...
    def NonManifoldSmoothingOn(self) -> None: ...
    def NormalizeCoordinatesOff(self) -> None: ...
    def NormalizeCoordinatesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWindowedSincPolyDataFilter': ...
    def SetBoundarySmoothing(self, _arg:int) -> None: ...
    def SetEdgeAngle(self, _arg:float) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFeatureEdgeSmoothing(self, _arg:int) -> None: ...
    def SetGenerateErrorScalars(self, _arg:int) -> None: ...
    def SetGenerateErrorVectors(self, _arg:int) -> None: ...
    def SetNonManifoldSmoothing(self, _arg:int) -> None: ...
    def SetNormalizeCoordinates(self, _arg:int) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetPassBand(self, _arg:float) -> None: ...
    def SetWeightNonManifoldEdges(self, _arg:int) -> None: ...
    def SetWindowFunction(self, _arg:int) -> None: ...
    def SetWindowFunctionToBlackman(self) -> None: ...
    def SetWindowFunctionToHamming(self) -> None: ...
    def SetWindowFunctionToNuttall(self) -> None: ...
    def SetWindowFunctionoHanning(self) -> None: ...
    def WeightNonManifoldEdgesOff(self) -> None: ...
    def WeightNonManifoldEdgesOn(self) -> None: ...

