from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkToImplicitStrategy(vtkmodules.vtkCommonCore.vtkObject):
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearCache(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToImplicitStrategy': ...
    def Reduce(self, __a:'vtkDataArray') -> 'vtkDataArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToImplicitStrategy': ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkToAffineArrayStrategy(vtkToImplicitStrategy):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToAffineArrayStrategy': ...
    def Reduce(self, __a:'vtkDataArray') -> 'vtkDataArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToAffineArrayStrategy': ...

class vtkToConstantArrayStrategy(vtkToImplicitStrategy):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToConstantArrayStrategy': ...
    def Reduce(self, __a:'vtkDataArray') -> 'vtkDataArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToConstantArrayStrategy': ...

class vtkToImplicitArrayFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    cell_data_array_selection:'getset_descriptor'
    edge_data_array_selection:'getset_descriptor'
    field_data_array_selection:'getset_descriptor'
    max_number_of_degrees_of_freedom:'getset_descriptor'
    point_data_array_selection:'getset_descriptor'
    points_then_cells_data_array_selection:'getset_descriptor'
    row_data_array_selection:'getset_descriptor'
    strategy:'getset_descriptor'
    target_reduction:'getset_descriptor'
    use_max_number_of_degrees_of_freedom:'getset_descriptor'
    vertex_data_array_selection:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetArraySelection(self, association:int) -> 'vtkDataArraySelection': ...
    def GetCellDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetEdgeDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetFieldDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetMaxNumberOfDegreesOfFreedom(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetPointsThenCellsDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetRowDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetStrategy(self) -> 'vtkToImplicitStrategy': ...
    def GetTargetReduction(self) -> float: ...
    def GetUseMaxNumberOfDegreesOfFreedom(self) -> bool: ...
    def GetVertexDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToImplicitArrayFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToImplicitArrayFilter': ...
    def SetMaxNumberOfDegreesOfFreedom(self, _arg:int) -> None: ...
    def SetStrategy(self, __a:'vtkToImplicitStrategy') -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...
    def SetUseMaxNumberOfDegreesOfFreedom(self, _arg:bool) -> None: ...
    def UseMaxNumberOfDegreesOfFreedomOff(self) -> None: ...
    def UseMaxNumberOfDegreesOfFreedomOn(self) -> None: ...

class vtkToImplicitRamerDouglasPeuckerStrategy(vtkToImplicitStrategy):
    def __init__(self, **properties:Any) -> None: ...
    def ClearCache(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToImplicitRamerDouglasPeuckerStrategy': ...
    def Reduce(self, __a:'vtkDataArray') -> 'vtkDataArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToImplicitRamerDouglasPeuckerStrategy': ...

class vtkToImplicitTypeErasureStrategy(vtkToImplicitStrategy):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToImplicitTypeErasureStrategy': ...
    def Reduce(self, __a:'vtkDataArray') -> 'vtkDataArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToImplicitTypeErasureStrategy': ...

