from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOCore

VTK_ASCII:int
VTK_BINARY:int

class vtkDataReader(vtkmodules.vtkCommonExecutionModel.vtkSimpleReader):
    class FieldType(int): ...
    CELL_DATA:'FieldType'
    FIELD_DATA:'FieldType'
    POINT_DATA:'FieldType'
    field_data_name:'getset_descriptor'
    file_major_version:'getset_descriptor'
    file_minor_version:'getset_descriptor'
    file_name:'getset_descriptor'
    file_type:'getset_descriptor'
    file_version:'getset_descriptor'
    header:'getset_descriptor'
    input_array:'getset_descriptor'
    input_string:'getset_descriptor'
    input_string_length:'getset_descriptor'
    lookup_table_name:'getset_descriptor'
    normals_name:'getset_descriptor'
    number_of_field_data_in_file:'getset_descriptor'
    number_of_normals_in_file:'getset_descriptor'
    number_of_scalars_in_file:'getset_descriptor'
    number_of_t_coords_in_file:'getset_descriptor'
    number_of_tensors_in_file:'getset_descriptor'
    number_of_vectors_in_file:'getset_descriptor'
    read_all_color_scalars:'getset_descriptor'
    read_all_fields:'getset_descriptor'
    read_all_normals:'getset_descriptor'
    read_all_scalars:'getset_descriptor'
    read_all_t_coords:'getset_descriptor'
    read_all_tensors:'getset_descriptor'
    read_all_vectors:'getset_descriptor'
    read_from_input_string:'getset_descriptor'
    scalars_name:'getset_descriptor'
    t_coords_name:'getset_descriptor'
    tensors_name:'getset_descriptor'
    vectors_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CloseVTKFile(self) -> None: ...
    def GetFieldDataName(self) -> str: ...
    def GetFieldDataNameInFile(self, i:int) -> str: ...
    def GetFileMajorVersion(self) -> int: ...
    def GetFileMinorVersion(self) -> int: ...
    @overload
    def GetFileName(self) -> str: ...
    @overload
    def GetFileName(self, i:int) -> str: ...
    def GetFileType(self) -> int: ...
    def GetFileVersion(self) -> int: ...
    def GetHeader(self) -> str: ...
    def GetInputArray(self) -> 'vtkCharArray': ...
    def GetInputString(self) -> str: ...
    def GetInputStringLength(self) -> int: ...
    def GetLookupTableName(self) -> str: ...
    def GetNormalsName(self) -> str: ...
    def GetNormalsNameInFile(self, i:int) -> str: ...
    def GetNumberOfFieldDataInFile(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNormalsInFile(self) -> int: ...
    def GetNumberOfScalarsInFile(self) -> int: ...
    def GetNumberOfTCoordsInFile(self) -> int: ...
    def GetNumberOfTensorsInFile(self) -> int: ...
    def GetNumberOfVectorsInFile(self) -> int: ...
    def GetReadAllColorScalars(self) -> int: ...
    def GetReadAllFields(self) -> int: ...
    def GetReadAllNormals(self) -> int: ...
    def GetReadAllScalars(self) -> int: ...
    def GetReadAllTCoords(self) -> int: ...
    def GetReadAllTensors(self) -> int: ...
    def GetReadAllVectors(self) -> int: ...
    def GetReadFromInputString(self) -> int: ...
    def GetScalarsName(self) -> str: ...
    def GetScalarsNameInFile(self, i:int) -> str: ...
    def GetTCoordsName(self) -> str: ...
    def GetTCoordsNameInFile(self, i:int) -> str: ...
    def GetTensorsName(self) -> str: ...
    def GetTensorsNameInFile(self, i:int) -> str: ...
    def GetVectorsName(self) -> str: ...
    def GetVectorsNameInFile(self, i:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsFilePolyData(self) -> int: ...
    def IsFileRectilinearGrid(self) -> int: ...
    def IsFileStructuredGrid(self) -> int: ...
    def IsFileStructuredPoints(self) -> int: ...
    def IsFileUnstructuredGrid(self) -> int: ...
    def IsFileValid(self, dstype:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LowerCase(self, str:str, len:int=256) -> str: ...
    def NewInstance(self) -> 'vtkDataReader': ...
    def OpenVTKFile(self, fname:str=...) -> int: ...
    def Peek(self, str:str, n:int) -> int: ...
    @overload
    def Read(self, __a:str) -> int: ...
    @overload
    def Read(self, __a:MutableSequence[int]) -> int: ...
    @overload
    def Read(self, result:MutableSequence[int]) -> int: ...
    @overload
    def Read(self, __a:MutableSequence[float]) -> int: ...
    def ReadAllColorScalarsOff(self) -> None: ...
    def ReadAllColorScalarsOn(self) -> None: ...
    def ReadAllFieldsOff(self) -> None: ...
    def ReadAllFieldsOn(self) -> None: ...
    def ReadAllNormalsOff(self) -> None: ...
    def ReadAllNormalsOn(self) -> None: ...
    def ReadAllScalarsOff(self) -> None: ...
    def ReadAllScalarsOn(self) -> None: ...
    def ReadAllTCoordsOff(self) -> None: ...
    def ReadAllTCoordsOn(self) -> None: ...
    def ReadAllTensorsOff(self) -> None: ...
    def ReadAllTensorsOn(self) -> None: ...
    def ReadAllVectorsOff(self) -> None: ...
    def ReadAllVectorsOn(self) -> None: ...
    def ReadArray(self, dataType:str, numTuples:int, numComp:int) -> 'vtkAbstractArray': ...
    def ReadArrays(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkDataObject') -> int: ...
    def ReadArraysSimple(self, __a:str, __b:'vtkDataObject') -> int: ...
    def ReadCellData(self, ds:'vtkDataSet', numCells:int) -> int: ...
    def ReadCells(self, cellArray:'vtkCellArray') -> int: ...
    @overload
    def ReadCellsLegacy(self, size:int, data:MutableSequence[int]) -> int: ...
    @overload
    def ReadCellsLegacy(self, size:int, data:MutableSequence[int], skip1:int, read2:int, skip3:int) -> int: ...
    def ReadCoordinates(self, rg:'vtkRectilinearGrid', axes:int, numCoords:int) -> int: ...
    def ReadEdgeData(self, g:'vtkGraph', numEdges:int) -> int: ...
    def ReadFieldData(self, fieldType:'FieldType'=...) -> 'vtkFieldData': ...
    def ReadFromInputStringOff(self) -> None: ...
    def ReadFromInputStringOn(self) -> None: ...
    def ReadHeader(self, fname:str=...) -> int: ...
    def ReadLine(self, result:MutableSequence[str]) -> int: ...
    def ReadMesh(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadMeshSimple(self, __a:str, __b:'vtkDataObject') -> int: ...
    @overload
    def ReadPointCoordinates(self, ps:'vtkPointSet', numPts:int) -> int: ...
    @overload
    def ReadPointCoordinates(self, g:'vtkGraph', numPts:int) -> int: ...
    def ReadPointData(self, ds:'vtkDataSet', numPts:int) -> int: ...
    def ReadPoints(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkDataObject') -> int: ...
    def ReadPointsSimple(self, __a:str, __b:'vtkDataObject') -> int: ...
    def ReadRowData(self, t:'vtkTable', numEdges:int) -> int: ...
    def ReadString(self, result:MutableSequence[str]) -> int: ...
    def ReadTimeDependentMetaData(self, timestep:int, metadata:'vtkInformation') -> int: ...
    def ReadVertexData(self, g:'vtkGraph', numVertices:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataReader': ...
    def SetBinaryInputString(self, __a:str, len:int) -> None: ...
    def SetFieldDataName(self, _arg:str) -> None: ...
    def SetFileName(self, fname:str) -> None: ...
    def SetInputArray(self, __a:'vtkCharArray') -> None: ...
    @overload
    def SetInputString(self, in_:str, len:int) -> None: ...
    @overload
    def SetInputString(self, input:str) -> None: ...
    def SetLookupTableName(self, _arg:str) -> None: ...
    def SetNormalsName(self, _arg:str) -> None: ...
    def SetReadAllColorScalars(self, _arg:int) -> None: ...
    def SetReadAllFields(self, _arg:int) -> None: ...
    def SetReadAllNormals(self, _arg:int) -> None: ...
    def SetReadAllScalars(self, _arg:int) -> None: ...
    def SetReadAllTCoords(self, _arg:int) -> None: ...
    def SetReadAllTensors(self, _arg:int) -> None: ...
    def SetReadAllVectors(self, _arg:int) -> None: ...
    def SetReadFromInputString(self, _arg:int) -> None: ...
    def SetScalarsName(self, _arg:str) -> None: ...
    def SetTCoordsName(self, _arg:str) -> None: ...
    def SetTensorsName(self, _arg:str) -> None: ...
    def SetVectorsName(self, _arg:str) -> None: ...

class vtkCompositeDataReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkCompositeDataSet': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkCompositeDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataReader': ...
    def SetOutput(self, output:'vtkCompositeDataSet') -> None: ...

class vtkDataWriter(vtkmodules.vtkIOCore.vtkWriter):
    class VTKFileVersion(int): ...
    VTK_LEGACY_READER_VERSION_4_2:'VTKFileVersion'
    VTK_LEGACY_READER_VERSION_5_1:'VTKFileVersion'
    binary_output_string:'getset_descriptor'
    edge_flags_name:'getset_descriptor'
    field_data_name:'getset_descriptor'
    file_major_version:'getset_descriptor'
    file_minor_version:'getset_descriptor'
    file_name:'getset_descriptor'
    file_type:'getset_descriptor'
    file_version:'getset_descriptor'
    global_ids_name:'getset_descriptor'
    header:'getset_descriptor'
    lookup_table_name:'getset_descriptor'
    normals_name:'getset_descriptor'
    output_std_string:'getset_descriptor'
    output_string:'getset_descriptor'
    output_string_length:'getset_descriptor'
    pedigree_ids_name:'getset_descriptor'
    scalars_name:'getset_descriptor'
    t_coords_name:'getset_descriptor'
    tensors_name:'getset_descriptor'
    vectors_name:'getset_descriptor'
    write_array_meta_data:'getset_descriptor'
    write_to_output_string:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBinaryOutputString(self) -> Pointer: ...
    def GetEdgeFlagsName(self) -> str: ...
    def GetFieldDataName(self) -> str: ...
    def GetFileMajorVersion(self) -> int: ...
    def GetFileMinorVersion(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetFileType(self) -> int: ...
    def GetFileTypeMaxValue(self) -> int: ...
    def GetFileTypeMinValue(self) -> int: ...
    def GetFileVersion(self) -> int: ...
    def GetGlobalIdsName(self) -> str: ...
    def GetHeader(self) -> str: ...
    def GetLookupTableName(self) -> str: ...
    def GetNormalsName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputStdString(self) -> str: ...
    def GetOutputString(self) -> str: ...
    def GetOutputStringLength(self) -> int: ...
    def GetPedigreeIdsName(self) -> str: ...
    def GetScalarsName(self) -> str: ...
    def GetTCoordsName(self) -> str: ...
    def GetTensorsName(self) -> str: ...
    def GetVectorsName(self) -> str: ...
    def GetWriteArrayMetaData(self) -> bool: ...
    def GetWriteToOutputString(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataWriter': ...
    def RegisterAndGetOutputString(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataWriter': ...
    def SetEdgeFlagsName(self, _arg:str) -> None: ...
    def SetFieldDataName(self, _arg:str) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetFileType(self, _arg:int) -> None: ...
    def SetFileTypeToASCII(self) -> None: ...
    def SetFileTypeToBinary(self) -> None: ...
    def SetFileVersion(self, __a:int) -> None: ...
    def SetGlobalIdsName(self, _arg:str) -> None: ...
    def SetHeader(self, _arg:str) -> None: ...
    def SetLookupTableName(self, _arg:str) -> None: ...
    def SetNormalsName(self, _arg:str) -> None: ...
    def SetPedigreeIdsName(self, _arg:str) -> None: ...
    def SetScalarsName(self, _arg:str) -> None: ...
    def SetTCoordsName(self, _arg:str) -> None: ...
    def SetTensorsName(self, _arg:str) -> None: ...
    def SetVectorsName(self, _arg:str) -> None: ...
    def SetWriteArrayMetaData(self, _arg:bool) -> None: ...
    def SetWriteToOutputString(self, _arg:int) -> None: ...
    def WriteArrayMetaDataOff(self) -> None: ...
    def WriteArrayMetaDataOn(self) -> None: ...
    def WriteToOutputStringOff(self) -> None: ...
    def WriteToOutputStringOn(self) -> None: ...

class vtkCompositeDataWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkCompositeDataSet': ...
    @overload
    def GetInput(self, port:int) -> 'vtkCompositeDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataWriter': ...

class vtkDataObjectReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectReader': ...
    def SetOutput(self, __a:'vtkDataObject') -> None: ...

class vtkDataObjectWriter(vtkmodules.vtkIOCore.vtkWriter):
    binary_output_string:'getset_descriptor'
    field_data_name:'getset_descriptor'
    file_name:'getset_descriptor'
    file_type:'getset_descriptor'
    header:'getset_descriptor'
    output_std_string:'getset_descriptor'
    output_string:'getset_descriptor'
    output_string_length:'getset_descriptor'
    write_to_output_string:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBinaryOutputString(self) -> Pointer: ...
    def GetFieldDataName(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetFileType(self) -> int: ...
    def GetHeader(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputStdString(self) -> str: ...
    def GetOutputString(self) -> str: ...
    def GetOutputStringLength(self) -> int: ...
    def GetWriteToOutputString(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectWriter': ...
    def SetFieldDataName(self, fieldname:str) -> None: ...
    def SetFileName(self, filename:str) -> None: ...
    def SetFileType(self, type:int) -> None: ...
    def SetFileTypeToASCII(self) -> None: ...
    def SetFileTypeToBinary(self) -> None: ...
    def SetHeader(self, header:str) -> None: ...
    def SetWriteToOutputString(self, b:int) -> None: ...
    def WriteToOutputStringOff(self) -> None: ...
    def WriteToOutputStringOn(self) -> None: ...

class vtkDataSetReader(vtkDataReader):
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    rectilinear_grid_output:'getset_descriptor'
    structured_grid_output:'getset_descriptor'
    structured_points_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataSet': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkDataSet': ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetRectilinearGridOutput(self) -> 'vtkRectilinearGrid': ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMetaDataSimple(self, fname:str, metadata:'vtkInformation') -> int: ...
    def ReadOutputType(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetReader': ...

class vtkDataSetWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataSet': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetWriter': ...

class vtkGenericDataObjectReader(vtkDataReader):
    cell_grid_output:'getset_descriptor'
    graph_output:'getset_descriptor'
    molecule_output:'getset_descriptor'
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    rectilinear_grid_output:'getset_descriptor'
    structured_grid_output:'getset_descriptor'
    structured_points_output:'getset_descriptor'
    table_output:'getset_descriptor'
    tree_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellGridOutput(self) -> 'vtkCellGrid': ...
    def GetGraphOutput(self) -> 'vtkGraph': ...
    def GetMoleculeOutput(self) -> 'vtkMolecule': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkDataObject': ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetRectilinearGridOutput(self) -> 'vtkRectilinearGrid': ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetTableOutput(self) -> 'vtkTable': ...
    def GetTreeOutput(self) -> 'vtkTree': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericDataObjectReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMetaDataSimple(self, fname:str, metadata:'vtkInformation') -> int: ...
    def ReadOutputType(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataObjectReader': ...

class vtkGenericDataObjectWriter(vtkDataWriter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericDataObjectWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataObjectWriter': ...

class vtkGraphReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkGraph': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkGraph': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphReader': ...

class vtkGraphWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkGraph': ...
    @overload
    def GetInput(self, port:int) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphWriter': ...

class vtkLegacyCellGridReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkCellGrid': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkCellGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLegacyCellGridReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLegacyCellGridReader': ...
    def SetOutput(self, output:'vtkCellGrid') -> None: ...

class vtkLegacyCellGridWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkCellGrid': ...
    @overload
    def GetInput(self, port:int) -> 'vtkCellGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLegacyCellGridWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLegacyCellGridWriter': ...

class vtkPixelExtentIO(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkPixelExtentIO') -> None: ...
    @staticmethod
    def Write(commRank:int, fileName:str, ext:'vtkPixelExtent') -> None: ...

class vtkPolyDataReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkPolyData': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataReader': ...
    def SetOutput(self, output:'vtkPolyData') -> None: ...

class vtkPolyDataWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkPolyData': ...
    @overload
    def GetInput(self, port:int) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataWriter': ...

class vtkRectilinearGridReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkRectilinearGrid': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkRectilinearGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMetaDataSimple(self, fname:str, metadata:'vtkInformation') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridReader': ...
    def SetOutput(self, output:'vtkRectilinearGrid') -> None: ...

class vtkRectilinearGridWriter(vtkDataWriter):
    input:'getset_descriptor'
    write_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkRectilinearGrid': ...
    @overload
    def GetInput(self, port:int) -> 'vtkRectilinearGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWriteExtent(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridWriter': ...
    def SetWriteExtent(self, _arg:bool) -> None: ...
    def WriteExtentOff(self) -> None: ...
    def WriteExtentOn(self) -> None: ...

class vtkSimplePointsReader(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    file_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimplePointsReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimplePointsReader': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkSimplePointsWriter(vtkDataSetWriter):
    decimal_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDecimalPrecision(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimplePointsWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimplePointsWriter': ...
    def SetDecimalPrecision(self, _arg:int) -> None: ...

class vtkStructuredGridReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkStructuredGrid': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkStructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMetaDataSimple(self, fname:str, metadata:'vtkInformation') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridReader': ...
    def SetOutput(self, output:'vtkStructuredGrid') -> None: ...

class vtkStructuredGridWriter(vtkDataWriter):
    input:'getset_descriptor'
    write_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkStructuredGrid': ...
    @overload
    def GetInput(self, port:int) -> 'vtkStructuredGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWriteExtent(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridWriter': ...
    def SetWriteExtent(self, _arg:bool) -> None: ...
    def WriteExtentOff(self) -> None: ...
    def WriteExtentOn(self) -> None: ...

class vtkStructuredPointsReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkStructuredPoints': ...
    @overload
    def GetOutput(self) -> 'vtkStructuredPoints': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredPointsReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMetaDataSimple(self, fname:str, metadata:'vtkInformation') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredPointsReader': ...
    def SetOutput(self, output:'vtkStructuredPoints') -> None: ...

class vtkStructuredPointsWriter(vtkDataWriter):
    input:'getset_descriptor'
    write_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkImageData': ...
    @overload
    def GetInput(self, port:int) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWriteExtent(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredPointsWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredPointsWriter': ...
    def SetWriteExtent(self, _arg:bool) -> None: ...
    def WriteExtentOff(self) -> None: ...
    def WriteExtentOn(self) -> None: ...

class vtkTableReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkTable': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkTable': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableReader': ...
    def SetOutput(self, output:'vtkTable') -> None: ...

class vtkTableWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkTable': ...
    @overload
    def GetInput(self, port:int) -> 'vtkTable': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableWriter': ...

class vtkTreeReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkTree': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkTree': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeReader': ...
    def SetOutput(self, output:'vtkTree') -> None: ...

class vtkTreeWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkTree': ...
    @overload
    def GetInput(self, port:int) -> 'vtkTree': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeWriter': ...

class vtkUnstructuredGridReader(vtkDataReader):
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkUnstructuredGrid': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridReader': ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridReader': ...
    def SetOutput(self, output:'vtkUnstructuredGrid') -> None: ...

class vtkUnstructuredGridWriter(vtkDataWriter):
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetInput(self) -> 'vtkUnstructuredGridBase': ...
    @overload
    def GetInput(self, port:int) -> 'vtkUnstructuredGridBase': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridWriter': ...

