from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkXdmf3ArrayKeeper(object):
    def __init__(self) -> None: ...
    def BumpGeneration(self) -> None: ...
    def Release(self, force:bool) -> None: ...

class vtkXdmf3ArraySelection(object):
    number_of_arrays:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkXdmf3ArraySelection') -> None: ...
    def AddArray(self, name:str, status:bool=True) -> None: ...
    def ArrayIsEnabled(self, name:str) -> bool: ...
    def GetArrayName(self, index:int) -> str: ...
    def GetArraySetting(self, name:str) -> int: ...
    def GetNumberOfArrays(self) -> int: ...
    def HasArray(self, name:str) -> bool: ...
    def Merge(self, other:'vtkXdmf3ArraySelection') -> None: ...
    def SetArrayStatus(self, name:str, status:bool) -> None: ...

class vtkXdmf3DataSet(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkXdmf3DataSet') -> None: ...
    @staticmethod
    def GetNumberOfPointsPerCell(vtk_cell_type:int, fail:bool) -> int: ...
    @staticmethod
    def GetXdmfCellType(vtkType:int) -> int: ...

class vtkXdmf3HeavyDataHandler(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkXdmf3HeavyDataHandler') -> None: ...

class vtkXdmf3LightDataHandler(object):
    def __init__(self, __a:'vtkXdmf3LightDataHandler') -> None: ...

class vtkXdmf3Reader(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    file_name:'getset_descriptor'
    file_series_as_time:'getset_descriptor'
    number_of_cell_arrays:'getset_descriptor'
    number_of_field_arrays:'getset_descriptor'
    number_of_grids:'getset_descriptor'
    number_of_point_arrays:'getset_descriptor'
    number_of_set_arrays:'getset_descriptor'
    number_of_sets:'getset_descriptor'
    sil:'getset_descriptor'
    sil_update_stamp:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddFileName(self, filename:str) -> None: ...
    def CanReadFile(self, filename:str) -> int: ...
    def GetCellArrayName(self, index:int) -> str: ...
    def GetCellArrayStatus(self, name:str) -> int: ...
    def GetFieldArrayName(self, index:int) -> str: ...
    def GetFieldArrayStatus(self, name:str) -> int: ...
    def GetFileSeriesAsTime(self) -> bool: ...
    def GetGridName(self, index:int) -> str: ...
    def GetGridStatus(self, gridname:str) -> int: ...
    def GetNumberOfCellArrays(self) -> int: ...
    def GetNumberOfFieldArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGrids(self) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetNumberOfSetArrays(self) -> int: ...
    def GetNumberOfSets(self) -> int: ...
    def GetPointArrayName(self, index:int) -> str: ...
    def GetPointArrayStatus(self, name:str) -> int: ...
    def GetSIL(self) -> 'vtkGraph': ...
    def GetSILUpdateStamp(self) -> int: ...
    def GetSetArrayName(self, index:int) -> str: ...
    def GetSetArrayStatus(self, name:str) -> int: ...
    def GetSetName(self, index:int) -> str: ...
    def GetSetStatus(self, gridname:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkXdmf3Reader': ...
    def RemoveAllFileNames(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXdmf3Reader': ...
    def SetCellArrayStatus(self, name:str, status:int) -> None: ...
    def SetFieldArrayStatus(self, name:str, status:int) -> None: ...
    def SetFileName(self, filename:str) -> None: ...
    def SetFileSeriesAsTime(self, _arg:bool) -> None: ...
    def SetGridStatus(self, gridname:str, status:int) -> None: ...
    def SetPointArrayStatus(self, name:str, status:int) -> None: ...
    def SetSetStatus(self, gridname:str, status:int) -> None: ...

class vtkXdmf3SILBuilder(object):
    blocks_root:'getset_descriptor'
    hierarchy_root:'getset_descriptor'
    root_vertex:'getset_descriptor'
    def __init__(self) -> None: ...
    def AddChildEdge(self, parent:int, child:int) -> int: ...
    def AddCrossEdge(self, src:int, dst:int) -> int: ...
    def AddVertex(self, name:str) -> int: ...
    def GetBlocksRoot(self) -> int: ...
    def GetHierarchyRoot(self) -> int: ...
    def GetRootVertex(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsMaxedOut(self) -> bool: ...

class vtkXdmf3Writer(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    file_name:'getset_descriptor'
    ghost_level:'getset_descriptor'
    input_data:'getset_descriptor'
    light_data_limit:'getset_descriptor'
    write_all_time_steps:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFileName(self) -> str: ...
    def GetGhostLevel(self) -> int: ...
    def GetLightDataLimit(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWriteAllTimeSteps(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkXdmf3Writer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXdmf3Writer': ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetGhostLevel(self, __a:int) -> None: ...
    def SetInputData(self, dobj:'vtkDataObject') -> None: ...
    def SetLightDataLimit(self, _arg:int) -> None: ...
    def SetWriteAllTimeSteps(self, _arg:bool) -> None: ...
    def Write(self) -> int: ...
    def WriteAllTimeStepsOff(self) -> None: ...
    def WriteAllTimeStepsOn(self) -> None: ...

