from enum import Enum

CONDA_CMD_TIMEOUT = 20 * 60  # 20 minutes


class EnvironmentStatus(str, Enum):
    INSTALLED = "installed"
    NOT_INSTALLED = "not_installed"


class StaticEnvironmentNames(str, Enum):
    DATA_SCIENCE_STARTER = "data-science-starter"
    DATA_SCIENCE_FOR_PROS = "data-science-for-pros"
    DATA_VISUALIZATION_KIT = "data-visualization-kit"


class EnvManagementActions(str, Enum):
    INSTALL = "install"
    REMOVE = "remove"


class ProcessResult(str, Enum):
    SUCCEEDED = "succeeded"
    FAILED = "failed"


CONDA_KERNEL_SPEC_PREFIX = "conda-env-"
WINDOWS_STORAGE_DRIVER = "C:"
