import pytest
from aext_project_filebrowser_server.consts import FileOperations
from aext_project_filebrowser_server.services.local_storage import FileOperationsDict


class TestDiffFileOperations:
    def setup_method(self):
        self.operations_dict = FileOperationsDict(
            {
                "a.txt": FileOperations.LOCAL_DELETE,
                "b.txt": FileOperations.LOCAL_WRITE,
                "c.txt": FileOperations.CLOUD_DELETE,
                "d.txt": FileOperations.CLOUD_WRITE,
            }
        )

    def test_filter_by_operation_type(self):
        ops_and_expected = zip(list(FileOperations), ["a.txt", "b.txt", "c.txt", "d.txt"])
        for operation, expected in ops_and_expected:
            assert len(self.operations_dict.filter_by_operation_type(operation)) == 1
            assert expected in self.operations_dict.filter_by_operation_type(operation)

    def test_filter_local_operations(self):
        expected = {"a.txt", "b.txt"}
        assert len(self.operations_dict.filter_local_operations()) == 2
        assert expected - set(self.operations_dict.filter_local_operations()) == set()

    def test_filter_cloud_operations(self):
        expected = {"a.txt", "b.txt"}
        assert len(self.operations_dict.filter_cloud_operations()) == 2
        assert expected - set(self.operations_dict.filter_local_operations()) == set()
