import os

from aext_project_filebrowser_server import logger as custom_logger
from aext_project_filebrowser_server.consts import (
    IS_CLOUD_ENVIRONMENT,
    PROJECTS_FILES_DIR,
    TARGET_PROJECTS_SYMLINK,
)
from aext_project_filebrowser_server.utils import is_github_actions_runner

logger = custom_logger.logger


def project_configure():
    logger.info(f"Checking project configuration: {os.getcwd()}. Running chdir...")
    try:
        if not is_github_actions_runner():
            init_project_symlink()
            init_project_folder()
        else:
            message = "Skipping project configuration..."
            logger.info(message)
            print(message)
    except Exception as ex:
        message = f"Error running project configuration {ex}"
        logger.exception(message)
        print(message)
        raise


def init_project_symlink():
    def create_symlink_if_not_exists(target_path, src_path):
        try:
            if not os.path.islink(target_path):
                os.symlink(src_path, target_path)
            else:
                message = "Skipping project folder creation..."
                logger.info(message)
                print(message)

        except OSError:
            message = "Failed to create the project symlink file"
            logger.exception(message)
            print(message)
            return

    if IS_CLOUD_ENVIRONMENT:
        # This means it is running on PythonAnywhere environment
        sym_link_target_path = TARGET_PROJECTS_SYMLINK
        sym_link_src_path = PROJECTS_FILES_DIR
        create_symlink_if_not_exists(sym_link_target_path, sym_link_src_path)


def init_project_folder():
    def create_project_folder_if_not_exists(src_path):
        logger.debug(f"Projects folder configured at {src_path}")
        try:
            if not os.path.isdir(src_path):
                os.makedirs(src_path, exist_ok=True)
        except OSError:
            message = "Failed to create project's folder"
            logger.exception(message)
            return

    src_path = PROJECTS_FILES_DIR

    create_project_folder_if_not_exists(src_path)
