class ProjectNameConflict(Exception):
    """
    Exception raised whenever a Project conflict is found
    """

    def __init__(self, message="A project with the same name already exists"):
        self.message = message
        super().__init__(self.message)


class ProjectFailCreate(Exception):
    """Exception raised whenever a Project is not possible to create.
    Reasons: project duplicated or other errors
    """

    def __init__(self, message="Project not possible to be created"):
        self.message = message
        super().__init__(self.message)


class ProjectFailDelete(Exception):
    """Exception raised whenever a Project is not possible to remove.
    Reasons: project not found or other errors
    """

    def __init__(self, message="Project not possible to be deleted"):
        self.message = message
        super().__init__(self.message)


class ProjectFailList(Exception):
    """Exception raised whenever a Project is not possible to list.
    Reasons: Error connection
    """

    def __init__(self, message="Project not possible to be listed"):
        self.message = message
        super().__init__(self.message)


class LocalProjectNotFoundError(Exception):
    """Exception raised whenever a Project is not found in the local database"""

    def __init__(self, message="Local project not found"):
        self.message = message
        super().__init__(self.message)


class AddFileErrorOnLocalStorage(Exception):
    """Exception raised whenever a file cannot be saved in the local storage"""

    def __init__(self, message="File not possible to be added to the local storage"):
        self.message = message
        super().__init__(self.message)


class AddFileErrorOnDatabase(Exception):
    """Exception raised whenever a file cannot be saved in the local database"""

    def __init__(self, message="File not possible to be added to the local database"):
        self.message = message
        super().__init__(self.message)


class CloudProjectNotFoundError(Exception):
    """Exception raised whenever a Project is not found on the cloud"""

    def __init__(self, message="Cloud project not found"):
        self.message = message
        super().__init__(self.message)


class CloudProjectNameAlreadyExistsError(Exception):
    """Exception raised whenever a Project name conflicts with another one on the cloud"""

    def __init__(self, message="Cloud project name is not unique"):
        self.message = message
        super().__init__(self.message)


class CloudProjectFileTreeError(Exception):
    """Exception raised whenever a Project's filetree cannot be retrieved from the cloud"""

    def __init__(self, message="Cannot retrieve cloud project filetree"):
        self.message = message
        super().__init__(self.message)


class CloudProjectFileListError(Exception):
    """Exception raised whenever a Project's file list cannot be retrieved from the cloud"""

    def __init__(self, message="Cannot retrieve cloud project file list"):
        self.message = message
        super().__init__(self.message)


class LocalFileNotFound(Exception):
    """Exception raised whenever a Project's file cannot be found in the local storage"""

    def __init__(self, message="Cannot find local file"):
        self.message = message
        super().__init__(self.message)


class LocalFilePermissionError(Exception):
    """Exception raised whenever a Project's file cannot be manipulated due to permission errors"""

    def __init__(self, message="File permission error"):
        self.message = message
        super().__init__(self.message)


class LocalFileAlreadyExists(Exception):
    """Exception raised whenever a Project file already exist"""

    def __init__(self, message="File already exists"):
        self.message = message
        super().__init__(self.message)


class FailedToStartSyncPull(Exception):
    """Exception raised when there is a failure while starting the sync pull process"""

    def __init__(self, message="Failed to start pull process"):
        self.message = message
        super().__init__(self.message)


class CloudProjectUpdatePayloadError(Exception):
    """Exception raised whenever an invalid payload is used to update a project on the cloud"""

    def __init__(self, message="Invalid payload used to update a project on the cloud"):
        self.message = message
        super().__init__(self.message)


class ProjectFolderNotFound(Exception):
    """Exception raised whenever a Project's folder cannot be found in the local storage"""

    def __init__(self, message="Cannot find project folder"):
        self.message = message
        super().__init__(self.message)


class AddProjectFilesError(Exception):
    """Exception raised whenever not possible to add files to a Project"""

    def __init__(self, message="Not possible to add files to a Project"):
        self.message = message
        super().__init__(self.message)


class FailedToCopyProjectFiles(Exception):
    """Exception raised whenever not possible to copy files to a Project"""

    def __init__(self, message="Not possible to copy files to a Project"):
        self.message = message
        super().__init__(self.message)


class DatabaseCursorError(Exception):
    """Exception raised whenever a DB query fails to run"""

    def __init__(self, message="Not able to execute query"):
        self.message = message
        super().__init__(self.message)


class FailedToInstantiateSchema(Exception):
    """Exception raised whenever schema can't be instantiated"""

    def __init__(self, message="Not able to instantiate schema class"):
        self.message = message
        super().__init__(self.message)


class UserDoesNotBelongToOrganization(Exception):
    """Exception raised when a user does not belong to the subjected organization"""

    def __init__(self, message="User does note belong to organization"):
        self.message = message
        super().__init__(self.message)


class ListUserPermissionsError(Exception):
    """Exception raised when is not possible to list user's permissions"""

    def __init__(self, message="Can't list user's permissions"):
        self.message = message
        super().__init__(self.message)


class CodeSnippetsSchemaError(Exception):
    """Exception raised whenever the code snippet schema"""

    def __init__(self, message="Snippet schema is not valid"):
        self.message = message
        super().__init__(self.message)


class AlembicConfigNotFound(Exception):
    """Exception raised whenever an Alembic config can not be found"""

    def __init__(self, message="Alembic config not found for the current environment"):
        self.message = message
        super().__init__(self.message)


class AlembicConfigDBPropertyNotFound(Exception):
    """Exception raised whenever an Alembic config property can not be found"""

    def __init__(self, message="Alembic configuration set for this environment doesn't have the desired property"):
        self.message = message
        super().__init__(self.message)


class ServerInformationMissingError(Exception):
    """Exception raised whenever the server configuration information is missing"""

    def __init__(self, message="Server configuration information is missing"):
        self.message = message
        super().__init__(self.message)
