import json
from dataclasses import asdict, dataclass
from typing import Any, List, Optional

from aext_project_filebrowser_server.consts import WebsocketMessages
from aext_project_filebrowser_server.schemas.local_project import LocalProject


@dataclass
class WebSocketResponse:
    http_status: int
    http_message: Optional[str] = None
    message: Optional[WebsocketMessages] = None
    data: Optional[Any] = None

    def to_dict(self) -> dict:
        return asdict(self)

    def to_json(self) -> str:
        return json.dumps(self.to_dict())
