import sys
import unittest

import pytest

from .fixtures import setup_database, tear_down_database

pytestmark = pytest.mark.skipif(sys.platform.startswith("win"), reason="Skipping tests on Windows")


class DatabaseTestCase(unittest.TestCase):
    def setUp(self):
        print("Setting up test...")
        self.db = setup_database()

    def tearDown(self):
        print("Tearing down test...")
        tear_down_database()

    def test_insert_projects(self):
        self.db.execute(
            """
            INSERT INTO projects (id, data, owner, name) VALUES
            (1, '{"key1": "value1", "key2": "value2"}', 'John Doe', 'Project A'),
            (2, '{"key1": "value3", "key2": "value4"}', 'Jane Smith', 'Project B'),
            (3, '{"key1": "value5", "key2": "value6"}', 'Alice Johnson', 'Project C');
        """
        )
        self.db.execute("""SELECT * FROM projects;""")
        self.assertEqual(len(self.db.fetchall()), 3)

    def test_autocommit_off(self):
        self.db.execute(
            """
            INSERT INTO projects (id, data, owner, name) VALUES
            (1, '{"key1": "value1", "key2": "value2"}', 'John Doe', 'Project A'),
            (2, '{"key1": "value3", "key2": "value4"}', 'Jane Smith', 'Project B'),
            (3, '{"key1": "value5", "key2": "value6"}', 'Alice Johnson', 'Project C');
            """,
            auto_commit=False,
        )
        self.assertEqual(len(self.db.fetchall()), 0)
