"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filepurpose import FilePurpose
from .sampletype import SampleType
from .source import Source
from mistralai.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mistralai.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class RetrieveFileOutTypedDict(TypedDict):
    id: str
    r"""The unique identifier of the file."""
    object: str
    r"""The object type, which is always \"file\"."""
    size_bytes: int
    r"""The size of the file, in bytes."""
    created_at: int
    r"""The UNIX timestamp (in seconds) of the event."""
    filename: str
    r"""The name of the uploaded file."""
    purpose: FilePurpose
    sample_type: SampleType
    source: Source
    deleted: bool
    num_lines: NotRequired[Nullable[int]]
    mimetype: NotRequired[Nullable[str]]
    signature: NotRequired[Nullable[str]]


class RetrieveFileOut(BaseModel):
    id: str
    r"""The unique identifier of the file."""

    object: str
    r"""The object type, which is always \"file\"."""

    size_bytes: Annotated[int, pydantic.Field(alias="bytes")]
    r"""The size of the file, in bytes."""

    created_at: int
    r"""The UNIX timestamp (in seconds) of the event."""

    filename: str
    r"""The name of the uploaded file."""

    purpose: Annotated[FilePurpose, PlainValidator(validate_open_enum(False))]

    sample_type: Annotated[SampleType, PlainValidator(validate_open_enum(False))]

    source: Annotated[Source, PlainValidator(validate_open_enum(False))]

    deleted: bool

    num_lines: OptionalNullable[int] = UNSET

    mimetype: OptionalNullable[str] = UNSET

    signature: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["num_lines", "mimetype", "signature"]
        nullable_fields = ["num_lines", "mimetype", "signature"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
