"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mistralai import models, utils
from mistralai._hooks import HookContext
from mistralai.types import OptionalNullable, UNSET
from mistralai.utils import eventstreaming, get_security_from_env
from mistralai.utils.unmarshal_json_response import unmarshal_json_response
from typing import List, Mapping, Optional, Union


class Transcriptions(BaseSDK):
    r"""API for audio transcription."""

    def complete(
        self,
        *,
        model: str,
        file: Optional[Union[models.File, models.FileTypedDict]] = None,
        file_url: OptionalNullable[str] = UNSET,
        file_id: OptionalNullable[str] = UNSET,
        language: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        timestamp_granularities: Optional[List[models.TimestampGranularity]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TranscriptionResponse:
        r"""Create Transcription

        :param model:
        :param file:
        :param file_url: Url of a file to be transcribed
        :param file_id: ID of a file uploaded to /v1/files
        :param language: Language of the audio, e.g. 'en'. Providing the language can boost accuracy.
        :param temperature:
        :param timestamp_granularities: Granularities of timestamps to include in the response.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AudioTranscriptionRequest(
            model=model,
            file=utils.get_pydantic_model(file, Optional[models.File]),
            file_url=file_url,
            file_id=file_id,
            language=language,
            temperature=temperature,
            timestamp_granularities=timestamp_granularities,
        )

        req = self._build_request(
            method="POST",
            path="/v1/audio/transcriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "multipart", models.AudioTranscriptionRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="audio_api_v1_transcriptions_post",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TranscriptionResponse, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    async def complete_async(
        self,
        *,
        model: str,
        file: Optional[Union[models.File, models.FileTypedDict]] = None,
        file_url: OptionalNullable[str] = UNSET,
        file_id: OptionalNullable[str] = UNSET,
        language: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        timestamp_granularities: Optional[List[models.TimestampGranularity]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TranscriptionResponse:
        r"""Create Transcription

        :param model:
        :param file:
        :param file_url: Url of a file to be transcribed
        :param file_id: ID of a file uploaded to /v1/files
        :param language: Language of the audio, e.g. 'en'. Providing the language can boost accuracy.
        :param temperature:
        :param timestamp_granularities: Granularities of timestamps to include in the response.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AudioTranscriptionRequest(
            model=model,
            file=utils.get_pydantic_model(file, Optional[models.File]),
            file_url=file_url,
            file_id=file_id,
            language=language,
            temperature=temperature,
            timestamp_granularities=timestamp_granularities,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/audio/transcriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "multipart", models.AudioTranscriptionRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="audio_api_v1_transcriptions_post",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TranscriptionResponse, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    def stream(
        self,
        *,
        model: str,
        file: Optional[Union[models.File, models.FileTypedDict]] = None,
        file_url: OptionalNullable[str] = UNSET,
        file_id: OptionalNullable[str] = UNSET,
        language: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        timestamp_granularities: Optional[List[models.TimestampGranularity]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStream[models.TranscriptionStreamEvents]:
        r"""Create streaming transcription (SSE)

        :param model:
        :param file:
        :param file_url: Url of a file to be transcribed
        :param file_id: ID of a file uploaded to /v1/files
        :param language: Language of the audio, e.g. 'en'. Providing the language can boost accuracy.
        :param temperature:
        :param timestamp_granularities: Granularities of timestamps to include in the response.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AudioTranscriptionRequestStream(
            model=model,
            file=utils.get_pydantic_model(file, Optional[models.File]),
            file_url=file_url,
            file_id=file_id,
            language=language,
            temperature=temperature,
            timestamp_granularities=timestamp_granularities,
        )

        req = self._build_request(
            method="POST",
            path="/v1/audio/transcriptions#stream",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "multipart",
                models.AudioTranscriptionRequestStream,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="audio_api_v1_transcriptions_post_stream",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStream(
                http_res,
                lambda raw: utils.unmarshal_json(raw, models.TranscriptionStreamEvents),
                client_ref=self,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        http_res_text = utils.stream_to_text(http_res)
        raise models.SDKError("Unexpected response received", http_res, http_res_text)

    async def stream_async(
        self,
        *,
        model: str,
        file: Optional[Union[models.File, models.FileTypedDict]] = None,
        file_url: OptionalNullable[str] = UNSET,
        file_id: OptionalNullable[str] = UNSET,
        language: OptionalNullable[str] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        timestamp_granularities: Optional[List[models.TimestampGranularity]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStreamAsync[models.TranscriptionStreamEvents]:
        r"""Create streaming transcription (SSE)

        :param model:
        :param file:
        :param file_url: Url of a file to be transcribed
        :param file_id: ID of a file uploaded to /v1/files
        :param language: Language of the audio, e.g. 'en'. Providing the language can boost accuracy.
        :param temperature:
        :param timestamp_granularities: Granularities of timestamps to include in the response.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AudioTranscriptionRequestStream(
            model=model,
            file=utils.get_pydantic_model(file, Optional[models.File]),
            file_url=file_url,
            file_id=file_id,
            language=language,
            temperature=temperature,
            timestamp_granularities=timestamp_granularities,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/audio/transcriptions#stream",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "multipart",
                models.AudioTranscriptionRequestStream,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="audio_api_v1_transcriptions_post_stream",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStreamAsync(
                http_res,
                lambda raw: utils.unmarshal_json(raw, models.TranscriptionStreamEvents),
                client_ref=self,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.SDKError("Unexpected response received", http_res, http_res_text)
