# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from ...._models import BaseModel
from .conversation_item import ConversationItem
from .realtime_response_usage import RealtimeResponseUsage
from .realtime_response_status import RealtimeResponseStatus

__all__ = ["RealtimeResponse"]


class RealtimeResponse(BaseModel):
    id: Optional[str] = None
    """The unique ID of the response."""

    metadata: Optional[object] = None
    """Developer-provided string key-value pairs associated with this response."""

    object: Optional[Literal["realtime.response"]] = None
    """The object type, must be `realtime.response`."""

    output: Optional[List[ConversationItem]] = None
    """The list of output items generated by the response."""

    status: Optional[Literal["completed", "cancelled", "failed", "incomplete"]] = None
    """
    The final status of the response (`completed`, `cancelled`, `failed`, or
    `incomplete`).
    """

    status_details: Optional[RealtimeResponseStatus] = None
    """Additional details about the status."""

    usage: Optional[RealtimeResponseUsage] = None
    """Usage statistics for the Response, this will correspond to billing.

    A Realtime API session will maintain a conversation context and append new Items
    to the Conversation, thus output from previous turns (text and audio tokens)
    will become the input for later turns.
    """
