from collections.abc import Sequence

import numpy as np
from pandas.core.arrays.base import (
    ExtensionArray,
    ExtensionOpsMixin,
)
from typing_extensions import Self

from pandas._libs import (
    NaT as NaT,
    NaTType as NaTType,
)
from pandas._typing import TimeUnit

class DatelikeOps:
    def strftime(self, date_format): ...

class TimelikeOps:
    @property
    def unit(self) -> TimeUnit: ...
    def as_unit(self, unit: TimeUnit) -> Self: ...
    def round(self, freq, ambiguous: str = ..., nonexistent: str = ...): ...
    def floor(self, freq, ambiguous: str = ..., nonexistent: str = ...): ...
    def ceil(self, freq, ambiguous: str = ..., nonexistent: str = ...): ...

class DatetimeLikeArrayMixin(ExtensionOpsMixin, ExtensionArray):
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self): ...
    def reshape(self, *args, **kwargs): ...
    def ravel(self, *args, **kwargs): ...
    def __iter__(self): ...
    @property
    def asi8(self) -> np.ndarray: ...
    @property
    def nbytes(self): ...
    def __array__(self, dtype=...) -> np.ndarray: ...
    @property
    def size(self) -> int: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key): ...
    def __setitem__(  # type: ignore[override] # pyright: ignore[reportIncompatibleMethodOverride]
        self, key: int | Sequence[int] | Sequence[bool] | slice, value
    ) -> None: ...
    def astype(self, dtype, copy: bool = ...): ...
    def view(self, dtype=...): ...
    def unique(self): ...
    def copy(self): ...
    def shift(self, periods: int = ..., fill_value=..., axis: int = ...): ...
    def searchsorted(self, value, side: str = ..., sorter=...): ...
    def repeat(self, repeats, *args, **kwargs): ...
    def value_counts(self, dropna: bool = ...): ...
    def map(self, mapper): ...
    def isna(self): ...
    def fillna(self, value=..., method=..., limit=...): ...
    @property
    def freq(self): ...
    @freq.setter
    def freq(self, value) -> None: ...
    @property
    def freqstr(self): ...
    @property
    def inferred_freq(self): ...
    @property
    def resolution(self): ...
    __pow__ = ...
    __rpow__ = ...
    __rmul__ = ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __sub__(self, other): ...
    def __rsub__(self, other): ...
    def __iadd__(self, other): ...
    def __isub__(self, other): ...
    def min(self, *, axis=..., skipna: bool = ..., **kwargs): ...
    def max(self, *, axis=..., skipna: bool = ..., **kwargs): ...
    def mean(self, *, skipna: bool = ...): ...

def maybe_infer_freq(freq): ...
