# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang-cl",
                "linker": r"lld-link",
                "version": "14.0.6",
                "commands": r"clang-cl.exe",
                "args": r"-IC:\Users\dev-admin\cr_scipy-release\scipy_1731630818606\work\scipy\linalg, -IC:\Users\dev-admin\cr_scipy-release\scipy_1731630818606\work\scipy\_lib",
                "linker args": r"",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.0.11",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang-cl",
                "linker": r"lld-link",
                "version": "14.0.6",
                "commands": r"clang-cl.exe",
                "args": r"",
                "linker args": r"",
            },
            "fortran": {
                "name": "intel-cl",
                "linker": r"xilink",
                "version": "2021.6.0",
                "commands": r"ifort",
                "args": r"",
                "linker args": r"",
            },
            "pythran": {
                "version": r"0.16.1",
                "include directory": r"..\..\_h_env\Lib\site-packages\pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"windows",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"windows",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "mkl-sdl",
                "found": bool("True".lower().replace('false', '')),
                "version": "2023.1",
                "detection method": "pkgconfig",
                "include directory": r"C:/Users/dev-admin/cr_scipy-release/scipy_1731630818606/_h_env/Library/include",
                "lib directory": r"C:/Users/dev-admin/cr_scipy-release/scipy_1731630818606/_h_env/Library/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"C:\Users\dev-admin\cr_scipy-release\scipy_1731630818606\_h_env\Library\lib\pkgconfig",
            },
            "lapack": {
                "name": "mkl-sdl",
                "found": bool("True".lower().replace('false', '')),
                "version": "2023.1",
                "detection method": "pkgconfig",
                "include directory": r"C:/Users/dev-admin/cr_scipy-release/scipy_1731630818606/_h_env/Library/include",
                "lib directory": r"C:/Users/dev-admin/cr_scipy-release/scipy_1731630818606/_h_env/Library/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"C:\Users\dev-admin\cr_scipy-release\scipy_1731630818606\_h_env\Library\lib\pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.12.1",
                "detection method": "pkgconfig",
                "include directory": r"C:/Users/dev-admin/cr_scipy-release/scipy_1731630818606/_h_env/Library/include",
            },
        },
        "Python Information": {
            "path": r"C:\Users\dev-admin\cr_scipy-release\scipy_1731630818606\_h_env\python.exe",
            "version": "3.13",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
