## ------------------------------------------------------------------------
library(formattable)
p <- percent(c(0.1, 0.02, 0.03, 0.12))
p

## ------------------------------------------------------------------------
p + 0.05
p + percent(0.02)
p * 1.1

## ------------------------------------------------------------------------
max(p)
mean(p)

## ------------------------------------------------------------------------
p[1:3]
p[[2]]

## ------------------------------------------------------------------------
p[[3]] <- 0.05
p

## ------------------------------------------------------------------------
balance <- accounting(c(1000, 500, 200, -150, 0, 1200))
balance
balance + 1000

## ------------------------------------------------------------------------
dates <- formattable(as.Date(c("2016-05-01", "2016-05-10")), format = "%Y%m%d")
dates
dates + 30

## ------------------------------------------------------------------------
lv <- formattable(c(TRUE, FALSE, FALSE, TRUE), "yes", "no")
lv
!lv

## ------------------------------------------------------------------------
lv[[1]]
isTRUE(lv[[1]])

## ------------------------------------------------------------------------
all(lv)
any(lv)

## ------------------------------------------------------------------------
pm <- matrix(rnorm(6, 0.8, 0.1), 2, 3, 
  dimnames = list(c("a", "b"), c("X", "Y", "Z")))
pm

## ------------------------------------------------------------------------
fpm <- percent(pm)
fpm

## ------------------------------------------------------------------------
fpm["a", c("Y", "Z")]

## ------------------------------------------------------------------------
pa <- array(rnorm(12, 0.8, 0.1), c(2, 3, 2))
pa

## ------------------------------------------------------------------------
percent(pa)

## ------------------------------------------------------------------------
p <- data.frame(
  id = c(1, 2, 3, 4, 5), 
  name = c("A1", "A2", "B1", "B2", "C1"),
  balance = accounting(c(52500, 36150, 25000, 18300, 7600), format = "d"),
  growth = percent(c(0.3, 0.3, 0.1, 0.15, 0.15), format = "d"),
  ready = formattable(c(TRUE, TRUE, FALSE, FALSE, TRUE), "yes", "no"))
p

## ------------------------------------------------------------------------
p[1:3, c("name", "balance", "growth")]

