# Copyright (c) 2015 Microsoft Corporation All Rights Reserved

session <- RevoIOQ:::saveRUnitSession(packages=c("survival","splines"))

	##Reference for KM and coxph tests
	##Peter Daalgard. Introductory Statistics with R.
	##Springer, 2002.
	
	##The melanom data frame contains the following columns:
	##no: patient ID
	##status: survival status (1: dead from melanoma, 2: alive, 3: dead from other cause)
	##days: observation time in days
	##ulc: ulceration (1: present, 2: absent)
	##thick: tumor thickness (1/100 mm).
	##sex: gender (1: female, 2: male) 
	
melanom <- data.frame(no = c(789, 13, 97, 16, 21, 469, 685, 7, 
932, 944, 558, 612, 2, 233, 418, 765, 777, 61, 67, 
819, 10, 15, 47, 9, 907, 758, 8, 400, 232, 18, 4, 
373, 43, 498, 17, 834, 779, 549, 608, 631, 834, 322, 
432, 57, 811, 455, 971, 29, 636, 10, 3, 66, 468, 790, 
130, 402, 808, 83, 390, 346, 802, 892, 605, 466, 310, 
966, 113, 804, 992, 748, 494, 533, 878, 11, 2, 910, 
982, 293, 327, 20, 490, 576, 205, 890, 746, 901, 394, 
943, 571, 602, 342, 726, 393, 61, 695, 858, 272, 70, 
208, 278, 232, 389, 52, 697, 230, 830, 135, 372, 768, 
599, 761, 644, 401, 234, 31, 11, 676, 236, 988, 670, 
720, 737, 24, 974, 875, 412, 338, 476, 531, 208, 441, 
414, 458, 14, 530, 124, 514, 572, 609, 50, 27, 522, 
359, 756, 396, 986, 290, 748, 535, 717, 887, 600, 698, 
664, 84, 311, 955, 731, 222, 221, 824, 977, 194, 320, 
842, 422, 745, 652, 735, 469, 510, 558, 734, 16, 327, 
459, 382, 624, 446, 809, 148, 536, 464, 240, 658, 123, 
518, 809, 554, 508, 445, 472, 294, 548, 415, 86, 175, 
493, 536, 52, 317, 798, 806, 606, 328), status = 
as.factor(c(3, 3, 2, 3, 1, 1, 1, 1, 3, 1, 1, 3, 
1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
1, 2, 1, 2, 2, 2, 1, 3, 2, 1, 2, 1, 2, 1, 2, 1, 
2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 
2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 1, 1, 2, 3, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 
2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 
2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 
2, 2, 2, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 
2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2)), 
days = c(10, 30, 35, 99, 185, 204, 210, 232, 232, 279, 
295, 355, 386, 426, 469, 493, 529, 621, 629, 659, 667, 
718, 752, 779, 793, 817, 826, 833, 858, 869, 872, 967, 
977, 982, 1041, 1055, 1062, 1075, 1156, 1228, 1252, 1271, 
1312, 1427, 1435, 1499, 1506, 1508, 1510, 1512, 1516, 1525, 
1542, 1548, 1557, 1560, 1563, 1584, 1605, 1621, 1627, 
1634, 1641, 1641, 1648, 1652, 1654, 1654, 1667, 1678, 
1685, 1690, 1710, 1710, 1726, 1745, 1762, 1779, 1787, 
1787, 1793, 1804, 1812, 1836, 1839, 1839, 1854, 1856, 
1860, 1864, 1899, 1914, 1919, 1920, 1927, 1933, 1942, 
1955, 1956, 1958, 1963, 1970, 2005, 2007, 2011, 2024, 
2028, 2038, 2056, 2059, 2061, 2062, 2075, 2085, 2102, 
2103, 2104, 2108, 2112, 2150, 2156, 2165, 2209, 2227, 
2227, 2256, 2264, 2339, 2361, 2387, 2388, 2403, 2426, 
2426, 2431, 2460, 2467, 2492, 2493, 2521, 2542, 2559, 
2565, 2570, 2660, 2666, 2676, 2738, 2782, 2787, 2984, 
3032, 3040, 3042, 3067, 3079, 3101, 3144, 3152, 3154, 
3180, 3182, 3185, 3199, 3228, 3229, 3278, 3297, 3328, 
3330, 3338, 3383, 3384, 3385, 3388, 3402, 3441, 3458, 
3459, 3459, 3476, 3523, 3667, 3695, 3695, 3776, 3776, 
3830, 3856, 3872, 3909, 3968, 4001, 4103, 4119, 4124, 
4207, 4310, 4390, 4479, 4492, 4668, 4688, 4926, 5565
), ulc = as.factor(c(1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 
2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 
2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 1, 2, 
1, 2, 1, 2, 2, 1, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 
1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 
1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 
1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 
1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 
2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 
2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 
1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2
)), thick = c(676, 65, 134, 290, 1208, 484, 516, 1288, 
322, 741, 419, 16, 387, 484, 242, 1256, 580, 706, 548, 
773, 1385, 234, 419, 404, 484, 32, 854, 258, 356, 354, 
97, 483, 162, 644, 1466, 258, 387, 354, 134, 224, 387, 
354, 1742, 129, 322, 129, 451, 838, 194, 16, 258, 129, 
16, 162, 129, 210, 32, 81, 113, 516, 162, 137, 24, 
81, 129, 129, 97, 113, 580, 129, 48, 162, 226, 58, 
97, 258, 81, 354, 97, 178, 194, 129, 322, 153, 129, 
162, 162, 32, 484, 129, 97, 306, 354, 162, 258, 194, 
81, 773, 97, 1288, 258, 409, 64, 97, 322, 162, 387, 
32, 32, 322, 226, 306, 258, 65, 113, 81, 97, 176, 
194, 65, 97, 564, 966, 10, 548, 226, 483, 97, 97, 
516, 81, 290, 387, 194, 16, 64, 226, 145, 482, 129, 
789, 81, 354, 129, 64, 322, 145, 48, 194, 16, 16, 
129, 194, 354, 81, 65, 709, 16, 162, 162, 129, 612, 
48, 64, 322, 194, 258, 258, 81, 81, 322, 32, 322, 
274, 484, 162, 65, 145, 65, 129, 162, 354, 322, 65, 
103, 709, 129, 65, 178, 1224, 806, 81, 210, 387, 65, 
194, 65, 210, 194, 113, 706, 612, 48, 226, 290), 
sex = as.factor(c(2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 
1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 
1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 
2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 
2, 1, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 2, 
2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 
2, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 
1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 
2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 
1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 
2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 
2, 1, 1, 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1)))

attach(melanom)

require(survival)


"KM.test.stress" <- function()
{
##Censor by "dead from other causes"
surv.all <- survfit(Surv(days, status==1)~1)
summary(surv.all)
##Display graphical estimate
plot(surv.all)
##Obtain survival functions split by gender
surv.bysex <- survfit(Surv(days, status==1)~sex)
summary(surv.bysex)
##Display graphical estimates with confidence intervals
plot(surv.bysex, conf.int=T)
dev.off()
}

"logrank.test.stress" <- function()
{
survdiff(Surv(days, status==1)~ sex)
##stratified by ulceration:
survdiff(Surv(days, status==1)~ sex + strata(ulc))
}

"coxph.test.stress" <- function()
{
##Single regressor
fit.single <- summary(coxph(Surv(days, status==1) ~ sex))

##Continuous covariate and stratifed across ulceration
fit.strat <- summary(coxph(Surv(days, status == 1) ~ sex + log(thick) + strata(ulc)))

}


"test.KM.test.stress" <- function()
{
    res <- try(KM.test.stress())
    checkTrue(!is(res, "try-error"), msg="KM stress test failed")    
}

"test.logrank.test.stress" <- function()
{
    res <- try(logrank.test.stress())
    checkTrue(!is(res, "try-error"), msg="logrank stress test failed")    
}

"test.coxph.test.stress" <- function()
{
    res <- try(coxph.test.stress())
    checkTrue(!is(res, "try-error"), msg="coxph stress test failed")    
}

"testzzz.restore.session" <- function()
{
  if ("melanom" %in% search()) detach("melanom")
  #rm(melanom)   
  checkTrue(RevoIOQ:::restoreRUnitSession(session), msg="Session restoration failed")
}


